<?php
/**
 * gallery Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add gallery section
$wp_customize->add_section( 'tp_coast_gallery_section', array(
	'title'             => esc_html__( 'Gallery','tp-coast' ),
	'description'       => esc_html__( 'Gallery Section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_front_page_panel',
) );

// gallery content enable control and setting
$wp_customize->add_setting( 'tp_coast_theme_options[gallery_section_enable]', array(
	'default'			=> 	$options['gallery_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[gallery_section_enable]', array(
	'label'             => esc_html__( 'Gallery Section Enable', 'tp-coast' ),
	'section'           => 'tp_coast_gallery_section',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[gallery_section_enable]', array(
		'selector'            => '#tp_coast_gallery_section .tooltiptext',
		'settings'            => 'tp_coast_theme_options[gallery_section_enable]',
    ) );
}

// Sub Title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[gallery_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default' => $options['gallery_sub_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'tp_coast_theme_options[gallery_sub_title]', array(
	'label'             => sprintf( esc_html__( 'Section Sub Title', 'tp-coast' ) ),
	'section'        	=> 'tp_coast_gallery_section',
	'active_callback' 	=> 'tp_coast_is_gallery_section_enable',
	'type'				=> 'text',
	) );

	// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[gallery_sub_title]', array(
		'selector'            => '#tp_coast-gallery .section-header p.section-subtitle',
		'settings'            => 'tp_coast_theme_options[gallery_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_gallery_sub_title_partial',
    ) );
}

// Title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[gallery_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default' => $options['gallery_title'],
	'transport'			=> 'postMessage',
	) );

$wp_customize->add_control( 'tp_coast_theme_options[gallery_title]', array(
	'label'             => sprintf( esc_html__( 'Section Title', 'tp-coast' ) ),
	'section'        	=> 'tp_coast_gallery_section',
	'active_callback' 	=> 'tp_coast_is_gallery_section_enable',
	'type'				=> 'text',
	) );

	// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[gallery_title]', array(
		'selector'            => '#tp_coast-gallery h2.section-title',
		'settings'            => 'tp_coast_theme_options[gallery_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_gallery_title_partial',
    ) );
}

	// gallery count is 6 as of now
for ( $i = 1; $i <= $options['gallery_count']; $i++ ) :

	$wp_customize->add_setting( 'tp_coast_theme_options[gallery_image_' .$i. ']', array(
		'sanitize_callback' => 'tp_coast_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'tp_coast_theme_options[gallery_image_' .$i. ']',
			array(
			'label'       		=> esc_html__( 'Gallery Image ', 'tp-coast' ).$i,
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'tp-coast' ), 650, 700 ),
			'section'     		=> 'tp_coast_gallery_section',
			'active_callback'	=> 'tp_coast_is_gallery_section_enable',
	) ) );

endfor;


