<?php
/**
 * Featured Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add Featured section
$wp_customize->add_section( 'tp_coast_featured_section', array(
	'title'             => esc_html__( 'Featured','tp-coast' ),
	'description'       => esc_html__( 'Featured Section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_front_page_panel',
) );

// Featured content enable control and setting
$wp_customize->add_setting( 'tp_coast_theme_options[featured_section_enable]', array(
	'default'			=> 	$options['featured_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[featured_section_enable]', array(
	'label'             => esc_html__( 'Featured Section Enable', 'tp-coast' ),
	'section'           => 'tp_coast_featured_section',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// blog title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[featured_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[featured_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_featured_section',
	'active_callback' 	=> 'tp_coast_is_featured_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[featured_sub_title]', array(
		'selector'            => '#tp_coast-interest .section-content p',
		'settings'            => 'tp_coast_theme_options[featured_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_featured_sub_title_partial',
    ) );
}

$wp_customize->add_setting( 'tp_coast_theme_options[featured_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['featured_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[featured_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_featured_section',
	'active_callback' 	=> 'tp_coast_is_featured_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[featured_title]', array(
		'selector'            => '#tp_coast-interest .section-header h2.section-title',
		'settings'            => 'tp_coast_theme_options[featured_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_featured_title_partial',
    ) );
}

for ($i = 1; $i <= $options['featured_count']; $i++) {
	// featured trips drop down chooser control and setting
	$wp_customize->add_setting( 'tp_coast_theme_options[featured_content_trip_' . $i . ']', array(
		'sanitize_callback' => 'tp_coast_sanitize_page',
	) );

	$wp_customize->add_control( new TP_Coast_Dropdown_Chooser( $wp_customize, 'tp_coast_theme_options[featured_content_trip_' . $i . ']', array(
		'label'             => sprintf ( esc_html__( 'Select Trip %d', 'tp-coast' ), $i ),
		'section'           => 'tp_coast_featured_section',
		'choices'			=> tp_coast_trip_choices(),
	) ) );
}

