<?php

/**
 * Destination Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add Destination section
$wp_customize->add_section('tp_coast_destination_section', array(
	'title'             => esc_html__('Destination', 'tp-coast'),
	'description'       => esc_html__('Destination Section options.', 'tp-coast'),
	'panel'             => 'tp_coast_front_page_panel',
));

// Destination content enable control and setting
$wp_customize->add_setting('tp_coast_theme_options[destination_section_enable]', array(
	'default'			=> 	$options['destination_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
));

$wp_customize->add_control(new TP_Coast_Switch_Control($wp_customize, 'tp_coast_theme_options[destination_section_enable]', array(
	'label'             => esc_html__('Destination Section Enable', 'tp-coast'),
	'section'           => 'tp_coast_destination_section',
	'on_off_label' 		=> tp_coast_switch_options(),
)));

// destination title setting and control
$wp_customize->add_setting('tp_coast_theme_options[destination_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['destination_sub_title'],
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[destination_sub_title]', array(
	'label'           	=> esc_html__('Section Sub Title', 'tp-coast'),
	'section'        	=> 'tp_coast_destination_section',
	'active_callback' 	=> 'tp_coast_is_destination_section_enable',
	'type'				=> 'text',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[destination_sub_title]', array(
		'selector'            => '#tp_coast_destination_section .section-content p',
		'settings'            => 'tp_coast_theme_options[destination_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_destination_sub_title_partial',
	));
}

$wp_customize->add_setting('tp_coast_theme_options[destination_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['destination_title'],
	'transport'			=> 'postMessage',
));

$wp_customize->add_control('tp_coast_theme_options[destination_title]', array(
	'label'           	=> esc_html__('Section Title', 'tp-coast'),
	'section'        	=> 'tp_coast_destination_section',
	'active_callback' 	=> 'tp_coast_is_destination_section_enable',
	'type'				=> 'text',
));

// Abort if selective refresh is not available.
if (isset($wp_customize->selective_refresh)) {
	$wp_customize->selective_refresh->add_partial('tp_coast_theme_options[destination_title]', array(
		'selector'            => '#tp_coast_destination_section .section-header h2.section-title',
		'settings'            => 'tp_coast_theme_options[destination_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_destination_title_partial',
	));
}

for ($i = 1; $i <= 4; $i++) {
	// Add dropdown destination setting and control.
	$wp_customize->add_setting('tp_coast_theme_options[destination_content_destination_' . $i . ']', array(
		'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control(new TP_Coast_Dropdown_Taxonomies_Control($wp_customize, 'tp_coast_theme_options[destination_content_destination_' . $i . ']', array(
		'label'             => sprintf(esc_html__('Select Destinations %d ', 'tp-coast'), $i),
		'section'           => 'tp_coast_destination_section',
		'taxonomy'			=> 'travel_locations',
		'type'              => 'dropdown-taxonomies',
	)));

}


