<?php
/**
 * Counter Section options
 *
 * @package Theme Palace
 * @subpackage Blog Diary Pro
 * @since Blog Diary Pro 1.0.0
 */

// Add Counter section
$wp_customize->add_section( 'tp_coast_counter_section', array(
	'title'             => esc_html__( 'Counter','tp-coast' ),
	'description'       => esc_html__( 'Counter Section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_front_page_panel',

) );

// Counter content enable control and setting
$wp_customize->add_setting( 'tp_coast_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Counter Section Enable', 'tp-coast' ),
	'section'           => 'tp_coast_counter_section',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[counter_section_enable]', array(
		'selector'            => '#counter-section .tooltiptext',
		'settings'            => 'tp_coast_theme_options[counter_section_enable]',
    ) );
}

// counter background image setting and control.
$wp_customize->add_setting( 'tp_coast_theme_options[counter_image]', array(
	'sanitize_callback' => 'tp_coast_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'tp_coast_theme_options[counter_image]',
		array(
		'label'       		=> esc_html__( 'Counter BG Image', 'tp-coast' ),
		'section'     		=> 'tp_coast_counter_section',
		'active_callback'	=> 'tp_coast_is_counter_section_enable',
) ) );


// counter title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[counter_banner_title]', array(
	'default'			=> $options['counter_banner_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[counter_banner_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_counter_section',
	'active_callback' 	=> 'tp_coast_is_counter_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[counter_banner_title]', array(
		'selector'            => '#tp_coast_counter h2.entry-title',
		'settings'            => 'tp_coast_theme_options[counter_banner_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_counter_banner_title_partial',
    ) );
}

// counter subtitle setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[counter_banner_sub_title]', array(
	'default'			=> $options['counter_banner_sub_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[counter_banner_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_counter_section',
	'active_callback' 	=> 'tp_coast_is_counter_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[counter_banner_sub_title]', array(
		'selector'            => '#tp_coast_counter .entry-content p',
		'settings'            => 'tp_coast_theme_options[counter_banner_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_counter_banner_title_partial',
    ) );
}

for ( $i = 1; $i <=3; $i++ ) :
	
// counter title setting and control
	$wp_customize->add_setting( 'tp_coast_theme_options[counter_title_' . $i . ']',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			)
		);

	// counter title setting and control
	$wp_customize->add_setting( 'tp_coast_theme_options[counter_value_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'tp_coast_theme_options[counter_value_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Value %d', 'tp-coast' ), $i ),
		'section'        	=> 'tp_coast_counter_section',
		'active_callback' 	=> 'tp_coast_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter position setting and control
	$wp_customize->add_setting( 'tp_coast_theme_options[counter_label_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'tp_coast_theme_options[counter_label_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Label %d', 'tp-coast' ), $i ),
		'section'        	=> 'tp_coast_counter_section',
		'active_callback' 	=> 'tp_coast_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter hr setting and control
	$wp_customize->add_setting( 'tp_coast_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new TP_Coast_Customize_Horizontal_Line( $wp_customize, 'tp_coast_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'tp_coast_counter_section',
			'active_callback' => 'tp_coast_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;