<?php
/**
 * Blog Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add Blog section
$wp_customize->add_section( 'tp_coast_blog_section', array(
	'title'             => esc_html__( 'Blog','tp-coast' ),
	'description'       => esc_html__( 'Blog Section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_front_page_panel',
) );

// Blog content enable control and setting
$wp_customize->add_setting( 'tp_coast_theme_options[blog_section_enable]', array(
	'default'			=> 	$options['blog_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[blog_section_enable]', array(
	'label'             => esc_html__( 'Blog Section Enable', 'tp-coast' ),
	'section'           => 'tp_coast_blog_section',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// blog title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[blog_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[blog_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_blog_section',
	'active_callback' 	=> 'tp_coast_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[blog_sub_title]', array(
		'selector'            => '#tp_coast-blog .section-header p.section-subtitle',
		'settings'            => 'tp_coast_theme_options[blog_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_blog_sub_title_partial',
    ) );
}

// blog title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[blog_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[blog_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_blog_section',
	'active_callback' 	=> 'tp_coast_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[blog_title]', array(
		'selector'            => '#tp_coast-blog .section-header h2.section-title',
		'settings'            => 'tp_coast_theme_options[blog_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_blog_title_partial',
    ) );
}



// blog btn title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[blog_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[blog_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'tp-coast' ),
	'section'        	=> 'tp_coast_blog_section',
	'active_callback' 	=> 'tp_coast_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[blog_btn_title]', array(
		'selector'            => '#tp_coast-blog .read-more a.btn',
		'settings'            => 'tp_coast_theme_options[blog_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_blog_btn_title_partial',
    ) );
}


// Add dropdown category setting and control.
$wp_customize->add_setting(  'tp_coast_theme_options[blog_content_category]', array(
	'sanitize_callback' => 'tp_coast_sanitize_single_category',
) ) ;

$wp_customize->add_control( new TP_Coast_Dropdown_Taxonomies_Control( $wp_customize,'tp_coast_theme_options[blog_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'tp-coast' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'tp-coast' ),
	'section'           => 'tp_coast_blog_section',
	'type'              => 'dropdown-taxonomies',
) ) );
