<?php
/**
 * About Section options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

// Add About section
$wp_customize->add_section( 'tp_coast_about_section', array(
	'title'             => esc_html__( 'About Us','tp-coast' ),
	'description'       => esc_html__( 'About Us Section options.', 'tp-coast' ),
	'panel'             => 'tp_coast_front_page_panel',
) );

// About content enable control and setting
$wp_customize->add_setting( 'tp_coast_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'tp_coast_sanitize_switch_control',
) );

$wp_customize->add_control( new TP_Coast_Switch_Control( $wp_customize, 'tp_coast_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'About Section Enable', 'tp-coast' ),
	'section'           => 'tp_coast_about_section',
	'on_off_label' 		=> tp_coast_switch_options(),
) ) );

// about title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[about_title]', array(
	'label'           	=> esc_html__( 'Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_about_section',
	'active_callback' 	=> 'tp_coast_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[about_title]', array(
		'selector'            => '#tp_coast-about-us .content-align-left h2.section-title',
		'settings'            => 'tp_coast_theme_options[about_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_about_title_partial',
    ) );
}

// about title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[about_sub_title]', array(
	'label'           	=> esc_html__( 'Sub Title', 'tp-coast' ),
	'section'        	=> 'tp_coast_about_section',
	'active_callback' 	=> 'tp_coast_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[about_sub_title]', array(
		'selector'            => '#tp_coast-about-us .content-align-left .section-subtitle p',
		'settings'            => 'tp_coast_theme_options[about_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_about_sub_title_partial',
    ) );
}

// about description setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['about_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[about_description]', array(
	'label'           	=> esc_html__( 'Description', 'tp-coast' ),
	'section'        	=> 'tp_coast_about_section',
	'active_callback' 	=> 'tp_coast_is_about_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[about_description]', array(
		'selector'            => '#tp_coast-about-us .content-align-left p.tp_coast-paragraph',
		'settings'            => 'tp_coast_theme_options[about_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_about_description_partial',
    ) );
}

// about btn title setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['about_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'tp_coast_theme_options[about_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'tp-coast' ),
	'section'        	=> 'tp_coast_about_section',
	'active_callback' 	=> 'tp_coast_is_about_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'tp_coast_theme_options[about_btn_title]', array(
		'selector'            => '#tp_coast-about-us .content-align-left .more-button a',
		'settings'            => 'tp_coast_theme_options[about_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'tp_coast_about_btn_title_partial',
    ) );
}

// about btn link setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
	'default'			=> $options['about_btn_link'],
) );

$wp_customize->add_control( 'tp_coast_theme_options[about_btn_link]', array(
	'label'           	=> esc_html__( 'Button Link', 'tp-coast' ),
	'section'        	=> 'tp_coast_about_section',
	'active_callback' 	=> 'tp_coast_is_about_section_content_custom_enable',
	'type'				=> 'url',
) );

// about_us side image setting and control
$wp_customize->add_setting( 'tp_coast_theme_options[about_us_background]', array(
	'sanitize_callback' => 'tp_coast_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'tp_coast_theme_options[about_us_background]',
		array(
		'label'       		=> esc_html__( 'Select Image ', 'tp-coast' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'tp-coast' ), 640, 800 ),
		'section'     		=> 'tp_coast_about_section',
		'active_callback'	=> 'tp_coast_is_about_section_content_custom_enable',
) ) );
