<?php
/**
 * Customizer default options
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 * @return array An array of default values
 */
function tp_coast_get_default_theme_options() {
	$theme_data = wp_get_theme();
	$tp_coast_default_options = array(
		// Color Options
		'header_title_color'			=> '#000',
		'header_tagline_color'			=> '#000',
		'header_txt_logo_extra'			=> 'show-all',
		'colorscheme_hue'				=> '#00afe9',		

		// breadcrumb
		'breadcrumb_enable'				=> true,
		'breadcrumb_separator'			=> '/',
		
		// layout 
		'site_layout'         			=> 'wide-layout',
		'sidebar_position'         		=> 'right-sidebar',
		'post_sidebar_position' 		=> 'right-sidebar',
		'page_sidebar_position' 		=> 'right-sidebar',


		// excerpt options
		'long_excerpt_length'           => 25,
		
		// pagination options
		'pagination_enable'         	=> true,
		'pagination_type'         		=> 'default',

		// footer options
		'copyright_text'           		=> sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'tp-coast' ), '[the-year]', '[site-link]' ),
		'powered_by_text'           	=> esc_html__( ' | All Rights Reserved | ', 'tp-coast' ) . esc_html( $theme_data->get( 'Name') ) . '&nbsp;' . esc_html__( 'by', 'tp-coast' ). '&nbsp;<a target="_blank" href="'. esc_url( $theme_data->get( 'AuthorURI' ) ) .'">'. esc_html( ucwords( $theme_data->get( 'Author' ) ) ) .'</a>',
		'scroll_top_visible'        	=> true,

		// reset options
		'reset_options'      			=> false,
		
		// homepage options
		'enable_frontpage_content' 		=> false,

		// homepage sections sortable
		'default_sortable' 				=> 'hero_banner,about,destination,featured,gallery,blog',

		// blog/archive options
		'your_latest_posts_title' 		=> esc_html__( 'Blogs', 'tp-coast' ),
		'hide_btn' 						=> false,
		'hide_category'					=> false,
		'hide_content'					=> false,
		'hide_image'					=> false,

		// single post theme options
		'single_post_hide_date' 		=> false,
		'single_post_hide_author'		=> false,
		'single_post_hide_category'		=> false,
		'single_post_hide_tags'			=> false,

		/* Front Page */

		// hero_banner
		'hero_banner_sub_title'			=> esc_html__( 'Amazing', 'tp-coast' ),
		'hero_banner_title'				=> esc_html__( 'Thailand', 'tp-coast' ),
		'hero_banner_content'				=> esc_html__( 'A couple of years ago, I decided to stop taking photographs. I have never been one to hold on to physical possessions. It only felt right, then, that I rid myself the escape of digital one, too.', 'tp-coast' ),
		'hero_banner_btn_label'				=> esc_html__( 'Exploere Now', 'tp-coast' ),
		'hero_banner_section_enable'	=> true,
		'hero_banner_background'        => esc_html('','tp-coast'),


		// about us
		'about_section_enable'			=> true,
		'about_section_enable_second_section'=> false,
		'about_title'					=> esc_html__( 'Always Helpin You Find Your Dream Tour', 'tp-coast' ),
		'about_sub_title'				=> esc_html__( 'About Us', 'tp-coast' ),
		'about_description'				=> esc_html__( 'A couple of years ago, I decided to stop taking photographs. I have never been one to hold on to physical possessions. It only felt right, then, that I ride myself the escape of digital one, too.', 'tp-coast' ),
		'about_btn_title'				=> esc_html__( 'Know TP Coast Theme', 'tp-coast' ),
		'about_btn_link'				=> '#',
		'about_us_background'	    	=> esc_url('#', 'tp-coast'),


		// blog
		'blog_section_enable'			=> true,
		'blog_count'					=> 3,
		'blog_title'					=> esc_html__( 'Our Recent Articles', 'tp-coast' ),
		'blog_sub_title'				=> esc_html__( 'Whats Happening', 'tp-coast' ),
		'blog_btn_title'				=> esc_html__( 'Read More', 'tp-coast' ),


		// gallery
		'gallery_section_enable'	=> true,
		'gallery_count'				=> 6,
		'gallery_title'				=> esc_html__( 'Make Memories All Around The World', 'tp-coast' ),
		'gallery_sub_title'			=> esc_html__( 'Our Gallery', 'tp-coast' ),




		//destination
		'destination_section_enable'	=> true,
		'destination_auto_play'			=> true,
		'destination_content_destination'  => '',
		'destination_count'				=> 4,
		'destination_title'				=> esc_html__( 'We Provide Best Destinations For You', 'tp-coast' ),
		'destination_sub_title'			=> esc_html__( 'A couple of years ago, I decided to stop taking photographs. I have never been one to hold on to physical possessions. It only felt right, then, that I rid myself the escape of digital one, too', 'tp-coast' ),
		'destination_select'			=> false,

		// featured
		'featured_section_enable'	=> true,
		'featured_auto_play'		=> false,
		'featured_count'			=> 4,
		'featured_title'			=> esc_html__( 'Browse By An Interest', 'tp-coast' ),
		'featured_sub_title'		=> esc_html__( 'A couple of years ago, I decided to stop taking photographs. I have never been one to hold on to physical possessions. It only felt right, then, that I rid myself the escape of digital one, too', 'tp-coast' ),
	);

	$output = apply_filters( 'tp_coast_default_theme_options', $tp_coast_default_options );

	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}