<?php
/**
 * TP Coast Customizer.
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function tp_coast_customize_register( $wp_customize ) {

	$options = tp_coast_get_theme_options();


	// Load custom control functions.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callback.php';

	// Load partial callback functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load validation callback functions.
	require get_template_directory() . '/inc/customizer/validation.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	// Remove the core header textcolor control, as it shares the main text color.
	$wp_customize->remove_control( 'header_textcolor' );

	// Header title color setting and control.
	$wp_customize->add_setting( 'tp_coast_theme_options[header_title_color]', array(
		'default'           => $options['header_title_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tp_coast_theme_options[header_title_color]', array(
		'priority'			=> 5,
		'label'             => esc_html__( 'Header Title Color', 'tp-coast' ),
		'section'           => 'colors',
	) ) );

	// Header tagline color setting and control.
	$wp_customize->add_setting( 'tp_coast_theme_options[header_tagline_color]', array(
		'default'           => $options['header_tagline_color'],
		'sanitize_callback' => 'sanitize_hex_color',
		'transport'			=> 'postMessage'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tp_coast_theme_options[header_tagline_color]', array(
		'priority'			=> 6,
		'label'             => esc_html__( 'Header Tagline Color', 'tp-coast' ),
		'section'           => 'colors',
	) ) );

	// Site identity extra options.
	$wp_customize->add_setting( 'tp_coast_theme_options[header_txt_logo_extra]', array(
		'default'           => $options['header_txt_logo_extra'],
		'sanitize_callback' => 'tp_coast_sanitize_select',
		'transport'			=> 'refresh'
	) );

	$wp_customize->add_control( 'tp_coast_theme_options[header_txt_logo_extra]', array(
		'priority'			=> 50,
		'type'				=> 'radio',
		'label'             => esc_html__( 'Site Identity Extra Options', 'tp-coast' ),
		'section'           => 'title_tagline',
		'choices'				=> array( 
			'hide-all'     => esc_html__( 'Hide All', 'tp-coast' ),
			'show-all'     => esc_html__( 'Show All', 'tp-coast' ),
			'title-only'   => esc_html__( 'Title Only', 'tp-coast' ),
			'tagline-only' => esc_html__( 'Tagline Only', 'tp-coast' ),
			'logo-title'   => esc_html__( 'Logo + Title', 'tp-coast' ),
			'logo-tagline' => esc_html__( 'Logo + Tagline', 'tp-coast' ),
			)
	) );


	// Add panel for common theme options
	$wp_customize->add_panel( 'tp_coast_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','tp-coast' ),
	    'description'=> esc_html__( 'TP Coast Theme Options.', 'tp-coast' ),
	    'priority'   => 150,
	) );

	// breadcrumb
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// load layout
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// load static homepage option
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// load archive option
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// load pagination option
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// load footer option
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// load reset option
	require get_template_directory() . '/inc/customizer/theme-options/reset.php';


	// Add panel for front page theme options.
	$wp_customize->add_panel( 'tp_coast_front_page_panel' , array(
	    'title'      => esc_html__( 'Front Page','tp-coast' ),
	    'description'=> esc_html__( 'Front Page Theme Options.', 'tp-coast' ),
	    'priority'   => 140,
	) );


	foreach ( explode( ',', $options['default_sortable'] ) as $list ) {
		require get_template_directory() . '/inc/customizer/sections/'.str_replace( '_', '-', $list).'.php';
	}

}
add_action( 'customize_register', 'tp_coast_customize_register' );

/*
 * Load customizer sanitization functions.
 */
require get_template_directory() . '/inc/customizer/sanitize.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function tp_coast_customize_preview_js() {
	wp_enqueue_script( 'tp_coast-customizer', get_template_directory_uri() . '/assets/js/customizer' . tp_coast_min() . '.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'tp_coast_customize_preview_js' );

/**
 * Load dynamic logic for the customizer controls area.
 */
function tp_coast_customize_control_js() {
	
	// Choose from select jquery.
	wp_enqueue_style( 'chosen-css', get_template_directory_uri() . '/assets/css/chosen' . tp_coast_min() . '.css' );
	wp_enqueue_script( 'jquery-chosen', get_template_directory_uri() . '/assets/js/chosen.jquery' . tp_coast_min() . '.js', array( 'jquery' ), '1.4.2', true );

	wp_enqueue_style( 'tp_coast-customize-controls-css', get_template_directory_uri() . '/assets/css/customize-controls.css' );
	wp_enqueue_script( 'tp_coast-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls' . tp_coast_min() . '.js', array(), '1.0', true );
	$tp_coast_reset_data = array(
		'reset_message' => esc_html__( 'Refresh the customizer page after saving to view reset effects', 'tp-coast' )
	);
	// Send list of color variables as object to custom customizer js
	wp_localize_script( 'tp_coast-customize-controls', 'tp_coast_reset_data', $tp_coast_reset_data );
}
add_action( 'customize_controls_enqueue_scripts', 'tp_coast_customize_control_js' );

if ( !function_exists( 'tp_coast_reset_options' ) ) :
	/**
	 * Reset all options
	 *
	 * @since TP Coast 1.0.0
	 *
	 * @param bool $checked Whether the reset is checked.
	 * @return bool Whether the reset is checked.
	 */
	function tp_coast_reset_options() {
		$options = tp_coast_get_theme_options();
		if ( true === $options['reset_options'] ) {
			// Reset custom theme options.
			set_theme_mod( 'tp_coast_theme_options', array() );
			// Reset custom header and backgrounds.
			remove_theme_mod( 'header_image' );
			remove_theme_mod( 'header_image_data' );
			remove_theme_mod( 'background_image' );
			remove_theme_mod( 'background_color' );
			remove_theme_mod( 'header_textcolor' );
	    }
	  	else {
		    return false;
	  	}
	}
endif;
add_action( 'customize_save_after', 'tp_coast_reset_options' );
