<?php
/**
 * Customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage TP Coast
 * @since TP Coast 1.0.0
 */

if ( ! function_exists( 'tp_coast_is_breadcrumb_enable' ) ) :
	/**
	 * Check if breadcrumb is enabled.
	 *
	 * @since TP Coast 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function tp_coast_is_breadcrumb_enable( $control ) {
		return $control->manager->get_setting( 'tp_coast_theme_options[breadcrumb_enable]' )->value();
	}
endif;

if ( ! function_exists( 'tp_coast_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since TP Coast 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function tp_coast_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'tp_coast_theme_options[pagination_enable]' )->value();
	}
endif;

if ( ! function_exists( 'tp_coast_is_static_homepage_enable' ) ) :
	/**
	 * Check if static homepage is enabled.
	 *
	 * @since TP Coast 1.0.0
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 * @return bool Whether the control is active to the current preview.
	 */
	function tp_coast_is_static_homepage_enable( $control ) {
		return ( 'page' == $control->manager->get_setting( 'show_on_front' )->value() );
	}
endif;

/**
 * Check if header button section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_primary_menu_header_button_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[primary_menu_header_button_enable]' )->value() );
}

/**
 * Front Page Active Callbacks
 */

/**
 * Check if hero_banner section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */

 
function tp_coast_is_hero_banner_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[hero_banner_section_enable]' )->value() );
}

/**
 * Check if about section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_about_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[about_section_enable]' )->value() );
}

function tp_coast_is_about_section_content_custom_enable( $control ) {
	$content_type = $control->manager->get_setting( 'tp_coast_theme_options[about_section_enable]' )->value();
	return $content_type;
}

/**
 * Check if blog section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_blog_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[blog_section_enable]' )->value() );
}

/**
 * Check if destination section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_destination_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[destination_section_enable]' )->value() );
}



/**
 * Check if featured section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_featured_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[featured_section_enable]' )->value() );
}

/**
 * Check if gallery section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_gallery_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[gallery_section_enable]' )->value() );
}

/**
 * Check if counter section is enabled.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_counter_section_enable( $control ) {
	return ( $control->manager->get_setting( 'tp_coast_theme_options[counter_section_enable]' )->value() );
}




/**
 * Check if video section content type is category.
 *
 * @since TP Coast 1.0.0
 * @param WP_Customize_Control $control WP_Customize_Control instance.
 * @return bool Whether the control is active to the current preview.
 */
function tp_coast_is_heading_tags_enable( $control ) {

	$tags = $control->manager->get_setting( 'tp_coast_theme_options[heading_tags]' )->value();
	return ($control->id == 'tp_coast_theme_options['.$tags.']');

}


