<?php
	/**
	 * The header for our theme.
	 *
	 * This is the template that displays all of the <head> section and everything up until <div id="content">
	 *
	 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
	 *
	 * @package Theme Palace
	 * @subpackage TP Coast
	 * @since TP Coast 1.0.0
	 */

	/**
	 * tp_coast_doctype hook
	 *
	 * @hooked tp_coast_doctype -  10
	 *
	 */
	do_action( 'tp_coast_doctype' );

?>
<head>


<?php
	/**
	 * tp_coast_before_wp_head hook
	 *
	 * @hooked tp_coast_head -  10
	 *
	 */
	do_action( 'tp_coast_before_wp_head' );

	wp_head(); 
?>
</head>

<body <?php body_class(); ?>>

<?php do_action( 'wp_body_open' ); ?>

<?php
	/**
	 * tp_coast_page_start_action hook
	 *
	 * @hooked tp_coast_page_start -  10
	 *
	 */
	do_action( 'tp_coast_page_start_action' ); 

	/**
	 * tp_coast_loader_action hook
	 *
	 * @hooked tp_coast_loader -  10
	 *
	 */
	do_action( 'tp_coast_before_header' );

	/**
	 * tp_coast_header_action hook
	 *
	 * @hooked tp_coast_header_start -  10
	 * @hooked tp_coast_site_branding -  20
	 * @hooked tp_coast_site_navigation -  30
	 * @hooked tp_coast_header_end -  50
	 *
	 */
	do_action( 'tp_coast_header_action' );

	/**
	 * tp_coast_content_start_action hook
	 *
	 * @hooked tp_coast_content_start -  10
	 *
	 */
	do_action( 'tp_coast_content_start_action' );

	/**
	 * tp_coast_header_image_action hook
	 *
	 * @hooked tp_coast_header_image -  10
	 *
	 */
	do_action( 'tp_coast_header_image_action' );
	if ( tp_coast_is_frontpage() ) {

    	$sorted = $sorted = explode( ',' , tp_coast_get_homepage_sections() );
		
		foreach ( $sorted as $section ) {
			add_action( 'tp_coast_primary_content', 'tp_coast_add_'. $section .'_section' );
		}

		do_action( 'tp_coast_primary_content' );
	}