<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Toocheke
 */
$home_layout = get_theme_mod('home_layout_setting', 'default');
$show_post_thumbnail =  $home_layout == 'alt-1' || $home_layout == 'alt-2' || $home_layout == 'alt-3';
set_query_var('show_post_thumbnail', $show_post_thumbnail);
?>
  <?php if ( has_post_thumbnail() && $show_post_thumbnail) { ?>
	<div class="page-hero" style="background-image: url('<?php esc_attr(the_post_thumbnail_url("full")); ?>')">
	<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</div>
	
                <?php 
                }
                ?> 
<article id="post-<?php esc_attr(the_ID()); ?>" <?php wp_kses_data((string) post_class()); ?>>
<?php if ( !has_post_thumbnail() || !$show_post_thumbnail) { ?>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->
	<?php 
                }
                ?> 



	<div class="entry-content">
		<?php
		the_content();

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'toocheke' ),
			'after'  => '</div>',
		) );
		?>
	</div><!-- .entry-content -->

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'toocheke' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
