<?php
/**
 * Template part for displaying manga layout home page
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Toocheke
 */
$hide_all_manga_series_section = get_theme_mod( 'hide_all_manga_series_setting', false );
$hide_popular_series_section = get_theme_mod( 'hide_popular_manga_series_setting', false );
$hide_popular_volumes_section = get_theme_mod( 'hide_popular_manga_volumes_setting', false );
$hide_popular_chapters_section = get_theme_mod( 'hide_popular_manga_chapters_setting', false );


?>
<div id="manga-series-container" class="row">
    <!--START LEFT COL-->
    <div class="col-lg-8">
        <div id="left-col">
            <div id="left-content">	
<!-- Manga Index Sections-->
 <?php if(!$hide_all_manga_series_section):?>
    <!-- Render All Series Grid -->
 <div id="manga-all-series-wrapper">


<h2 id="manga-series-header">
  <?php echo ( esc_html(get_theme_mod('manga_series_setting')) != "" ) 
      ? esc_html(get_theme_mod('manga_series_setting')) 
      : esc_html__('Manga Series', 'toocheke'); ?>
</h2>

<?php
// Handle filters
$selected_publisher = isset($_GET['publisher']) ? sanitize_text_field($_GET['publisher']) : '';
$selected_genre     = isset($_GET['genre']) ? sanitize_text_field($_GET['genre']) : '';

// Build query args
$args_all_series = [
    'post_type'      => 'manga_series',
    'posts_per_page' => -1,
    'orderby'        => 'title',
    'order'          => 'ASC',
];

// Add tax_query if filters are set
$tax_query = [];

if ($selected_publisher) {
    $tax_query[] = [
        'taxonomy' => 'manga_publisher',
        'field'    => 'slug',
        'terms'    => $selected_publisher,
    ];
}

if ($selected_genre) {
    $tax_query[] = [
        'taxonomy' => 'manga_genre',
        'field'    => 'slug',
        'terms'    => $selected_genre,
    ];
}

if ($tax_query) {
    $args_all_series['tax_query'] = [
        'relation' => 'AND',
        ...$tax_query
    ];
}

// Query series
$query_all_series = new WP_Query($args_all_series);

// Build filter form
?>
<form method="get" class="manga-series-filter-form">

    <div class="filter-field">
        <label for="publisher">Publisher:</label>
        <select name="publisher" id="publisher">
            <option value="">All Publishers</option>
            <?php
            $publishers = get_terms(['taxonomy' => 'manga_publisher', 'hide_empty' => true]);
            foreach ($publishers as $publisher) {
                printf(
                    '<option value="%s"%s>%s</option>',
                    esc_attr($publisher->slug),
                    selected($selected_publisher, $publisher->slug, false),
                    esc_html($publisher->name)
                );
            }
            ?>
        </select>
    </div>

    <div class="filter-field">
        <label for="genre">Genre:</label>
        <select name="genre" id="genre">
            <option value="">All Genres</option>
            <?php
            $genres = get_terms(['taxonomy' => 'manga_genre', 'hide_empty' => true]);
            foreach ($genres as $genre) {
                printf(
                    '<option value="%s"%s>%s</option>',
                    esc_attr($genre->slug),
                    selected($selected_genre, $genre->slug, false),
                    esc_html($genre->name)
                );
            }
            ?>
        </select>
    </div>

    <div class="filter-field">
        <button type="submit" class="btn-sm btn-danger btn">Filter</button>
    </div>

</form>

<hr class="toocheke-hr manga-hr" />


<?php
get_template_part('template-parts/content', 'indexmangagrid', [
    'query' => $query_all_series,
    'section_id' => '',
    'section_title' => '',
]);
?>
 </div>
<!-- ./Render All Series Grid -->
  <?php endif;?>  
   <?php if(!$hide_popular_series_section):?>

 <!-- Render Popular Series Grid -->
   <div id="manga-popular-series-wrapper">
  <?php
  $query_pop_series = new WP_Query([
    'post_type'      => 'manga_series',
    'posts_per_page' => 4,
    'orderby'        => 'meta_value_num',
    'meta_key'       => '_post_like_count',
    'order'          => 'DESC',
]);

get_template_part('template-parts/content', 'indexmangagrid', [
    'query' => $query_pop_series,
    'section_id' => 'manga-popular-series-header',
    'section_title' => ( esc_html(get_theme_mod('manga_popular_series_setting')) != "" )
        ? esc_html(get_theme_mod('manga_popular_series_setting'))
        : esc_html__('Popular Series', 'toocheke'),
]);
  ?>
   </div>
  <!-- ./Render Popular Series Grid -->
       <?php endif;?>
        <?php if(!$hide_popular_volumes_section):?>

    <!-- Render Popular Volumes Grid -->
      <div id="manga-popular-volumes-wrapper">
       <?php
       $query_pop_volumes = new WP_Query([
    'post_type'      => 'manga_volume',
    'posts_per_page' => 4,
    'orderby'        => 'meta_value_num',
    'meta_key'       => '_post_like_count',
    'order'          => 'DESC',
]);

get_template_part('template-parts/content', 'indexmangagrid', [
    'query' => $query_pop_volumes,
    'section_id' => 'manga-popular-volumes-header',
    'section_title' => ( esc_html(get_theme_mod('manga_popular_volumes_setting')) != "" )
        ? esc_html(get_theme_mod('manga_popular_volumes_setting'))
        : esc_html__('Popular Volumes', 'toocheke'),
]);
  ?>
  </div>
  <!-- ./Render Popular Volumes Grid -->
       <?php endif;?>
     <?php if(!$hide_popular_chapters_section):?>    
    <!-- Render Popular Chapters Grid -->
      <div id="manga-popular-chapters-wrapper">
       <?php
       $query_pop_chapters = new WP_Query([
    'post_type'      => 'manga_chapter',
    'posts_per_page' => 4,
    'orderby'        => 'meta_value_num',
    'meta_key'       => '_post_like_count',
    'order'          => 'DESC',
]);

get_template_part('template-parts/content', 'indexmangagrid', [
    'query' => $query_pop_chapters,
    'section_id' => 'manga-popular-chapters-header',
    'section_title' => ( esc_html(get_theme_mod('manga_popular_chapters_setting')) != "" )
        ? esc_html(get_theme_mod('manga_popular_chapters_setting'))
        : esc_html__('Popular Chapters', 'toocheke'),
]);
  ?>
  </div>
  <!-- ./Render Popular Chapters Grid -->
   <?php endif;?>
<!-- ./Manga Index Sections-->

                        <!--END CONTENT-->
                          <!--HOME BOTTOM WIDGET START-->
                <?php dynamic_sidebar('home-left-bottom');?>
                <!--HOME BOTTOM WIDGET END-->
                     </div><!--./ left-content-->
                  </div><!--./ left-col-->
               </div><!--./ col-lg-8-->
               <!--END LEFT COL-->