<?php
/**
 * Tirtha Theme Customizer.
 *
 * @package Tirtha
 */

if (class_exists('WP_Customize_Control')) {
 class tirtha_customize_textarea_control extends WP_Customize_Control {

        public $type = 'textarea';

        public function render_content() {
            ?>

            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <textarea rows="5" style="width:98%;" <?php $this->link(); ?>><?php echo esc_textarea($this->value()); ?></textarea>
            </label>

            <?php
        }

    }
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function tirtha_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

    $wp_customize->add_section( 'my_social_settings', array(
			'title'    => __('Social Icons', 'tirtha'),
			'priority' => 1,
            'description' => __('Add URL to display social icons in footer.', 'tirtha')
	) );

    $wp_customize->add_setting( 'Facebook', array(
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Facebook', array(
			'label'    => __( "Facebook url:", 'tirtha' ),
			'section'  => 'my_social_settings',
			'type'     => 'text',
			'priority' => 1,
	) );
    $wp_customize->add_setting( 'Google_plus', array(
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Google_plus', array(
			'label'    => __( "Google plus url:", 'tirtha' ),
			'section'  => 'my_social_settings',
			'type'     => 'text',
			'priority' => 2,
	) );
     $wp_customize->add_setting( 'Linkedin', array(
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control('Linkedin', array(
			'label'    => __( "Linkedin url:", 'tirtha' ),
			'section'  => 'my_social_settings',
			'type'     => 'text',
			'priority' => 3,
	) );

    $wp_customize->add_setting( 'Twitter', array(
			'type'              => 'theme_mod',
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Twitter', array(
			'label'    => __( "Twitter url:", 'tirtha' ),
			'section'  => 'my_social_settings',
			'type'     => 'text',
			'priority' => 4,
	) );

	$wp_customize->add_section( 'post_settings', array(
			'title'    => __('Post Settings', 'tirtha'),
			'priority' => 100,
	) );

	$wp_customize->add_setting( 'hide_date', array(
	  'default' => 0,
	  'sanitize_callback' => 'tirtha_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'hide_date', array(
	  'type' => 'checkbox',
	  'section' => 'post_settings', // Add a default or your own section
	  'label' => __( 'Hide Date?', 'tirtha' ),
	) );

	$wp_customize->add_setting( 'hide_cat', array(
	  'default' => 0,
	  'sanitize_callback' => 'tirtha_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'hide_cat', array(
	  'type' => 'checkbox',
	  'section' => 'post_settings', // Add a default or your own section
	  'label' => __( 'Hide Category?', 'tirtha' ),
	) );

	$wp_customize->add_setting( 'hide_author', array(
	  'default' => 0,
	  'sanitize_callback' => 'tirtha_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'hide_author', array(
	  'type' => 'checkbox',
	  'section' => 'post_settings', // Add a default or your own section
	  'label' => __( 'Hide Author?', 'tirtha' ),
	) );

	$wp_customize->add_setting( 'hide_comments', array(
	  'default' => 0,
	  'sanitize_callback' => 'tirtha_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'hide_comments', array(
	  'type' => 'checkbox',
	  'section' => 'post_settings', // Add a default or your own section
	  'label' => __( 'Hide Comments?', 'tirtha' ),
	) );

	$wp_customize->add_section( 'footer_settings', array(
			'title'    => __('Footer', 'tirtha'),
			'priority' => 110,
            'description' => __('Add copyright text in footer.', 'tirtha')
	) );

	$wp_customize->add_setting('footer_content', array(
        'default' => '',
        'sanitize_js_callback' => 'tirtha_sanitize_escaping',
    ));

    $wp_customize->add_control(new tirtha_customize_textarea_control($wp_customize, 'footer_content', array(
        'label' => __('Copyright Text', 'tirtha'),
        'section' => 'footer_settings',
        'settings' => 'footer_content',
        'priority' => 20,
    )));

	$wp_customize->add_setting( 'hide_default_footer_text', array(
	  'default' => 0,
	  'sanitize_callback' => 'tirtha_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'hide_default_footer_text', array(
	  'type' => 'checkbox',
	  'section' => 'footer_settings', // Add a default or your own section
	  'label' => __( 'Hide Default Copyright Text?', 'tirtha' ),
	  'priority' => 30,
	) );


}
add_action( 'customize_register', 'tirtha_customize_register' );

/*
 * Escaping for input values
 *
 * @since Wedlog 1.0
 */

function tirtha_sanitize_escaping($input) {
    $input = esc_attr($input);
    return $input;
}


/*
 *
 * sanitize Text field
 *
 * @since Tirtha 1.0
 *
 */

function tirtha_sanitize_text($input) {
    return wp_kses_post(force_balance_tags($input));
}

/*
 *
 * sanitize Checkbox field
 *
 * @since Tirtha 1.1.2
 *
 */

function tirtha_sanitize_checkbox( $input ) {
  // Boolean check.
  if ($input) {
        $input = '1';
    }
    return $input;
}
