<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Tirpitz
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-content">
		

		<?php
            if ( has_post_thumbnail() ) {
                echo '<div class="index-thumb">';
                echo '<div id="meta">';
                tirpitz_posted_on();
                echo '</div>';
                if ( is_single() ) {
                    the_title( '<h1 class="entry-title">', '</h1>' );
                } else {
                    the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                }
                echo '<a href="' . esc_url( get_permalink() ) . '" title="' . __('Keep Reading ', 'tirpitz') . get_the_title() . '">';
                the_post_thumbnail();
                echo '</a>';
                echo '</div>';
            } 
			the_excerpt( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'tirpitz' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'tirpitz' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
        echo '<a href="' . get_permalink() . '" title="' . __('Continue Reading ', 'tirpitz') . get_the_title() . '" rel="bookmark"><i class="fa fa-arrow-circle-o-right    "> Continue Reading</i></a>';
        tirpitz_entry_footer();  
        ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
