<?php get_header(); ?>
<div class="contents">
	<?php if ( have_posts() ) while ( have_posts() ) : the_post(); ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>

			<?php if ( has_post_format() ) : ?><?php endif; ?>

			<article itemscope itemtype="https://schema.org/Article">

				<meta itemprop="name" content="<?php the_title(); ?>">
				<meta itemprop="mainEntityOfPage" content="<?php the_permalink(); ?>">
				<meta itemprop="dateModified" content="<?php the_modified_date( 'Y-m-d' ); ?>">
				<?php edit_post_link( __('Edit this entry', 'tijaji') ,'<div class="editlink">','</div>'); ?>
				<?php if ( tijaji_display_single_category() ) { ?><div class="singlecat"><?php the_category(' '); ?></div><?php } ?>
				<?php if ( tijaji_display_single_date() or tijaji_display_single_author() ) { ?><div class="loopdate"><?php } ?>
				<?php if ( tijaji_display_single_date() ) { ?><span itemprop="datePublished" content="<?php the_time( 'Y-m-d' );?>"><?php the_time( get_option( 'date_format' ) );?></span><?php } ?><?php if ( tijaji_display_single_author() ) { ?> <span class="author right" itemprop="author" itemscope itemtype="https://schema.org/Person">&nbsp;<?php esc_html_e('Written by ','tijaji');  echo '<a itemprop="url" href="' . esc_url( get_author_posts_url( get_the_author_meta('ID') ) ) . '" rel="author"><span itemprop="name">'; the_author_meta('nickname'); echo '</span></a>'; ?></span><?php } ?>
				<?php if ( tijaji_display_single_date() or tijaji_display_single_author() ) { ?></div><?php } ?>
				<div class="clear"></div>

				<div itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
					<meta itemprop="name" content="<?php bloginfo( 'name' ); ?>">
					<div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
						<?php if( has_custom_logo() ) {?>
						<meta itemprop="url" content="<?php echo esc_url( substr(get_custom_logo(),$of=strpos(get_custom_logo(),'src="')+5,strpos(get_custom_logo(),'" class="custom-logo"')-$of) );?>">
						<meta itemprop="width" content="<?php echo absint( substr(get_custom_logo(),$of=strpos(get_custom_logo(),'width="')+7,strpos(get_custom_logo(),'"')-$of) );?>">
						<meta itemprop="height" content="<?php echo absint( substr(get_custom_logo(),$of=strpos(get_custom_logo(),'height="')+8,strpos(get_custom_logo(),'"')-$of) ); ?>">
						<?php } else {?>
						<meta itemprop="url" content="<?php echo esc_url( get_template_directory_uri() . '/images/tj.png' ); ?>">
						<meta itemprop="width" content="100">
						<meta itemprop="height" content="100">
						<?php } ?>
					</div>
				</div>

				<h1 itemprop="headline"><?php the_title(); ?></h1>
				<?php if ( has_post_thumbnail() && tijaji_display_single_thumbnail() ) { 
					echo '<div class="top_thumbnail">'; the_post_thumbnail(); echo '</div>'; 
				}else{
					echo '<meta itemprop="image" content="' . esc_url( get_template_directory_uri() . '/images/noimg.jpg' ) . '">';
				} ?>
				<div itemprop="articleBody" class="post-content">
					<?php the_content(); ?>
					<div class="clear"></div>
				
<?php
	$tijaji_wplinknum = wp_link_pages( array(
		'before' =>'',
		'after' => '',
		'separator' => ' ',
 		'link_before' => '<span class="page-link">',
		'link_after' => '</span>',
		'echo' => 0
	));

	if( $tijaji_wplinknum ) {

		$tijaji_pagelink = wp_link_pages( array(
			'before' =>'',
			'after' => '',
	 		'link_before' => '',
			'link_after' => '',
			'separator' => '',
			'next_or_number' => 'next',
			'nextpagelink'     => 'next',
			'previouspagelink' => 'previous',
			'echo' => 0
		));

		preg_match_all('|<a href="(.*?)</a>|s', $tijaji_pagelink, $tijaji_get_pagelink);

		if( isset( $tijaji_get_pagelink[0][0] ) ) {

			if( strstr($tijaji_get_pagelink[0][0],'previous') ) {

				preg_match('|"(.*?)"|s', $tijaji_get_pagelink[0][0], $tijaji_get_previousurl);
			$tijaji_previouslink = '<a href="' . esc_url( $tijaji_get_previousurl[1] ) . '"><span class="page-link">' . __('&laquo; Previous page','tijaji') . '</span></a> ';

			}elseif( strstr($tijaji_get_pagelink[0][0],'next') ) {

				preg_match('|"(.*?)"|s', $tijaji_get_pagelink[0][0], $tijaji_get_nexturl);
				$tijaji_nextlink = ' <a href="' . esc_url( $tijaji_get_nexturl[1] ) . '"><span class="page-link">' . __('Next page &raquo;','tijaji') . '</span></a>';

			}

		}

		if( isset( $tijaji_get_pagelink[0][1] ) ) {

			if( strstr($tijaji_get_pagelink[0][1],'next') ) {

				preg_match('|"(.*?)"|s', $tijaji_get_pagelink[0][1], $tijaji_get_nexturl);
				$tijaji_nextlink = ' <a href="' . esc_url( $tijaji_get_nexturl[1] ) . '"><span class="page-link">' . __('Next page &raquo;','tijaji') . '</span></a>';

			}elseif ( strstr($tijaji_get_pagelink[0][1],'previous') ) {

				preg_match('|"(.*?)"|s', $tijaji_get_pagelink[0][1], $tijaji_get_previousurl);
			$tijaji_previouslink = '<a href="' . esc_url( $tijaji_get_previousurl[1] ) . '"><span class="page-link">' . __('&laquo; Previous page','tijaji') . '</span></a> ';

			}

		}


		echo '<nav class="center"><div class="page-links">';
		if( isset( $tijaji_previouslink ) ) echo wp_kses_post( $tijaji_previouslink );
		echo wp_kses_post( $tijaji_wplinknum );
		if( isset( $tijaji_nextlink )  ) echo wp_kses_post( $tijaji_nextlink );
		echo '</div></nav>';
	}
?>
					<?php dynamic_sidebar( 'content_bottom' ); ?>
				</div>
			</article>

			<?php if( has_tag() ) { ?>
			<div class="taglist right"><?php the_tags( __('<span>Tags: </span>','tijaji') ,'','' ); ?></div>
			<div class="clear"></div>
			<?php } ?>

		</div>

		<?php if ( tijaji_display_single_pagenav() ) { ?>
		<div id="pagenavi" class="newer-older">
			<p class="older"><?php previous_post_link( '&laquo; %link','%title',false ) ?></p>
			<p class="newer"><?php next_post_link( '%link &raquo;','%title',false ) ?></p>
			<div class="clear"></div>
		</div>
		<?php } ?>

		<?php comments_template( '', true ); ?>

	<?php endwhile; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
