<?php

add_action('admin_menu', 'tijaji_add_theme_info');

function tijaji_add_theme_info(){

	$allowed_html = array( 'span' => array( 'style' => array (),'class' => array () ) );
	$tijaji_list_name = '<span class="tijaji_s">' . __('TIJAJI info','tijaji') . '</span>';
	$tijajipage = add_theme_page( __('TIJAJI Information','tijaji'), wp_kses( $tijaji_list_name , $allowed_html ) , 'manage_options', 'tijaji-info.php', 'tijaji_information' );
	add_action( 'load-' . $tijajipage, 'tijaji_information_page' );

}

function tijaji_information() {
?>

	<div class="tijaji_admin_div" style="background-image: url(<?php echo esc_url( get_template_directory_uri() . '/images/default-header-background.jpg' ); ?>);background-position: top center;background-repeat:repeat;background-size: 100% auto;">

		<div class="t_logo">
		<h1 class="info-title"><?php /* translators: %s: theme version */ echo sprintf( esc_html__( 'TIJAJI - %s Information', 'tijaji' ), esc_html( wp_get_theme()->version ) ); ?></h1>
		<div class="tijaji_admin_thx"><?php esc_html_e( 'Welcome to TIJAJI! Thank you for installing. Here we will display information on TIJAJI and show you how to customize. Is there a function you want to add to the theme customizer? I would like to answer as much as possible if requested. Thank you.', 'tijaji' ); ?></div>
		</div>


		<div class="tijaji_admin">


			<input type="radio" id="m1" name="tijaji_admin_menu" checked>
				<label for="m1" class="admin_menu_list_1"><?php esc_html_e( 'Getting started', 'tijaji' ); ?></label>
			<div class="admin_content_1">
				<h2><?php esc_html_e( 'Recommend customizing with theme customizer', 'tijaji' ); ?></h2>
				<p><?php esc_html_e( 'Let\'s play with theme customizer immediately!', 'tijaji' ); ?></p>
				<p><a class="button button-primary button-large" href="<?php echo esc_url( admin_url( 'customize.php' )); ?>"><?php esc_html_e( 'Go to Customizer', 'tijaji' ); ?></a></p>
			</div>
			<input type="radio" id="m2" name="tijaji_admin_menu">
				<label for="m2" class="admin_menu_list_2"><?php esc_html_e( 'How to customize', 'tijaji' ); ?></label>
			<div class="admin_content_2">
				<h2><?php esc_html_e( 'Demo site', 'tijaji' ); ?></h2>
				<p><?php esc_html_e( 'What can you do with customization? How is it displayed? Let\'s take a look at the demo site.', 'tijaji' ); ?></p>
				<p><a href="https://tijaji.jp/demo/" target="_blank"><?php esc_html_e( 'TIJAJI DEMO SITE', 'tijaji' ); ?></a></p>
				<h2><?php esc_html_e( 'Customization instructions', 'tijaji' ); ?></h2>
				<?php get_template_part( 'inc/setumei' ); ?>
			</div>
			<input type="radio" id="m3" name="tijaji_admin_menu">
				<label for="m3" class="admin_menu_list_3"><?php esc_html_e( 'Support', 'tijaji' ); ?></label>
			<div class="admin_content_3">
				<h2><?php esc_html_e( 'Support', 'tijaji' ); ?></h2>
			<p><?php esc_html_e( 'Is there anything you do not understand? Please ask me a question. Also, please also contact the features you want to add.', 'tijaji' ); ?></p>
				<p><a href="https://tijaji.jp/to_contact/" target="_blank"><?php esc_html_e( 'To contact', 'tijaji' ); ?></a></p>
			</div>

		</div>


	</div>
<?php
}

function tijaji_information_page(){
	add_action( 'admin_enqueue_scripts', 'tijaji_information_css' );
}
function tijaji_information_css() {
	wp_enqueue_style( 'tijaji-themeadmin', get_template_directory_uri() . '/css/tijaji_admin_info.css' );
}
