<?php 

function tijaji_theme_customizer_extension($tijaji_customize) {

	if ( isset( $tijaji_customize->selective_refresh ) ) {

		$tijaji_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.sitename',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.disc',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_single_category', array(
		'selector' => '.singlecat',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_list_category', array(
		'selector' => '.loopcat:first-child',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_single_date', array(
		'selector' => '.post .loopdate',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_single_author', array(
		'selector' => '.post .author',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_page_author', array(
		'selector' => '.page .author',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_page_date', array(
		'selector' => '.page .loopdate',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_page_date', array(
		'selector' => '.page .loopdate',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_list_date', array(
		'selector' => '.loopbox .loopdate',        
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_single_pagenav', array(
		'selector' => '#pagenavi', 
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_sidebar_h_font', array(
		'selector' => '.sidebox h3',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_single_thumbnail', array(
		'selector' => '.top_thumbnail',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_list_comment', array(
		'selector' => '.comment_count',
		) );

		$tijaji_customize->selective_refresh->add_partial( 'tijaji_display_list_img', array(
		'selector' => '.tijaji_list_thum',
		) );

	}

	$tijaji_customize->add_setting( 'tijaji_titlelogo_width', array (
	'default' => '80px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_titlelogo_width', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_titlelogo_width',
	'label' => __( 'Site title logo size', 'tijaji' ),
	'description' => __( '(Valid only when logo is displayed.)', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'60px' =>  '60px',
		'65px' =>  '65px',
		'70px' =>  '70px',
		'75px' =>  '75px',
		'80px' =>  '80px(default)',
		'85px' =>  '85px',
		'90px' =>  '90px',
		'95px' =>  '95px',
		'100px' =>  '100px',
		'120px' =>  '120px',
		'140px' =>  '140px',
		'160px' =>  '160px',
		'180px' =>  '180px',
		'200px' =>  '200px',
		'220px' =>  '220px',
		'240px' =>  '240px',
		'260px' =>  '260px',
		'280px' =>  '280px',
		'300px' =>  '300px',
		'320px' =>  '320px',
		'340px' =>  '340px',
		'360px' =>  '360px',
		'380px' =>  '380px',
		'400px' =>  '400px',
	),
	'priority' => 9,
	));

	$tijaji_customize->add_setting( 'tijaji_site_title_color', array(
	'default' => '#000000',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_site_title_color', array(
	'label' => __( 'Site title color', 'tijaji' ),
	'section' => 'title_tagline',
	'settings' => 'tijaji_site_title_color',
	'priority' => 13,
	)));

	$tijaji_customize->add_setting( 'tijaji_header_description_color', array(
	'default' => '#666666',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_header_description_color', array(
	'label' => __( 'Site description text color', 'tijaji' ),
	'section' => 'title_tagline',
	'settings' => 'tijaji_header_description_color',
	'priority' => 20,
	)));

	$tijaji_customize->add_setting( 'tijaji_hbg_color', array(
	'default' => '',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_hbg_color', array(
	'label' => __( 'Top header background color', 'tijaji' ),
	'section' => 'colors',
	'settings' => 'tijaji_hbg_color',
	'priority' => 5,
	)));

	$tijaji_customize->add_setting( 'tijaji_link_color', array(
	'default' => '#0066cc',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_link_color', array(
	'label' => __( 'Link color', 'tijaji' ),
	'section' => 'colors',
	'settings' => 'tijaji_link_color',
	'priority' => 20,
	)));

	$tijaji_customize->add_setting( 'tijaji_link_hover_color', array(
	'default' => '#cc0000',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_link_hover_color', array(
	'label' => __( 'Link hover color', 'tijaji' ),
	'section' => 'colors',
	'settings' => 'tijaji_link_hover_color',
	'priority' => 21,
	)));

	$tijaji_customize->add_setting( 'tijaji_fontcolor', array(
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_fontcolor', array(
	'label' => __( 'Overall font color', 'tijaji' ),
	'section' => 'colors',
	'settings' => 'tijaji_fontcolor',
	'priority' => 100,
	)));

	$tijaji_customize->add_section( 'display', array (
	'title' => __( 'Display settings', 'tijaji' ),
	'panel' => 'tijaji_design_and_display_settings',
	'priority' => 28,
	));

	$tijaji_customize->add_setting( 'tijaji_display_header_description', array (
	'default' => '2',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_display_header_description', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_display_header_description',
	'label' => __( 'Where will you display the site description?', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1' => __( 'Top of site title', 'tijaji' ),
		'2' => __( 'Under the site title', 'tijaji' ),
		'3' => __( 'Top of the site', 'tijaji' ),
		'4' => __( 'Do not show', 'tijaji' ),
	),
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_display_sitename', array (
	'default' => '1',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_display_sitename', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_display_sitename',
	'label' => __( 'Display site title?', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1' => __( 'Yes', 'tijaji' ),
		'2' => __( 'No', 'tijaji' ),
	),
	'priority' => 35,
	));

	$tijaji_customize->add_setting( 'tijaji_display_header_description_type', array (
	'default' => '3',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_display_header_description_type', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_display_header_description_type',
	'label' => __( 'Content of site description', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'1' => __( 'Always site catchphrase', 'tijaji' ),
		'3' => __( 'Switch to page description', 'tijaji' ),
	),
	'priority' => 40,
	));

	$tijaji_customize->add_setting( 'tijaji_display_single_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_display_single_title', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_title',
	'content' => '<span class="customize-control-title">' . __( 'Single', 'tijaji' ) . '</span>',
	'priority' => 28,
	)));

	$tijaji_customize->add_setting( 'tijaji_display_single_category', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_single_category', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_category',
	'label' => __( 'Display categories on the single page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_display_single_date', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_single_date', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_date',
	'label' => __( 'Display date on the single page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 40,
	));

	$tijaji_customize->add_setting( 'tijaji_display_single_author', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_single_author', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_author',
	'label' => __( 'Display author on the single page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 50,
	));

	$tijaji_customize->add_setting( 'tijaji_display_single_thumbnail', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_single_thumbnail', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_thumbnail',
	'label' => __( 'Display Eye catch image on the single page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 55,
	));

	$tijaji_customize->add_setting( 'tijaji_display_single_pagenav', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_single_pagenav', array(
	'section' => 'display',
	'settings' => 'tijaji_display_single_pagenav',
	'label' => __( 'Display "Next page", "Previous page" link on the single page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 60,
	));

	$tijaji_customize->add_setting( 'tijaji_display_page_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_display_page_title', array(
	'section' => 'display',
	'settings' => 'tijaji_display_page_title',
	'content' => '<span class="customize-control-title">' . __( 'Page', 'tijaji' ) . '</span>',
	'priority' => 68,
	)));

	$tijaji_customize->add_setting( 'tijaji_display_page_date', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_page_date', array(
	'section' => 'display',
	'settings' => 'tijaji_display_page_date',
	'label' => __( 'Display date on the page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 70,
	));

	$tijaji_customize->add_setting( 'tijaji_display_page_author', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_page_author', array(
	'section' => 'display',
	'settings' => 'tijaji_display_page_author',
	'label' => __( 'Display author on the page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 80,
	));


	$tijaji_customize->add_setting( 'tijaji_display_list_page_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_display_list_page_title', array(
	'section' => 'display',
	'settings' => 'tijaji_display_list_page_title',
	'content' => '<span class="customize-control-title">' . __( 'List Page', 'tijaji' ) . '</span>',
	'priority' => 88,
	)));

	$tijaji_customize->add_setting( 'tijaji_display_list_category', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_list_category', array(
	'section' => 'display',
	'settings' => 'tijaji_display_list_category',
	'label' => __( 'Display categories on the list page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 90,
	));

	$tijaji_customize->add_setting( 'tijaji_display_list_date', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_list_date', array(
	'section' => 'display',
	'settings' => 'tijaji_display_list_date',
	'label' => __( 'Display date on the list page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 100,
	));

	$tijaji_customize->add_setting( 'tijaji_display_list_comment', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_list_comment', array(
	'section' => 'display',
	'settings' => 'tijaji_display_list_comment',
	'label' => __( 'Display comment number on the list page', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 110,
	));

	$tijaji_customize->add_setting( 'tijaji_display_list_img', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_list_img', array(
	'section' => 'display',
	'settings' => 'tijaji_display_list_img',
	'label' => __( 'If there is no eye catch image, display placeholder image', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 120,
	));

	$tijaji_customize->add_section( 'design', array (
	'title' => __( 'Design settings', 'tijaji' ),
	'panel' => 'tijaji_design_and_display_settings',
	'priority' => 25,
	));

	$tijaji_customize->add_setting( 'tijaji_layout', array (
	'default' => 'right',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_layout', array(
	'section' => 'design',
	'settings' => 'tijaji_layout',
	'label' => __( 'layout', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'right' => __( '2 column right sidebar', 'tijaji' ),
		'left' => __( '2 column left sidebar', 'tijaji' ),
		'one' => __( '1 columnt', 'tijaji' ),
	),
	'priority' => 10,
	));

	$tijaji_customize->add_setting( 'tijaji_listcontent', array (
	'default' => 'excerpt',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_listcontent', array(
	'section' => 'design',
	'settings' => 'tijaji_listcontent',
	'label' => __( 'Article display on the list page. (Excerpt display or full text display)', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'excerpt' => __( 'Excerpt of the whole site', 'tijaji' ),
		'indexcontent' => __( 'Full-text display with only the top page', 'tijaji' ),
		'allcontent' => __( 'Full-text display of the whole site', 'tijaji' ),
	),
	'priority' => 20,
	));

	$tijaji_customize->add_setting( 'tijaji_display_main_waku', array (
	'default' => '1',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_display_main_waku', array(
	'section' => 'design',
	'settings' => 'tijaji_display_main_waku',
	'label' => __( 'Display border of main content', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'1' => __( 'Display', 'tijaji' ),
		'2' => __( 'Hide', 'tijaji' ),
	),
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_display_totop', array (
	'default' => 'totop1',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_display_totop', array(
	'section' => 'design',
	'settings' => 'tijaji_display_totop',
	'label' => __( 'Back to the top of the page Button', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'totop1' => __( 'Display', 'tijaji' ),
		'totop2' => __( '60 px offset on top', 'tijaji' ),
		'totop3' => __( '120 px offset on top', 'tijaji' ),
		'totop5' => __( '60 px offset on top (Only for smartphone)', 'tijaji' ),
		'totop6' => __( '120 px offset on top (Only for smartphone)', 'tijaji' ),
		'totop4' => __( 'Hide', 'tijaji' ),
	),
	'priority' => 40,
	));

	$tijaji_customize->add_setting( 'tijaji_footerwidget', array (
	'default' => '4',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_footerwidget', array(
	'section' => 'design',
	'settings' => 'tijaji_footerwidget',
	'label' => __( 'How many footer widgets are to be arranged next to it?', 'tijaji' ),
	'description' => __( '(Regardless of this setting, Two rows on tablet and one row on smartphone)', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'1' => __( 'Not side by side', 'tijaji' ),
		'2' => '2',
		'3' => '3',
		'4' => '4',
		'5' => '5',
	),
	'priority' => 40,
	));

	$tijaji_customize->add_section( 'fontsetting', array (
	'title' => __( 'Font settings', 'tijaji' ),
	'panel' => 'tijaji_design_and_display_settings',
	'priority' => 35,
	));

	$tijaji_customize->add_setting( 'tijaji_titlefontfamily', array (
	'default' => '2',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_titlefontfamily', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_titlefontfamily',
	'label' => __( 'Site title font family', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1' => 'Noto Sans JP',
		'2' => 'Noto Sans Japanese(default)',
		'3' => 'Mplus 1p',
		'4' => 'Rounded Mplus 1c',
		'5' => 'Hannari',
		'6' => 'Kokoro',
		'7' => 'Nikukyu',
		'8' => 'Nico Moji',
		'9' => 'Sawarabi Gothic',
		'10' => 'Sawarabi Mincho',
	),
	'priority' => 15,
	));

	$tijaji_customize->add_setting( 'tijaji_titlefontsize', array (
	'default' => '28px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_titlefontsize', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_titlefontsize',
	'label' => __( 'Site title font size', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'24px' =>  '24px',
		'26px' =>  '26px',
		'28px' =>  '28px(default)',
		'30px' =>  '30px',
		'32px' =>  '32px',
		'34px' =>  '34px',
		'36px' =>  '36px',
		'38px' =>  '38px',
		'40px' =>  '40px',
		'42px' =>  '42px',
		'44px' =>  '44px',
		'46px' =>  '46px',
		'48px' =>  '48px',
		'50px' =>  '50px',
		'52px' =>  '52px',
		'54px' =>  '54px',
		'56px' =>  '56px',
		'58px' =>  '58px',
		'60px' =>  '60px',
		'62px' =>  '62px',
		'64px' =>  '64px',

	),
	'priority' => 14,
	));

	$tijaji_customize->add_setting( 'tijaji_h_d_fontsize', array (
	'default' => '10px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h_d_fontsize', array(
	'section' => 'title_tagline',
	'settings' => 'tijaji_h_d_fontsize',
	'label' => __( 'Site description font size', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px(default)',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
	),
	'priority' => 23,
	));


	$tijaji_customize->add_setting( 'tijaji_fontfamily', array (
	'default' => '2',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_fontfamily', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_fontfamily',
	'label' => __( 'Overall font family', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1' => 'Noto Sans JP',
		'2' => 'Noto Sans Japanese(default)',
		'3' => 'Mplus 1p',
		'4' => 'Rounded Mplus 1c',
		'5' => 'Hannari',
		'6' => 'Kokoro',
		'7' => 'Nikukyu',
		'8' => 'Nico Moji',
		'9' => 'Sawarabi Gothic',
		'10' => 'Sawarabi Mincho',
	),
	'priority' => 35,
	));

	$tijaji_customize->add_setting( 'tijaji_fontsize', array (
	'default' => '15px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_fontsize',
	'label' => __( 'Overall font size', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px (Default)',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
	),
	'priority' => 70,
	));

	$tijaji_customize->add_setting( 'tijaji_h1_fontsize', array (
	'default' => '2b0em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h1_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h1_fontsize',
	'label' => __( 'h1 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0(default)',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 80,
	));

	$tijaji_customize->add_setting( 'tijaji_h2_fontsize', array (
	'default' => '2b0em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h2_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h2_fontsize',
	'label' => __( 'h2 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0(default)',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 90,
	));

	$tijaji_customize->add_setting( 'tijaji_h3_fontsize', array (
	'default' => '1b5em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h3_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h3_fontsize',
	'label' => __( 'h3 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5(default)',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 100,
	));

	$tijaji_customize->add_setting( 'tijaji_h4_fontsize', array (
	'default' => '1b5em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h4_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h4_fontsize',
	'label' => __( 'h4 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5(default)',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 110,
	));

	$tijaji_customize->add_setting( 'tijaji_h5_fontsize', array (
	'default' => '1b3em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h5_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h5_fontsize',
	'label' => __( 'h5 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3(default)',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 120,
	));

	$tijaji_customize->add_setting( 'tijaji_h6_fontsize', array (
	'default' => '1b1em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_h6_fontsize', array(
	'section' => 'fontsetting',
	'settings' => 'tijaji_h6_fontsize',
	'label' => __( 'h6 font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b0em' =>'1.0',
		'1b1em' =>'1.1(default)',
		'1b2em' =>'1.2',
		'1b3em' =>'1.3',
		'1b4em' =>'1.4',
		'1b5em' =>'1.5',
		'1b6em' =>'1.6',
		'1b7em' =>'1.7',
		'1b8em' =>'1.8',
		'1b9em' =>'1.9',
		'2b0em' =>'2.0',
		'2b1em' =>'2.1',
		'2b2em' =>'2.2',
		'2b3em' =>'2.3',
		'2b4em' =>'2.4',
		'2b5em' =>'2.5',
		'2b6em' =>'2.6',
		'2b7em' =>'2.7',
		'2b8em' =>'2.8',
		'2b9em' =>'2.9',
		'3b0em' =>'3.0',
	),
	'priority' => 130,
	));

	$tijaji_customize->add_section( 'spsetting', array (
	'title' => __( 'Smartphone setting', 'tijaji' ),
	'description' => __( 'When the width is 480px or less', 'tijaji' ),
	'priority' => 150,
	));

	$tijaji_customize->add_setting( 'tijaji_sp_titlefontsize', array (
	'default' => '28px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sp_titlefontsize', array(
	'section' => 'spsetting',
	'settings' => 'tijaji_sp_titlefontsize',
	'label' => __( 'Site title font size', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'12px' =>  '12px',
		'13px' =>  '13px',
		'14px' =>  '14px',
		'15px' =>  '15px',
		'16px' =>  '16px',
		'17px' =>  '17px',
		'18px' =>  '18px',
		'19px' =>  '19px',
		'20px' =>  '20px',
		'22px' =>  '22px',
		'24px' =>  '24px',
		'26px' =>  '26px',
		'28px' =>  '28px(default)',
		'30px' =>  '30px',
		'32px' =>  '32px',
		'34px' =>  '34px',
		'36px' =>  '36px',
		'38px' =>  '38px',
		'40px' =>  '40px',
		'42px' =>  '42px',
		'44px' =>  '44px',
	),
	'priority' => 10,
	));

	$tijaji_customize->add_setting( 'tijaji_sp_fontsize', array (
	'default' => '0b90em',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sp_fontsize', array(
	'section' => 'spsetting',
	'settings' => 'tijaji_sp_fontsize',
	'label' => __( 'Font size: how many times normal', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1b00em' =>'1.00',
		'0b95em' =>'0.95',
		'0b90em' =>'0.90 (Default)',
		'0b85em' =>'0.85',
		'0b80em' =>'0.80',
		'0b75em' =>'0.75',
		'0b70em' =>'0.70',
		'0b65em' =>'0.65',
		'0b60em' =>'0.60',
	),
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_display_sp_header_description', array (
	'default' => 'true',
	'sanitize_callback' => 'tijaji_sanitize_checkbox',
	));
	$tijaji_customize->add_control( 'tijaji_display_sp_header_description', array(
	'section' => 'spsetting',
	'settings' => 'tijaji_display_sp_header_description',
	'label' => __( 'Display the header description', 'tijaji' ),
	'type' => 'checkbox',
	'priority' => 20,
	));

	$tijaji_customize->add_setting( 'tijaji_sp_titlelogo', array (
	'default' => '60px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sp_titlelogo', array(
	'section' => 'spsetting',
	'settings' => 'tijaji_sp_titlelogo',
	'label' => __( 'Site title logo size', 'tijaji' ),
	'description' => __( '(Valid only when logo is displayed.)', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'40px' =>  '40px',
		'45px' =>  '45px',
		'50px' =>  '50px',
		'55px' =>  '55px',
		'60px' =>  '60px(default)',
		'65px' =>  '65px',
		'70px' =>  '70px',
		'75px' =>  '75px',
		'80px' =>  '80px',
		'100px' =>  '100px',
		'120px' =>  '120px',
		'140px' =>  '140px',
		'160px' =>  '160px',
		'180px' =>  '180px',
		'200px' =>  '200px',
		'220px' =>  '220px',
		'240px' =>  '240px',
		'260px' =>  '260px',
		'280px' =>  '280px',
		'300px' =>  '300px',
	),
	'priority' => 50,
	));

	$tijaji_customize->add_setting( 'tijaji_sp_headermenu', array (
	'default' => '2',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sp_headermenu', array(
	'section' => 'spsetting',
	'settings' => 'tijaji_sp_headermenu',
	'label' => __( 'How do you display the header menu?', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'1' =>  __( 'Same as PC', 'tijaji' ),
		'2' =>  __( 'Drawer menu (fixed in header)', 'tijaji' ),
		'3' =>  __( 'Drawer menu (follows screen)', 'tijaji' ),
	),
	'priority' => 60,
	));

	$tijaji_customize->add_panel( 'tijaji_design_and_display_settings', array(
	'priority' => 27,
	'title' => __('Design and display settings', 'tijaji'),
	) );



	$tijaji_customize->add_panel( 'tijaji_headerimg_setting', array(
	'priority' => 25,
	'title' => __('Header image setting', 'tijaji'),
	) );

	$tijaji_customize->add_section( 'tijaji_header_image_type', array (
	'title' => __( 'Header image type', 'tijaji' ),
	'panel' => 'tijaji_headerimg_setting',
	'priority' => 10,
	));

	$tijaji_customize->add_setting( 'tijaji_header_img_type', array (
	'default' => '3',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_header_img_type', array(
	'section' => 'tijaji_header_image_type',
	'settings' => 'tijaji_header_img_type',
	'label' => __( 'What is the header image?', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'1' => __( 'None', 'tijaji' ),
		'2' => __( 'Media (Image or video)', 'tijaji' ),
		'3' => __( 'Slider', 'tijaji' ),
	),
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_header_display', array (
	'default' => '2',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_header_display', array(
	'section' => 'tijaji_header_image_type',
	'settings' => 'tijaji_header_display',
	'label' => __( 'Where to display?', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'1' => __( 'All pages', 'tijaji' ),
		'2' => __( 'Top page only', 'tijaji' ),
	),
	'priority' => 40,
	));

	$tijaji_customize->add_section( 'header_background_image_set', array (
	'title' => __( 'Header background image', 'tijaji' ),
	'panel' => 'tijaji_headerimg_setting',
	'priority' => 20,
	));

	$tijaji_customize->add_setting('header_background_image',array(
	'default' => get_template_directory_uri() . '/images/default-header-background.jpg',
	'sanitize_callback' => 'esc_url',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'header_background_image', array(
	'label' => __( 'Header background image', 'tijaji' ),
	'section' => 'header_background_image_set',
	'settings' => 'header_background_image',
	)));

	$tijaji_customize->add_section( 'tijaji_slider_set', array (
	'title' => __( 'Slider', 'tijaji' ),
	'panel' => 'tijaji_headerimg_setting',
	'priority' => 30,
	));

	$tijaji_customize->add_setting( 'tijaji_slider_number', array (
	'default' => '3',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));

	$tijaji_customize->add_control( 'tijaji_slider_number', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_number',
	'label' => __( 'How many slider do you use?', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'2' => '2',
		'3' => '3',
		'4' => '4',
		'5' => '5',
	),
	'priority' => 10,
	));

	$tijaji_customize->add_setting('tijaji_slider_1',array(
	'default' => get_template_directory_uri() . '/images/default-1.jpg',
	'sanitize_callback' => 'esc_url_raw',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_slider_1', array(
	'label' => __( 'Slider image No.1', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_1',
	'priority' => 20,
	)));

	$tijaji_customize->add_setting('tijaji_slider_2',array(
	'default' => get_template_directory_uri() . '/images/default-2.jpg',
	'sanitize_callback' => 'esc_url_raw',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_slider_2', array(
	'label' => __( 'Slider image No.2', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_2',
	'priority' => 40,
	)));

	$tijaji_customize->add_setting('tijaji_slider_3',array(
	'default' => get_template_directory_uri() . '/images/default-3.jpg',
	'sanitize_callback' => 'esc_url_raw',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_slider_3', array(
	'label' => __( 'Slider image No.3', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_3',
	'priority' => 60,
	)));

	$tijaji_customize->add_setting('tijaji_slider_4',array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_slider_4', array(
	'label' => __( 'Slider image No.4', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_4',
	'priority' => 80,
	)));

	$tijaji_customize->add_setting('tijaji_slider_5',array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw',
	));
 
	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_slider_5', array(
	'label' => __( 'Slider image No.5', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_5',
	'priority' => 100,
	)));

	$tijaji_customize->add_setting('tijaji_slider_txt_1',array(
	'default' => __('<span style="font-size:1em;line-height:1.2em">The theme <span style="color:#e00">made</span> by Japanese</span>', 'tijaji' ),
	'sanitize_callback' => 'tijaji_sanitize_text',

	));
 
	$tijaji_customize->add_control('tijaji_slider_txt_1', array(
	'label' => __( 'Text to display with slider No.1', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'textarea',
	'settings' => 'tijaji_slider_txt_1',
	'priority' => 30,
	));

	$tijaji_customize->add_setting('tijaji_slider_txt_2',array(
	'default' => __('<span style="color:#f4df51;">We made it easy to customize <br />from the experience of running a lot of sites</span>', 'tijaji' ),
	'sanitize_callback' => 'tijaji_sanitize_text',

	));
 
	$tijaji_customize->add_control('tijaji_slider_txt_2', array(
	'label' => __( 'Text to display with slider No.2', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'textarea',
	'settings' => 'tijaji_slider_txt_2',
	'priority' => 50,
	));

	$tijaji_customize->add_setting('tijaji_slider_txt_3',array(
	'default' => __('<span style="font-size:1em;line-height:1.6em;">Have fun with <span style="color:#368fb5;font-size:2.2em;">Word</span><span style="color:#999;font-size:2.2em;">Press</span>!</span>', 'tijaji' ),
	'sanitize_callback' => 'tijaji_sanitize_text',

	));
 
	$tijaji_customize->add_control('tijaji_slider_txt_3', array(
	'label' => __( 'Text to display with slider No.3', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'textarea',
	'settings' => 'tijaji_slider_txt_3',
	'priority' => 70,
	));

	$tijaji_customize->add_setting('tijaji_slider_txt_4',array(
	'default' => '',
	'sanitize_callback' => 'tijaji_sanitize_text',

	));
 
	$tijaji_customize->add_control('tijaji_slider_txt_4', array(
	'label' => __( 'Text to display with slider No.4', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'textarea',
	'settings' => 'tijaji_slider_txt_4',
	'priority' => 90,
	));

	$tijaji_customize->add_setting('tijaji_slider_txt_5',array(
	'default' => '',
	'sanitize_callback' => 'tijaji_sanitize_text',

	));
 
	$tijaji_customize->add_control( 'tijaji_slider_txt_5', array(
	'label' => __( 'Text to display with slider No.5', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'textarea',
	'settings' => 'tijaji_slider_txt_5',
	'priority' => 110,
	));

	$tijaji_customize->add_setting('tijaji_slider_url_1',array(
	'default' => '#',
	'sanitize_callback' => 'esc_url_raw',

	));
 
	$tijaji_customize->add_control('tijaji_slider_url_1', array(
	'label' => __( 'Link URL slider No.1', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'text',
	'settings' => 'tijaji_slider_url_1',
	'priority' => 35,
	));

	$tijaji_customize->add_setting('tijaji_slider_url_2',array(
	'default' => '#',
	'sanitize_callback' => 'esc_url_raw',

	));
 
	$tijaji_customize->add_control('tijaji_slider_url_2', array(
	'label' => __( 'Link URL slider No.2', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'text',
	'settings' => 'tijaji_slider_url_2',
	'priority' => 55,
	));

	$tijaji_customize->add_setting('tijaji_slider_url_3',array(
	'default' => '#',
	'sanitize_callback' => 'esc_url_raw',

	));
 
	$tijaji_customize->add_control('tijaji_slider_url_3', array(
	'label' => __( 'Link URL slider No.3', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'text',
	'settings' => 'tijaji_slider_url_3',
	'priority' => 75,
	));

	$tijaji_customize->add_setting('tijaji_slider_url_4',array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw',

	));
 
	$tijaji_customize->add_control('tijaji_slider_url_4', array(
	'label' => __( 'Link URL slider No.4', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'text',
	'settings' => 'tijaji_slider_url_4',
	'priority' => 95,
	));

	$tijaji_customize->add_setting('tijaji_slider_url_5',array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw',

	));
 
	$tijaji_customize->add_control( 'tijaji_slider_url_5', array(
	'label' => __( 'Link URL slider No.5', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'type'      => 'text',
	'settings' => 'tijaji_slider_url_5',
	'priority' => 115,
	));

	$tijaji_customize->add_setting( 'tijaji_slider_txt_shadow', array (
	'default' => 'slidertxt_shadow',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_slider_txt_shadow', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_txt_shadow',
	'label' => __( 'Add a text shadow?', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'slidertxt_shadow' => 'Yes',
		'' => 'No',
	),
	'priority' => 12,
	));

	$tijaji_customize->add_setting( 'tijaji_slider_txt_color', array(
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	) );
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_slider_txt_color', array(
	'label' => __( 'Slider text color', 'tijaji' ),
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_txt_color',
	'priority' => 11,
	)));

	$tijaji_customize->add_setting( 'tijaji_slider_1_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_slider_1_title', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_1_title',
	'content' => '<div class="slider_title">' . __( 'Slider No.1', 'tijaji' ) . '</div>',
	'priority' => 18,
	)));

	$tijaji_customize->add_setting( 'tijaji_slider_2_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_slider_2_title', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_2_title',
	'content' => '<div class="slider_title">' . __( 'Slider No.2', 'tijaji' ) . '</div>',
	'priority' => 38,
	)));

	$tijaji_customize->add_setting( 'tijaji_slider_3_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_slider_3_title', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_3_title',
	'content' => '<div class="slider_title">' . __( 'Slider No.3', 'tijaji' ) . '</div>',
	'priority' => 58,
	)));

	$tijaji_customize->add_setting( 'tijaji_slider_4_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_slider_4_title', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_4_title',
	'content' => '<div class="slider_title">' . __( 'Slider No.4', 'tijaji' ) . '</div>',
	'priority' => 78,
	)));

	$tijaji_customize->add_setting( 'tijaji_slider_5_title', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_slider_5_title', array(
	'section' => 'tijaji_slider_set',
	'settings' => 'tijaji_slider_5_title',
	'content' => '<div class="slider_title">' . __( 'Slider No.5', 'tijaji' ) . '</div>',
	'priority' => 98,
	)));

	$tijaji_customize->add_setting( 'tijaji_max_content_width', array (
	'default' => 'width1050',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_max_content_width', array(
	'section' => 'design',
	'settings' => 'tijaji_max_content_width',
	'label' => __( 'Max content width', 'tijaji' ),
	'description' => __( '(When the screen width is smaller than this setting, it can be adjusted to the screen width)', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'width800' => '800px',
		'width850' => '850px',
		'width900' => '900px',
		'width950' => '950px',
		'width1000' => '1000px',
		'width1050' => '1050px(default)',
		'width1100' => '1100px',
		'width1150' => '1150px',
		'width1200' => '1200px',
		'width1250' => '1250px',
		'width1300' => '1300px',
		'width1350' => '1350px',
		'width1400' => '1400px',
		'widthfull' => '100%',
	),
	'priority' => 13,
	));

	$tijaji_customize->add_section( 'tijaji_plus', array (
	'title' => __( 'More customize', 'tijaji' ),
	'priority' => 1000,
	));

	$tijaji_customize->add_setting( 'tijaji_plus_intro', array (
	'sanitize_callback' => 'sanitize_text_field',
	));

	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_plus_intro', array(
	'section' => 'tijaji_plus',
	'content' => '<div class="tijaji_plus">' . __( 'There is "TIJAJI Plus" which added the function.', 'tijaji' ) . '</div><p><a class="button button-primary button-large" href="https://tijaji.jp/plus_demo/"  target="_blank">' . __( 'Go to Demo site', 'tijaji' ) . '</a></p><p><a class="button button-primary button-large" href="https://tijaji.jp/plus/"  target="_blank">' . __( 'Click here for details', 'tijaji' ) . '</a></p>',
	'priority' => 10,
	)));

	$tijaji_customize->get_section( 'header_image' )->panel = 'tijaji_headerimg_setting';
	$tijaji_customize->get_section( 'colors' )->panel = 'tijaji_design_and_display_settings';
	$tijaji_customize->get_section( 'background_image' )->panel = 'tijaji_design_and_display_settings';
	$tijaji_customize->get_section( 'static_front_page' )->panel = 'tijaji_design_and_display_settings';

}
add_action('customize_register', 'tijaji_theme_customizer_extension');

function tijaji_fontfamily() { return get_theme_mod( 'tijaji_fontfamily','2' ); }
function tijaji_header_img_type() { return get_theme_mod( 'tijaji_header_img_type', '3' ); }
function tijaji_header_display() { return get_theme_mod( 'tijaji_header_display', '2' ); }
function tijaji_header_background_image() { return get_theme_mod( 'header_background_image', get_template_directory_uri() . '/images/default-header-background.jpg' ); }
function tijaji_slider_number() { return get_theme_mod( 'tijaji_slider_number', '3' );}
function tijaji_slider_1() { return get_theme_mod( 'tijaji_slider_1', get_template_directory_uri() . '/images/default-1.jpg' ); }
function tijaji_slider_2() { return get_theme_mod( 'tijaji_slider_2', get_template_directory_uri() . '/images/default-2.jpg' ); }
function tijaji_slider_3() { return get_theme_mod( 'tijaji_slider_3', get_template_directory_uri() . '/images/default-3.jpg' ); }
function tijaji_slider_4() { return get_theme_mod( 'tijaji_slider_4', '' ); }
function tijaji_slider_5() { return get_theme_mod( 'tijaji_slider_5', '' ); }
function tijaji_slider_txt_1() { return get_theme_mod( 'tijaji_slider_txt_1', __('<span style="font-size:1em;line-height:1.2em">The theme <span style="color:#e00">made</span> by Japanese</span>', 'tijaji' ) ); }
function tijaji_slider_txt_2() { return get_theme_mod( 'tijaji_slider_txt_2', __('<span style="color:#f4df51;">We made it easy to customize <br />from the experience of running a lot of sites</span>', 'tijaji' ) ); }
function tijaji_slider_txt_3() { return get_theme_mod( 'tijaji_slider_txt_3', __('<span style="font-size:1em;line-height:1.6em;">Have fun with <span style="color:#368fb5;font-size:2.2em;">Word</span><span style="color:#999;font-size:2.2em;">Press</span>!</span>', 'tijaji' ) ); }
function tijaji_slider_txt_4() { return get_theme_mod( 'tijaji_slider_txt_4', '' ); }
function tijaji_slider_txt_5() { return get_theme_mod( 'tijaji_slider_txt_5', '' ); }
function tijaji_slider_url_1() { return get_theme_mod( 'tijaji_slider_url_1', '#' ); }
function tijaji_slider_url_2() { return get_theme_mod( 'tijaji_slider_url_2', '#' ); }
function tijaji_slider_url_3() { return get_theme_mod( 'tijaji_slider_url_3', '#' ); }
function tijaji_slider_url_4() { return get_theme_mod( 'tijaji_slider_url_4', '' ); }
function tijaji_slider_url_5() { return get_theme_mod( 'tijaji_slider_url_5', '' ); }
function tijaji_slider_txt_shadow() { return get_theme_mod( 'tijaji_slider_txt_shadow', 'slidertxt_shadow' ); }
function tijaji_display_header_description() { return get_theme_mod( 'tijaji_display_header_description', '2' );}
function tijaji_display_header_description_type() { return get_theme_mod( 'tijaji_display_header_description_type', '3' );}
function tijaji_header_img_place() { return get_theme_mod( 'tijaji_header_img_place', '3' );}
function tijaji_display_single_category() { return get_theme_mod( 'tijaji_display_single_category', true );}
function tijaji_display_single_date() { return get_theme_mod( 'tijaji_display_single_date', true );}
function tijaji_display_single_author() { return get_theme_mod( 'tijaji_display_single_author', true );}
function tijaji_display_single_thumbnail() { return get_theme_mod( 'tijaji_display_single_thumbnail', true );}
function tijaji_display_single_pagenav() { return get_theme_mod( 'tijaji_display_single_pagenav', true );}
function tijaji_display_page_date() { return get_theme_mod( 'tijaji_display_page_date', true );}
function tijaji_display_page_author() { return get_theme_mod( 'tijaji_display_page_author', true );}
function tijaji_display_list_img() { return get_theme_mod( 'tijaji_display_list_img', true );}
function tijaji_display_list_category() { return get_theme_mod( 'tijaji_display_list_category', true );}
function tijaji_display_list_date() { return get_theme_mod( 'tijaji_display_list_date', true );}
function tijaji_display_list_comment() { return get_theme_mod( 'tijaji_display_list_comment', true );}
function tijaji_layout() { return get_theme_mod( 'tijaji_layout','right' );}
function tijaji_listcontent() { return get_theme_mod( 'tijaji_listcontent','excerpt' );}
function tijaji_footerwidget() { return get_theme_mod( 'tijaji_footerwidget','4' );}
function tijaji_sp_headermenu() { return get_theme_mod( 'tijaji_sp_headermenu','2' );}
function tijaji_max_content_width() { return get_theme_mod( 'tijaji_max_content_width','width1050' );}
function tijaji_display_totop() { return get_theme_mod( 'tijaji_display_totop', 'totop1' );}
function tijaji_display_sitename() { return get_theme_mod( 'tijaji_display_sitename', '1' );}
function tijaji_hbg_color() { return get_theme_mod( 'tijaji_hbg_color', '' );}

function tijaji_sanitize_checkbox( $tijaji_checked ) {
	return ( ( isset( $tijaji_checked ) && true == $tijaji_checked ) ? true : false );
}

function tijaji_sanitize_select( $tijaji_input, $tijaji_setting ) {
	$tijaji_input = sanitize_key( $tijaji_input );
	$tijaji_choices = $tijaji_setting->manager->get_control($tijaji_setting->id)->choices;
	return ( array_key_exists( $tijaji_input, $tijaji_choices ) ? $tijaji_input : $tijaji_setting->default );
}

function tijaji_sanitize_text( $input ) {
	return wp_kses_post( force_balance_tags( $input ) );
}

function tijaji_customizer_color() {
echo 'body{font-family:"';
	if ( tijaji_fontfamily() == 1 ) echo 'Noto Sans JP';
	if ( tijaji_fontfamily() == 2 ) echo 'Noto Sans Japanese'; 
	if ( tijaji_fontfamily() == 3 ) echo 'Mplus 1p'; 
	if ( tijaji_fontfamily() == 4 ) echo 'Rounded Mplus 1c'; 
	if ( tijaji_fontfamily() == 5 ) echo 'Hannari'; 
	if ( tijaji_fontfamily() == 6 ) echo 'Kokoro'; 
	if ( tijaji_fontfamily() == 7 ) echo 'Nikukyu';
	if ( tijaji_fontfamily() == 8 ) echo 'Nico Moji'; 
	if ( tijaji_fontfamily() == 9 ) echo 'Sawarabi Gothic'; 
	if ( tijaji_fontfamily() == 10 ) echo 'Sawarabi Mincho'; 
	echo '";';
echo 'font-size: ' . esc_attr( get_theme_mod( 'tijaji_fontsize','15px' ) ) . ';}';
echo "body,.comment-author-link a,.looptext,.looptext a,.page-links a span,.loopdate,.footer,.footers a,.footerwidget a,.footermenu ul li a,.pagination a {color:" . esc_attr( get_theme_mod( 'tijaji_fontcolor','#333333' ) ) . ';}';
echo 'h1{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h1_fontsize','2.0em' ))) . ';}';
echo 'h2{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h2_fontsize','2.0em' ))) . ';}';
echo 'h3{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h3_fontsize','1.5em' ))) . ';}';
echo 'h4{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h4_fontsize','1.5em' ))) . ';}';
echo 'h5{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h5_fontsize','1.3em' ))) . ';}';
echo 'h6{font-size: ' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_h6_fontsize','1.1em' ))) . ';}';
echo '.sidebox ul li :after{background:' . esc_attr( get_theme_mod( 'tijaji_fontcolor','#333333' ) ) . ';}';
echo '.disc {font-size:' . esc_attr( get_theme_mod( 'tijaji_h_d_fontsize','10px' ) ) . ';';
echo 'color:' . esc_attr( get_theme_mod( 'tijaji_header_description_color','#666666' ) ) . ';}';
echo 'a {color:' . esc_attr( get_theme_mod( 'tijaji_link_color','#0066cc') ) . ';}';
echo '.sitename a,.sitename a:hover {color:' . esc_attr( get_theme_mod( 'tijaji_site_title_color','#000000' ) ) . ';}';
echo '.sitename {font-size:' . esc_attr( get_theme_mod( 'tijaji_titlefontsize','28px' ) ) . ';';
echo 'font-family: "';
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 1 ) echo 'Noto Sans JP';
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 2 ) echo 'Noto Sans Japanese'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 3 ) echo 'Mplus 1p'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 4 ) echo 'Rounded Mplus 1c'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 5 ) echo 'Hannari'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 6 ) echo 'Kokoro'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 7 ) echo 'Nikukyu';
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 8 ) echo 'Nico Moji'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 9 ) echo 'Sawarabi Gothic'; 
	if ( get_theme_mod( 'tijaji_titlefontfamily','2' ) == 10 ) echo 'Sawarabi Mincho';
echo '";}';
echo '.headermenu ul li a,.menu-header-container ul li a,.navi ul li a {border-bottom:2px solid ' . esc_attr( get_theme_mod( 'tijaji_link_color','#0066cc') ) . ';}';
echo '.editlink a,.tagcloud a:hover,.taglist a:hover,.singlecat a:hover,.form-submit input,.editlink_comment a,.page-links a span:hover,.pagination a:hover  {background:' . esc_attr( get_theme_mod( 'tijaji_link_color','#0066cc' ) ) . ';}';
echo 'a:hover {color:' . esc_attr( get_theme_mod( 'tijaji_link_hover_color','#cc0000') ) . ';}';
echo '.headermenu ul li a:hover,.menu-header-container ul li a:hover,.navi ul li a:hover {border-bottom:2px solid ' . esc_attr( get_theme_mod( 'tijaji_link_hover_color','#cc0000') ) . ';}';
echo '.editlink_comment a:hover,.editlink a:hover,.form-submit input:hover {background:' . esc_attr( get_theme_mod( 'tijaji_link_hover_color','#cc0000') ) . ';}';
if( tijaji_slider_number() != '1' ) { 
	echo '.slidertxt {color:' . esc_attr( get_theme_mod( 'tijaji_slider_txt_color','#ffffff' ) ) . ';}';
}
if(tijaji_hbg_color()) echo '.header{background:' . esc_attr( tijaji_hbg_color() ) . ';}';
if( has_custom_header() || tijaji_header_img_type() == 3 || tijaji_header_background_image() || tijaji_hbg_color()) echo '.sitebody{box-shadow:0px 2px 2px #ccc inset;-moz-box-shadow: 0px 2px 2px #ccc inset;-webkit-box-shadow: 0px 2px 2px #ccc inset;}';
if( tijaji_listcontent() == 'excerpt' ) {
	echo '.loopbox:hover { background-color: #f9f9f9; }';
}elseif( tijaji_listcontent() == 'indexcontent' ) {
	if ( !is_home() && has_post_thumbnail() ) {
		echo '.loopbox:hover { background-color: #f9f9f9; }';
	}
}
if( get_theme_mod( 'tijaji_display_main_waku','1' ) == '1' ) { 
	echo esc_attr( '.contents,.loopbox{ box-shadow: 0px 0px 2px #ccc;-moz-box-shadow: 0px 0px 2px #ccc;-webkit-box-shadow: 0px 0px 2px #ccc; }' );
}
echo '@media screen and (max-width: 480px) {.sitebody {font-size:' . esc_attr( str_replace('b','.',get_theme_mod( 'tijaji_sp_fontsize','0.90em' ))) . ';}';
echo '.sitename {font-size:' . esc_attr( get_theme_mod( 'tijaji_sp_titlefontsize','28px' ) ) . ';}';
echo '.custom-logo-link img {width:' . esc_attr( get_theme_mod( 'tijaji_sp_titlelogo','60px' ) ) . ';max-width:' . esc_attr( get_theme_mod( 'tijaji_sp_titlelogo','60px' ) ) . ';}';
if( get_theme_mod( 'tijaji_display_sp_header_description', true ) != 'true' ) echo '.disc{display:none;}';
echo '}';
echo '@media screen and (min-width: 481px) {.custom-logo-link img {width:' . esc_attr( get_theme_mod( 'tijaji_titlelogo_width','80px' ) ) . ';max-width:' . esc_attr( get_theme_mod( 'tijaji_titlelogo_width','80px' ) ) . ';}}';
$fs = str_replace('px','',get_theme_mod( 'tijaji_fontsize','15px' ));
echo '@media screen and (max-width: 480px) {.looptxt_height{ max-height:' . absint($fs) * str_replace(array('b','em'),array('.',''),esc_attr(get_theme_mod( 'tijaji_sp_fontsize','0.90em' ))) * 1.6 * 2 . 'px;}}';
echo '@media only screen and (min-width: 481px) and (max-width: 768px) {.looptxt_height{ max-height:' . absint($fs) * 1.6 * 4 . 'px;}}';
echo '@media screen and (min-width: 769px) {.looptxt_height{ max-height:' . absint($fs) * 1.6 * 4 . 'px;}}';
}
add_action( 'wp_head', 'tijaji_customizer_color' ,36);
