<?php 

function tijaji_theme_customizer_extension_sidebar($tijaji_customize) {

	$tijaji_customize->add_panel( 'tijaji_decoration', array(
	'priority' => 34,
	'title' => __('Headline decoration', 'tijaji'),
	) );

	$tijaji_customize->add_section( 'tijaji_sidebar_h_deco', array (
	'title' => __( 'Sidebar Headline Decoration', 'tijaji' ),
	'panel' => 'tijaji_decoration',
	'priority' => 10,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_font', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_font', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_font',
	'content' => '<div class="deco_title decotop">' . __( 'Font setting', 'tijaji' ) . '</div>',
	'priority' => 5,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_fontsize', array (
	'default' => '17px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_fontsize', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_fontsize',
	'label' => __( 'Sidebar heading font size', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
	),
	'priority' => 10,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_fontfamily', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_fontfamily', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_fontfamily',
	'label' => __( 'Sidebar heading font family', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'1' => 'Noto Sans JP',
		'2' => 'Noto Sans Japanese',
		'3' => 'Mplus 1p',
		'4' => 'Rounded Mplus 1c',
		'5' => 'Hannari',
		'6' => 'Kokoro',
		'7' => 'Nikukyu',
		'8' => 'Nico Moji',
		'9' => 'Sawarabi Gothic',
		'10' => 'Sawarabi Mincho',
	),
	'priority' => 20,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_color', array (
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_color', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_color',
	'label' => __( 'Sidebar heading font color', 'tijaji' ),
	'priority' => 30,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_fontweight', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_fontweight', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_fontweight',
	'label' => __( 'Sidebar heading font weight', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'normal' => 'normal',
		'bold' => 'bold',
	),
	'priority' => 50,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_textalign', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_textalign', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_textalign',
	'label' => __( 'Sidebar heading text align', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'left' => 'left',
		'right' => 'right',
		'center' => 'center',
	),
	'priority' => 60,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_padding', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_padding', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_padding',
	'content' => '<div class="deco_title">' . __( 'Padding setting', 'tijaji' ) . '</div>',
	'priority' => 65,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_padding_top', array (
	'default' => '10px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_padding_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_padding_top',
	'label' => __( 'Top padding', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 70,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_padding_left', array (
	'default' => '10px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_padding_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_padding_left',
	'label' => __( 'Left padding', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 80,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_padding_right', array (
	'default' => '10px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_padding_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_padding_right',
	'label' => __( 'Right padding', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 90,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_padding_bottom', array (
	'default' => '10px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_padding_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_padding_bottom',
	'label' => __( 'Bottom padding', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 100,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_margin', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_margin', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_margin',
	'content' => '<div class="deco_title">' . __( 'margin setting', 'tijaji' ) . '</div>',
	'priority' => 105,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_margin_top', array (
	'default' => '0px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_margin_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_margin_top',
	'label' => __( 'Top margin', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 110,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_margin_left', array (
	'default' => '0px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_margin_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_margin_left',
	'label' => __( 'Left margin', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 120,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_margin_right', array (
	'default' => '0px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_margin_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_margin_right',
	'label' => __( 'Right margin', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 130,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_margin_bottom', array (
	'default' => '0px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_margin_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_margin_bottom',
	'label' => __( 'Bottom margin', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( 'Follow overall settings', 'tijaji' ),
		'0px' => '0px',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 140,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_background', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_background', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background',
	'content' => '<div class="deco_title">' . __( 'Background setting', 'tijaji' ) . '</div>',
	'priority' => 145,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_background_color', array (
	'default' => '#ffffff',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_background_color', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_color',
	'label' => __( 'Background color', 'tijaji' ),
	'priority' => 150,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_background_color_2', array (
	'default' => '#ededed',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_background_color_2', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_color_2',
	'label' => __( 'Background color No.2', 'tijaji' ),
	'description' => __( '(Setting this will result in a gradation.)', 'tijaji' ),
	'priority' => 160,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_g_direction', array (
	'default' => '270',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_g_direction', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_g_direction',
	'label' => __( 'Direction of the gradation', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'270' => '&#8595;',
		'315' => '&#8600;',
		'0' => '&#8594;',
		'45' => '&#8599;',
		'90' => '&#8593;',
		'135' => '&#8598;',
		'180' => '&#8592;',
		'225' => '&#8601;',
	),
	'priority' => 170,
	));

	$tijaji_customize->add_setting('tijaji_sidebar_h_background_img',array(
	'default' => '',
	'sanitize_callback' => 'esc_url_raw',
	));
 	$tijaji_customize->add_control(new WP_Customize_Image_Control($tijaji_customize, 'tijaji_sidebar_h_background_img', array(
	'label' => __( 'Background image', 'tijaji' ),
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_img',
	'priority' => 180,
	)));

	$tijaji_customize->add_setting('tijaji_sidebar_h_background_img_repeat',array(
	'default' => 'no-repeat',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
 	$tijaji_customize->add_control( 'tijaji_sidebar_h_background_img_repeat', array(
	'label' => __( 'Repeat background image?', 'tijaji' ),
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_img_repeat',
	'type' => 'select',
	'choices' => array(
		'no-repeat' => __( 'No repeat', 'tijaji' ),
		'repeat-y' => __( 'Repeat vertically', 'tijaji' ),
		'repeat-x' => __( 'Repeat beside', 'tijaji' ),
		'repeat' => __( 'Repeat', 'tijaji' ),
	),
	'priority' => 190,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_img_position_x', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_img_position_x', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_img_position_x',
	'label' => __( 'Horizontal position', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( '0% (Left)', 'tijaji' ),
		'1' => '1%',
		'2' => '2%',
		'3' => '3%',
		'4' => '4%',
		'5' => '5%',
		'6' => '6%',
		'7' => '7%',
		'8' => '8%',
		'9' => '9%',
		'10' => '10%',
		'15' => '15%',
		'20' => '20%',
		'25' => '25%',
		'30' => '30%',
		'35' => '35%',
		'40' => '40%',
		'45' => '45%',
		'50' => __( '50% (Center)', 'tijaji' ),
		'55' => '55%',
		'60' => '60%',
		'65' => '65%',
		'70' => '70%',
		'75' => '75%',
		'80' => '80%',
		'85' => '85%',
		'90' => '90%',
		'91' => '91%',
		'92' => '92%',
		'93' => '93%',
		'94' => '94%',
		'95' => '95%',
		'96' => '96%',
		'97' => '97%',
		'98' => '98%',
		'99' => '99%',
		'100' => __( '100% (Right)', 'tijaji' ),
	),
	'priority' => 195,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_img_position_y', array (
	'default' => '50',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_img_position_y', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_img_position_y',
	'label' => __( 'Vertical position', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => __( '0% (Top)', 'tijaji' ),
		'1' => '1%',
		'2' => '2%',
		'3' => '3%',
		'4' => '4%',
		'5' => '5%',
		'6' => '6%',
		'7' => '7%',
		'8' => '8%',
		'9' => '9%',
		'10' => '10%',
		'15' => '15%',
		'20' => '20%',
		'25' => '25%',
		'30' => '30%',
		'35' => '35%',
		'40' => '40%',
		'45' => '45%',
		'50' => __( '50% (Center)', 'tijaji' ),
		'55' => '55%',
		'60' => '60%',
		'65' => '65%',
		'70' => '70%',
		'75' => '75%',
		'80' => '80%',
		'85' => '85%',
		'90' => '90%',
		'91' => '91%',
		'92' => '92%',
		'93' => '93%',
		'94' => '94%',
		'95' => '95%',
		'96' => '96%',
		'97' => '97%',
		'98' => '98%',
		'99' => '99%',
		'100' => __( '100% (Bottom)', 'tijaji' ),
	),
	'priority' => 200,
	));

	$tijaji_customize->add_setting('tijaji_sidebar_h_background_img_h_size',array(
	'default' => '30px',
	'sanitize_callback' => 'sanitize_text_field',

	));
 	$tijaji_customize->add_control( 'tijaji_sidebar_h_background_img_h_size', array(
	'label' => __( 'Background image width', 'tijaji' ),
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_img_h_size',
	'description' => __( 'Example => 30px, 50px, 50%, 100%, auto, cover etc.', 'tijaji' ),
	'type'  => 'text',
	'priority' => 205,
	));

	$tijaji_customize->add_setting('tijaji_sidebar_h_background_img_v_size',array(
	'default' => 'auto',
	'sanitize_callback' => 'sanitize_text_field',

	));
 	$tijaji_customize->add_control( 'tijaji_sidebar_h_background_img_v_size', array(
	'label' => __( 'Background image height', 'tijaji' ),
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_background_img_v_size',
	'description' => __( 'Example => 30px, 50px, 50%, 100%, auto, cover etc.', 'tijaji' ),
	'type'  => 'text',
	'priority' => 206,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_radius', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_radius', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_radius',
	'content' => '<div class="deco_title">' . __( 'Rounded corners setting', 'tijaji' ) . '</div>',
	'priority' => 210,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_radius_top', array (
	'default' => '2px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_radius_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_radius_top',
	'label' => __( 'Top left radius', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'25px' => '25px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'800px' => __( 'Max', 'tijaji' ),
	),
	'priority' => 211,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_radius_left', array (
	'default' => '2px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_radius_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_radius_left',
	'label' => __( 'Top right radius', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'25px' => '25px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'800px' => __( 'Max', 'tijaji' ),
	),
	'priority' => 212,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_radius_right', array (
	'default' => '2px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_radius_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_radius_right',
	'label' => __( 'Bottom right radius', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'25px' => '25px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'800px' => __( 'Max', 'tijaji' ),
	),
	'priority' => 213,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_radius_bottom', array (
	'default' => '2px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_radius_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_radius_bottom',
	'label' => __( 'Bottom left radius', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'25px' => '25px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'800px' => __( 'Max', 'tijaji' ),
	),
	'priority' => 214,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_border', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border',
	'content' => '<div class="deco_title">' . __( 'Border setting', 'tijaji' ) . '</div>',
	'priority' => 215,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_weight_top', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_weight_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_weight_top',
	'label' => __( 'Top border weight', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 220,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_weight_left', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_weight_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_weight_left',
	'label' => __( 'Left border weight', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 230,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_weight_right', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_weight_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_weight_right',
	'label' => __( 'Right border weight', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 240,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_weight_bottom', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_weight_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_weight_bottom',
	'label' => __( 'Bottom border weight', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
		'16px' => '16px',
		'17px' => '17px',
		'18px' => '18px',
		'19px' => '19px',
		'20px' => '20px',
		'21px' => '21px',
		'22px' => '22px',
		'23px' => '23px',
		'24px' => '24px',
		'25px' => '25px',
		'26px' => '26px',
		'27px' => '27px',
		'28px' => '28px',
		'29px' => '29px',
		'30px' => '30px',
		'35px' => '35px',
		'40px' => '40px',
		'45px' => '45px',
		'50px' => '50px',
	),
	'priority' => 250,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_color_top', array (
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_border_color_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_color_top',
	'label' => __( 'Top border color', 'tijaji' ),
	'priority' => 223,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_color_left', array (
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_border_color_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_color_left',
	'label' => __( 'Left border color', 'tijaji' ),
	'priority' => 233,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_color_right', array (
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_border_color_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_color_right',
	'label' => __( 'Right border color', 'tijaji' ),
	'priority' => 243,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_color_bottom', array (
	'default' => '#333333',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_border_color_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_color_bottom',
	'label' => __( 'Bottom border color', 'tijaji' ),
	'priority' => 253,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_type_top', array (
	'default' => 'solid',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_type_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_type_top',
	'label' => __( 'Top border type', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'solid' => __( 'solid', 'tijaji' ),
		'double' => __( 'double', 'tijaji' ),
		'dashed' => __( 'dashed', 'tijaji' ),
		'dotted' => __( 'dotted', 'tijaji' ),
		'inset' => __( 'inset', 'tijaji' ),
		'outset' => __( 'outset', 'tijaji' ),
		'groove' => __( 'groove', 'tijaji' ),
		'ridge' => __( 'ridge', 'tijaji' ),
	),
	'priority' => 226,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_type_left', array (
	'default' => 'solid',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_type_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_type_left',
	'label' => __( 'Left border type', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'solid' => __( 'solid', 'tijaji' ),
		'double' => __( 'double', 'tijaji' ),
		'dashed' => __( 'dashed', 'tijaji' ),
		'dotted' => __( 'dotted', 'tijaji' ),
		'inset' => __( 'inset', 'tijaji' ),
		'outset' => __( 'outset', 'tijaji' ),
		'groove' => __( 'groove', 'tijaji' ),
		'ridge' => __( 'ridge', 'tijaji' ),
	),
	'priority' => 236,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_type_right', array (
	'default' => 'solid',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_type_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_type_right',
	'label' => __( 'Right border type', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'solid' => __( 'solid', 'tijaji' ),
		'double' => __( 'double', 'tijaji' ),
		'dashed' => __( 'dashed', 'tijaji' ),
		'dotted' => __( 'dotted', 'tijaji' ),
		'inset' => __( 'inset', 'tijaji' ),
		'outset' => __( 'outset', 'tijaji' ),
		'groove' => __( 'groove', 'tijaji' ),
		'ridge' => __( 'ridge', 'tijaji' ),
	),
	'priority' => 246,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_type_bottom', array (
	'default' => 'solid',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_border_type_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_type_bottom',
	'label' => __( 'Bottom border type', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'solid' => __( 'solid', 'tijaji' ),
		'double' => __( 'double', 'tijaji' ),
		'dashed' => __( 'dashed', 'tijaji' ),
		'dotted' => __( 'dotted', 'tijaji' ),
		'inset' => __( 'inset', 'tijaji' ),
		'outset' => __( 'outset', 'tijaji' ),
		'groove' => __( 'groove', 'tijaji' ),
		'ridge' => __( 'ridge', 'tijaji' ),
	),
	'priority' => 256,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_top', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_border_top', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_top',
	'content' => '<div class="deco_sub_title"><span class="top_border">' . __( 'Top Border', 'tijaji' ) . '</span></div>',
	'priority' => 219,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_left', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_border_left', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_left',
	'content' => '<div class="deco_sub_title"><span class="left_border">' . __( 'Left Border', 'tijaji' ) . '</span></div>',
	'priority' => 229,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_right', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_border_right', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_right',
	'content' => '<div class="deco_sub_title"><span class="right_border">' . __( 'Right Border', 'tijaji' ) . '</span></div>',
	'priority' => 239,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_border_bottom', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_border_bottom', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_border_bottom',
	'content' => '<div class="deco_sub_title"><span class="bottom_border">' . __( 'Bottom Border', 'tijaji' ) . '</span></div>',
	'priority' => 249,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_text_shadow', array (
	'sanitize_callback' => 'sanitize_text_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_text_shadow', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_text_shadow',
	'content' => '<div class="deco_title">' . __( 'Text shadow setting', 'tijaji' ) . '</div>',
	'priority' => 260,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_text_shadow_horizontal', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_text_shadow_horizontal', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_text_shadow_horizontal',
	'label' => __( 'Text shadow horizontal offset', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'-15px' => '-15px',
		'-14px' => '-14px',
		'-13px' => '-13px',
		'-12px' => '-12px',
		'-11px' => '-11px',
		'-10px' => '-10px',
		'-9px' => '-9px',
		'-8px' => '-8px',
		'-7px' => '-7px',
		'-6px' => '-6px',
		'-5px' => '-5px',
		'-4px' => '-4px',
		'-3px' => '-3px',
		'-2px' => '-2px',
		'-1px' => '-1px',
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 280,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_text_shadow_vertical', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_text_shadow_vertical', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_text_shadow_vertical',
	'label' => __( 'Text shadow vertical offset', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'-15px' => '-15px',
		'-14px' => '-14px',
		'-13px' => '-13px',
		'-12px' => '-12px',
		'-11px' => '-11px',
		'-10px' => '-10px',
		'-9px' => '-9px',
		'-8px' => '-8px',
		'-7px' => '-7px',
		'-6px' => '-6px',
		'-5px' => '-5px',
		'-4px' => '-4px',
		'-3px' => '-3px',
		'-2px' => '-2px',
		'-1px' => '-1px',
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 290,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_text_shadow_length', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_text_shadow_length', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_text_shadow_length',
	'label' => __( 'Text shadow length', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 270,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_text_shadow_color', array (
	'default' => '#666666',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_text_shadow_color', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_text_shadow_color',
	'label' => __( 'Text shadow color', 'tijaji' ),
	'priority' => 300,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow', array (
	'sanitize_callback' => 'sanitize_box_field',
	));
	$tijaji_customize->add_control( new tijaji_Custom_Content( $tijaji_customize, 'tijaji_sidebar_h_box_shadow', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow',
	'content' => '<div class="deco_title">' . __( 'Box shadow setting', 'tijaji' ) . '</div>',
	'priority' => 320,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow_horizontal', array (
	'default' => '0',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_box_shadow_horizontal', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow_horizontal',
	'label' => __( 'Box shadow horizontal offset', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'-15px' => '-15px',
		'-14px' => '-14px',
		'-13px' => '-13px',
		'-12px' => '-12px',
		'-11px' => '-11px',
		'-10px' => '-10px',
		'-9px' => '-9px',
		'-8px' => '-8px',
		'-7px' => '-7px',
		'-6px' => '-6px',
		'-5px' => '-5px',
		'-4px' => '-4px',
		'-3px' => '-3px',
		'-2px' => '-2px',
		'-1px' => '-1px',
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 340,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow_vertical', array (
	'default' => '1px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_box_shadow_vertical', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow_vertical',
	'label' => __( 'Box shadow vertical offset', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'-15px' => '-15px',
		'-14px' => '-14px',
		'-13px' => '-13px',
		'-12px' => '-12px',
		'-11px' => '-11px',
		'-10px' => '-10px',
		'-9px' => '-9px',
		'-8px' => '-8px',
		'-7px' => '-7px',
		'-6px' => '-6px',
		'-5px' => '-5px',
		'-4px' => '-4px',
		'-3px' => '-3px',
		'-2px' => '-2px',
		'-1px' => '-1px',
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 350,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow_length', array (
	'default' => '3px',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_box_shadow_length', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow_length',
	'label' => __( 'Box shadow length', 'tijaji' ),
	'type' => 'select',
	'choices' => array(
		'0' => 'none',
		'1px' => '1px',
		'2px' => '2px',
		'3px' => '3px',
		'4px' => '4px',
		'5px' => '5px',
		'6px' => '6px',
		'7px' => '7px',
		'8px' => '8px',
		'9px' => '9px',
		'10px' => '10px',
		'11px' => '11px',
		'12px' => '12px',
		'13px' => '13px',
		'14px' => '14px',
		'15px' => '15px',
	),
	'priority' => 330,
	));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow_color', array (
	'default' => '#999999',
	'sanitize_callback' => 'sanitize_hex_color',
	));
	$tijaji_customize->add_control( new WP_Customize_Color_Control( $tijaji_customize, 'tijaji_sidebar_h_box_shadow_color', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow_color',
	'label' => __( 'Box shadow color', 'tijaji' ),
	'priority' => 360,
	)));

	$tijaji_customize->add_setting( 'tijaji_sidebar_h_box_shadow_inout', array (
	'default' => '',
	'sanitize_callback' => 'tijaji_sanitize_select',
	));
	$tijaji_customize->add_control( 'tijaji_sidebar_h_box_shadow_inout', array(
	'section' => 'tijaji_sidebar_h_deco',
	'settings' => 'tijaji_sidebar_h_box_shadow_inout',
	'label' => __( 'Inside or outside', 'tijaji' ),
	'type' => 'radio',
	'choices' => array(
		'' => __( 'Outside', 'tijaji' ),
		'inset' => __( 'Inside', 'tijaji' ),
	),
	'priority' => 370,
	));
}
add_action('customize_register', 'tijaji_theme_customizer_extension_sidebar');



function tijaji_customizer_style_sidebar() { ?>
.sidebox h3 { <?php 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 1 ) echo 'font-family: "Noto Sans JP";';
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 2 ) echo 'font-family: "Noto Sans Japanese";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 3 ) echo 'font-family: "Mplus 1p";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 4 ) echo 'font-family: "Rounded Mplus 1c";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 5 ) echo 'font-family: "Hannari";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 6 ) echo 'font-family: "Kokoro";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 7 ) echo 'font-family: "Nikukyu";';
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 8 ) echo 'font-family: "Nico Moji";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 9 ) echo 'font-family: "Sawarabi Gothic";'; 
	if ( get_theme_mod( 'tijaji_sidebar_h_fontfamily','0' ) == 10 ) echo 'font-family: "Sawarabi Mincho";';
if ( get_theme_mod( 'tijaji_sidebar_h_fontsize','17px' ) != 0 ) echo 'font-size:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_fontsize','17px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_color','#333333' ) ) echo 'color:' . esc_attr( get_theme_mod( 'tijaji_sidebar_h_color','#333333' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_fontweight','0' ) != '0' ) echo 'font-weight:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_fontweight','0' ) ) . ' !important;';
if ( get_theme_mod( 'tijaji_sidebar_h_textalign','0' ) != '0' ) echo 'text-align:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_textalign','0' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_padding_top','10px' ) != '0' ) echo 'padding-top:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_padding_top','10px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_padding_left','10px' ) != '0' ) echo 'padding-left:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_padding_left','10px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_padding_right','10px' ) != '0' ) echo 'padding-right:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_padding_right','10px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_padding_bottom','10px' ) != '0' ) echo 'padding-bottom:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_padding_bottom','10px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_margin_top','0px' ) != '0' ) echo 'margin-top:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_margin_top','0px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_margin_left','0px' ) != '0' ) echo 'margin-left:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_margin_left','0px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_margin_right','0px' ) != '0' ) echo 'margin-right:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_margin_right','0px' ) ) . ';';
if ( get_theme_mod( 'tijaji_sidebar_h_margin_bottom','0px' ) != '0' ) echo 'margin-bottom:' .  esc_attr( get_theme_mod( 'tijaji_sidebar_h_margin_bottom','0px' ) ) . ';';
$color1 = get_theme_mod( 'tijaji_sidebar_h_background_color','#ffffff' );
$color2 = get_theme_mod( 'tijaji_sidebar_h_background_color_2','#ededed' );
$direction = get_theme_mod( 'tijaji_sidebar_h_g_direction','270' );
if ( $direction == '270' || $direction == '90' ) $offset = '90';
if ( $direction == '0' || $direction == '180' ) $offset = '270';
if ( $direction == '135' || $direction == '315' ) $offset = '180';
if ( $direction == '45' || $direction == '225' ) $offset = '360';
$image = get_theme_mod( 'tijaji_sidebar_h_background_img','' );
if ( $image ) {
$ih_size = get_theme_mod( 'tijaji_sidebar_h_background_img_h_size','30px' );
$iv_size = get_theme_mod( 'tijaji_sidebar_h_background_img_v_size','auto' );
	echo 'background:url(' . esc_attr( $image ) . ') ' . esc_attr( $color1 ) . ';';
	echo 'background-repeat: ' . esc_attr( get_theme_mod( 'tijaji_sidebar_h_background_img_repeat','no-repeat' ) ) . ' !important;';
	echo 'background-position:' . esc_attr(get_theme_mod('tijaji_sidebar_h_img_position_x','0')) .'% '. esc_attr(get_theme_mod('tijaji_sidebar_h_img_position_y','50')) . '% !important;';
	if ( $color2 ) {
		echo 'background:url(' . esc_attr( $image ) . '), ' . 'linear-gradient(' . intval( $direction - $offset ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
		echo 'background:url(' . esc_attr( $image ) . '), ' . '-moz-linear-gradient(' . intval( $direction ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
		echo 'background:url(' . esc_attr( $image ) . '), ' . '-webkit-linear-gradient(' . intval( $direction ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
	}
	if( $ih_size || $iv_size ) { echo 'background-size:' . esc_attr( $ih_size ) . ' ' . esc_attr( $iv_size ) . ', 100% 100%;'; }
}else{
	if ( $color1 ) {
		echo 'background:' . esc_attr( $color1 ) . ';';
	}
	if ( $color2 ) {
		echo 'background:linear-gradient(' . intval( $direction - $offset ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
		echo 'background:-moz-linear-gradient(' . intval( $direction ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
		echo 'background:-webkit-linear-gradient(' . intval( $direction ) .'deg,'. esc_attr( $color1 ) .' 0%,'. esc_attr( $color2 ) . ' 100%);';
	}
}
$bw_t = get_theme_mod( 'tijaji_sidebar_h_border_weight_top','0' );
$bw_l = get_theme_mod( 'tijaji_sidebar_h_border_weight_left','0' );
$bw_r = get_theme_mod( 'tijaji_sidebar_h_border_weight_right','0' );
$bw_b = get_theme_mod( 'tijaji_sidebar_h_border_weight_bottom','0' );
$bs_t = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_type_top','solid' );
$bs_l = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_type_left','solid' );
$bs_r = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_type_right','solid' );
$bs_b = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_type_bottom','solid' );
$bc_t = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_color_top','#333333' );
$bc_l = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_color_left','#333333' );
$bc_r = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_color_right','#333333' );
$bc_b = ' ' . get_theme_mod( 'tijaji_sidebar_h_border_color_bottom','#333333' );
if ( $bw_t != '0' ) echo 'border-top:' . esc_attr( $bw_t ) . esc_attr( $bs_t ) . esc_attr( $bc_t ) . ';';
if ( $bw_l != '0' ) echo 'border-left:' . esc_attr( $bw_l ) . esc_attr( $bs_l ) . esc_attr( $bc_l ) . ';';
if ( $bw_r != '0' ) echo 'border-right:' . esc_attr( $bw_r ) . esc_attr( $bs_r ) . esc_attr( $bc_r ) . ';';
if ( $bw_b != '0' ) echo 'border-bottom:' . esc_attr( $bw_b ) . esc_attr( $bs_b ) . esc_attr( $bc_b ) . ';';
$br_t = get_theme_mod( 'tijaji_sidebar_h_radius_top','2px' );
$br_l = ' ' . get_theme_mod( 'tijaji_sidebar_h_radius_left','2px' );
$br_r = ' ' . get_theme_mod( 'tijaji_sidebar_h_radius_right','2px' );
$br_b = ' ' . get_theme_mod( 'tijaji_sidebar_h_radius_bottom','2px' );
if ( $br_t != '0' || $br_l != '0' || $br_r != '0' || $br_b != '0'  ) {
	echo 'border-radius:' . esc_attr( $br_t ) . esc_attr( $br_l ) . esc_attr( $br_r ) . esc_attr( $br_b ) . ';';
	echo '-moz-border-radius:' . esc_attr( $br_t ) . esc_attr( $br_l ) . esc_attr( $br_r ) . esc_attr( $br_b ) . ';';
	echo '-webkit-border-radius:' . esc_attr( $br_t ) . esc_attr( $br_l ) . esc_attr( $br_r ) . esc_attr( $br_b ) . ';';
}
$ts_h = get_theme_mod( 'tijaji_sidebar_h_text_shadow_horizontal','0' );
$ts_v = ' ' . get_theme_mod( 'tijaji_sidebar_h_text_shadow_vertical','0' );
$ts_l = ' ' . get_theme_mod( 'tijaji_sidebar_h_text_shadow_length','0' );
$ts_c = ' ' . get_theme_mod( 'tijaji_sidebar_h_text_shadow_color','#666666' );
if ( $ts_l != 0 ) {
	echo 'text-shadow:' . esc_attr( $ts_h ) . esc_attr( $ts_v ) . esc_attr( $ts_l ) . esc_attr( $ts_c ) . ';';
	echo '-moz-text-shadow:' . esc_attr( $ts_h ) . esc_attr( $ts_v ) . esc_attr( $ts_l ) . esc_attr( $ts_c ) . ';';
	echo '-webkit-text-shadow:' . esc_attr( $ts_h ) . esc_attr( $ts_v ) . esc_attr( $ts_l ) . esc_attr( $ts_c ) . ';';
}
$boxs_h = get_theme_mod( 'tijaji_sidebar_h_box_shadow_horizontal','0' );
$boxs_v = ' ' . get_theme_mod( 'tijaji_sidebar_h_box_shadow_vertical','1px' );
$boxs_l = ' ' . get_theme_mod( 'tijaji_sidebar_h_box_shadow_length','3px' );
$boxs_c = ' ' . get_theme_mod( 'tijaji_sidebar_h_box_shadow_color','#999999' );
$boxs_io = ' ' . get_theme_mod( 'tijaji_sidebar_h_box_shadow_inout','' );
if ( $boxs_l != 0 ) {
	echo 'box-shadow:' . esc_attr( $boxs_h ) . esc_attr( $boxs_v ) . esc_attr( $boxs_l ) . esc_attr( $boxs_c ) . esc_attr( $boxs_io ) . ';';
	echo '-moz-box-shadow:' . esc_attr( $boxs_h ) . esc_attr( $boxs_v ) . esc_attr( $boxs_l ) . esc_attr( $boxs_c ) . esc_attr( $boxs_io ) . ';';
	echo '-webkit-box-shadow:' . esc_attr( $boxs_h ) . esc_attr( $boxs_v ) . esc_attr( $boxs_l ) . esc_attr( $boxs_c ) . esc_attr( $boxs_io ) . ';';
}
?>}<?php
}
add_action( 'wp_head', 'tijaji_customizer_style_sidebar' ,37 );
