<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width,initial-scale=1"/>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if ( tijaji_header_background_image() ) { ?>
<div class="header" style="background-image: url(<?php echo esc_url( tijaji_header_background_image() ); ?>);">
<?php }else{ ?>
<div class="header">
<?php } ?>
<?php function tijaji_header_description_set(){ ?>
	<div class="disc">
	<?php if( tijaji_display_header_description_type() == '3' ){ ?>

				<?php if ( is_front_page() ) {
					bloginfo( 'description' );
				} elseif ( is_tag() || is_category() || is_author() ) {
					/* translators: %s: term */
					echo sprintf( esc_html__( 'Page of %s.', 'tijaji') , wp_kses_post( get_the_archive_title( '' , false ) ) );
				}  elseif ( is_404() ) {
					esc_html_e( 'The page could not be found.' , 'tijaji');
				} elseif ( is_archive() ) {
					/* translators: %s: archive term */
					echo sprintf( esc_html__( '%s archive page.', 'tijaji'), wp_kses_post( get_the_archive_title() ) );
				} elseif ( is_search() ) {
					/* translators: %s: search term */
					printf( esc_html__( 'Search results for "%s"','tijaji' ), get_search_query( '',false ) );
				} elseif ( is_single() or is_page() ) {
					/* translators: %s: search term */
					echo sprintf( esc_html__( 'Page of "%s".', 'tijaji'), get_the_title() );
				} else {
					bloginfo( 'description' ); 
				}
				/* translators: %s: page number */
				if(get_query_var('paged') > 0 ) echo sprintf( esc_html__( 'Page of %s.', 'tijaji'), esc_html( get_query_var('paged') ) );	

	}else{
		bloginfo( 'description' );

	}
?></div>
<?php } ?>

	<div class="inheader <?php echo esc_attr( tijaji_max_content_width() ); ?>">
	<?php if( tijaji_display_header_description() == '3' ){ echo '<div class="disc_t">'; tijaji_header_description_set(); echo '</div>'; } ?>
	<header>
	<div id="header" class="sitetopdiv" itemscope itemtype="https://schema.org/Organization">
		<div class="logo"><?php if( tijaji_display_sitename() != '1' ) {
				if( is_front_page() || is_home() || is_404() ) {
					echo '<h1>';
				}
			}
			the_custom_logo();
			if( tijaji_display_sitename() != '1' ) {
				if( is_front_page() || is_home() || is_404() ) {
					echo '</h1>';
				}
			} ?></div>
		<div class="sitetop">
			<?php if( tijaji_display_header_description() == '1' ){ tijaji_header_description_set(); } ?>
			<?php if( tijaji_display_sitename() == '1' ) { ?>
				<?php if( is_front_page() || is_home() || is_404() ) { ?>
				<div class="sitename" itemprop="name"><h1><a href="<?php echo esc_url( home_url() ); ?>/" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a></h1></div>
				<?php } else { ?>
				<div class="sitename" itemprop="name"><a href="<?php echo esc_url( home_url() ); ?>/" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a></div>
				<?php } ?>
			<?php } ?>
			<?php if( tijaji_display_header_description() == '2' ){ tijaji_header_description_set(); } ?>
		</div>
	</div>

	<?php if ( has_nav_menu( 'header-menu' ) ) { ?>
	<div class="headermenublocks">
		<div class="headermenublock">
		<input type="checkbox" class="check" id="checked">
		<label class="menu_open" for="checked"></label>
		<label class="menu_close" for="checked"></label>
			<div class="navi">
			<nav>
			<?php wp_nav_menu( array( 'theme_location' => 'header-menu' ) );?>
			<div class="clear"></div>
			</nav>
			</div>
		</div>	
	</div>
	<?php } ?>

	</header>
	</div>
</div>

	<?php tijaji_header_images(); ?>

<div class="sitebody">
<div class="inbody <?php echo esc_attr( tijaji_max_content_width() ); ?>">
<?php dynamic_sidebar( 'content_top' ); ?>
	<div id="main" class="<?php echo esc_attr( tijaji_layout() ); ?>_content">