<?php

function tijaji_text_domain(){
	load_theme_textdomain( 'tijaji', get_template_directory() . '/languages' );
}
add_action('after_setup_theme', 'tijaji_text_domain');

function tijaji_generator() {
	echo '<meta name="generator" content="' .  esc_html( wp_get_theme()->name . ' ' .  wp_get_theme()->version ) . '" />' . "\n";
}
add_action( 'wp_head', 'tijaji_generator' );

function tijaji_theme_support() {

	add_theme_support( 'title-tag' );
	add_theme_support( 'customize-selective-refresh-widgets' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
	add_theme_support( 'post-formats', array( 'aside', 'video' ) );
	if ( function_exists( 'register_nav_menus' ) ) {
  		register_nav_menus(
  			array(
  				'header-menu' => __( 'Header Menu', 'tijaji' ),
  				'footer-menu' => __( 'Footer Menu', 'tijaji' ),
  			)
  		);
	}

	$tijaji_args = array(
		'default' => get_template_directory_uri() . '/images/default-1.jpg',
		'width' => 1920,
		'height' => 600,
		'uploads' => true,
		'header-text' => false,
		'default-text-color' => '000000',
		'video' => true,
	);
	add_theme_support( 'custom-header', $tijaji_args );

	register_default_headers( array(
		'default-image' => array(
			'url'           => get_template_directory_uri() . '/images/default-1.jpg',
			'thumbnail_url' => get_template_directory_uri() . '/images/default-1.jpg',
		),
		'default-image_2' => array(
			'url'           => get_template_directory_uri() . '/images/default-2.jpg',
			'thumbnail_url' => get_template_directory_uri() . '/images/default-2.jpg',
		),
		'default-image_3' => array(
			'url'           => get_template_directory_uri() . '/images/default-3.jpg',
			'thumbnail_url' => get_template_directory_uri() . '/images/default-3.jpg',
		),
	) );
	add_theme_support( 'custom-logo', array(
		'height'      => 100,
		'width'       => 100,
		'flex-width' => true,
	) );
	$tijaji_background_param = array(
		'default-color' => 'f9f9f9'
	);
	add_theme_support( 'custom-background', $tijaji_background_param );
}
add_action( 'after_setup_theme', 'tijaji_theme_support' );


function tijaji_remove_tagline($tijaji_title) {
	if ( isset($tijaji_title['tagline']) ) {
		unset( $tijaji_title['tagline'] );
	}
	return $tijaji_title;
}
add_filter( 'document_title_parts', 'tijaji_remove_tagline' );

function tijaji_title_separator($tijaji_sep) {
	$tijaji_sep = '|';
	return $tijaji_sep;
}
add_filter( 'document_title_separator', 'tijaji_title_separator' );

function tijaji_widgets_init() {

	register_sidebar(array(
		'name' => __( 'Sidebar', 'tijaji' ),
		'id' => 'sidebar',
		'before_widget' => '<div class="sidebox">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));

	register_sidebar(array(
		'name' => __( 'Footer', 'tijaji' ),
		'id' => 'footer',
		'before_widget' => '<div class="footerwidget">',
		'after_widget' => '</div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));

	register_sidebar(array(
		'name' => __( 'Content top', 'tijaji' ),
		'id' => 'content_top',
		'description' => __( 'Ideal for displaying bread crumbs.', 'tijaji' ),
		'before_widget' => '<div class="contenttop">',
		'after_widget' => '</div><div class="clear"></div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));

	register_sidebar(array(
		'name' => __( 'Article Content bottom', 'tijaji' ),
		'id' => 'content_bottom',
		'description' => __( 'It is displayed directly under the article.', 'tijaji' ),
		'before_widget' => '<div class="contentbottom">',
		'after_widget' => '</div><div class="clear"></div>',
		'before_title' => '<h4>',
		'after_title' => '</h4>',
	));

}
add_action( 'widgets_init','tijaji_widgets_init' );

if ( !function_exists( 'tijaji_excerpt_length' ) ) {
	function tijaji_excerpt_length(  ) {

		if ( is_admin() ) {
			return;
		}
		return 140;
	}
}
add_filter( 'excerpt_length', 'tijaji_excerpt_length', 999 );

function tijaji_page_navi() {
	$pagination = get_the_posts_pagination( array( 'mid_size' => 2 ) );
	$pagination = str_replace(' role="navigation"', '', $pagination);

	$allowed_html = array(
		'a' => array( 'href' => array (), 'class' => array (), 'target' => array() ),
		'div' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'span' => array( 'style' => array (), 'class' => array (), 'aria-current' => array () ),
		'h2' => array( 'style' => array (), 'class' => array () ),
		'nav' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
	);

	echo wp_kses( $pagination, $allowed_html );
}

require get_template_directory() . '/inc/header-images.php';
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/customizer-sidebar.php';
require get_template_directory() . '/inc/theme-info.php';


$width = str_replace( array('width','full'),array('','1400'),tijaji_max_content_width());
if( tijaji_layout() == 'one' ) { $content_width = $width * 0.92; }
else{ $content_width = ( $width - 315 ) * 0.92; }


function tijaji_admin_notice(){

	if ( isset( $_GET['admin_notice'] ) ) {
		if( $_GET['admin_notice'] == '1' ) update_option( 'tijaji_admin_notice','1');
	}

	if( get_option('tijaji_admin_notice') ){
		return;
	}

	$html  = '<div class="notice-success notice"><p style="float:left">';
	$html .= __('[TIJAJI INFORMATION] We released TIJAJI Plus of the higher version! >>','tijaji');
	$html .= '<a href="https://tijaji.jp/plus/" target="_blank">';
	$html .= __(' Click here','tijaji');
	$html .= '</a></p>';
	$html .= '<p style="float:right"><a href="?admin_notice=1">';
	$html .= __('Do not display twice','tijaji');
	$html .= '</a></p><div class="clear"></div></div>';

	echo wp_kses_post($html);
}
add_action( 'admin_notices', 'tijaji_admin_notice' );


function tijaji_category_id_class($tijaji_classes) {

	global $post;
	if( $post && !is_search() && !is_404() ) { 
		foreach((get_the_category($post->ID)) as $category)
		$tijaji_classes [] = 'cat-' . $category->cat_ID . '-id';
	}
	return $tijaji_classes;

}
add_filter('post_class', 'tijaji_category_id_class');
add_filter('body_class', 'tijaji_category_id_class');


function tijaji_has_thumb_class($tijaji_classes) {
	global $post;
	if( has_post_thumbnail($post->ID) ) { $tijaji_classes[] = 'has_thumb'; }
		return $tijaji_classes;
}
add_filter('post_class', 'tijaji_has_thumb_class');

function tijaji_remove_hentry( $class ) {
    $class = array_diff($class, array('hentry'));
    return $class;
}
add_filter('post_class', 'tijaji_remove_hentry');


function tijaji_custom_comments_list($tijaji_comment, $tijaji_args, $tijaji_depth){
?>

<li <?php comment_class('comment-body'); ?> id="li-comment-<?php comment_ID() ?>">

	<div class="tijaji_comment" id="comment-<?php comment_ID() ?>">

		<div class="comment-auther"><?php if(function_exists('get_avatar')) echo get_avatar($tijaji_comment, '36'); comment_author_link(); ?><?php edit_comment_link( __('Edit Comment', 'tijaji'), '<span class="editlink_comment">', '</span>' ); ?></div>
		<div class="comment-date"><?php comment_date(); ?> <?php comment_time(); ?></div>
		<?php if ($tijaji_comment->comment_approved == '0') echo '<p class="waiting-for-approval">' . esc_html_e('Your comment is awaiting approval.','tijaji') . '</p>';?>
		<div class="comment-text"><?php comment_text(); ?></div>
		<div class="reply"><?php comment_reply_link(array_merge( $tijaji_args, array('depth' => $tijaji_depth, 'reply_text' => __( 'Reply', 'tijaji' ), 'before' => '', 'after' => '') ) ); ?></div>

	</div>

<?php }

function tijaji_custom_pings_list($tijaji_comment, $tijaji_args, $tijaji_depth) {
?>

<li <?php comment_class('comment-body'); ?> id="li-comment-<?php comment_ID() ?>">

	<div class="tijaji_comment" id="comment-<?php comment_ID(); ?>">
	<div class="comment-auther"><?php esc_html_e( 'Pingback: ', 'tijaji' ); comment_author_link(); ?><?php edit_comment_link( __('Edit Pingback', 'tijaji'), '<span class="editlink_comment">', '</span>' ); ?></div>
		<?php 
		if( strstr( get_comment_text(),'<strong>') ) {

			$tijaji_track_con = str_replace( array("\r\n","\n","\r"), '', get_comment_text() );
			preg_match('|<strong>(.*?)</strong>|s', $tijaji_track_con , $tijaji_gettrck_t );

			?><div class="trackback-text"><?php echo esc_html( $tijaji_gettrck_t[1] ); ?></div>

		<?php }else{
		comment_excerpt();
		}
	echo '</div>';
}

add_filter( 'wp_list_categories', 'tijaji_list_categories', 10, 2 );
function tijaji_list_categories( $tijaji_linkindata ) {
	$tijaji_linkindata = preg_replace('/<\/a>\s*\((\d+)\)/',' ($1)</a>',$tijaji_linkindata);
	return $tijaji_linkindata;
}
add_filter( 'get_archives_link', 'tijaji_archives_link' );
function tijaji_archives_link( $tijaji_linkindata ) {
	$tijaji_linkindata = preg_replace('/<\/a>\s*(&nbsp;)\((\d+)\)/',' ($2)</a>',$tijaji_linkindata);
	return $tijaji_linkindata;
}

function tijaji_editor_style(){
	add_editor_style();
}
add_action('after_setup_theme', 'tijaji_editor_style');


if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'tijaji_Custom_Content' ) ) : 

class tijaji_Custom_Content extends WP_Customize_Control {

	public $content = ''; 
 	public function render_content() { 

	$allowed_html = array(
		'a' => array( 'href' => array (), 'onclick' => array (), 'target' => array(), 'class' => array () ),
		'div' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'p' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'span' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'br' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'h2' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
		'h3' => array( 'style' => array (), 'class' => array (), 'align' => array () ),
	);

 		if ( isset( $this->content ) ) { 
 			echo wp_kses( $this->content , $allowed_html ); 
 		} 
	} 
} 
endif; 

function tijaji_thumbnail( $content ){
	if( is_singular() ) {
	$pattern = '/<img ([^>]+?)\/?>/i';
	$replacement = '<img $1 itemprop="image" />';
	$content = preg_replace($pattern, $replacement, $content);
	}
	return $content;
}
add_filter( 'post_thumbnail_html', 'tijaji_thumbnail');

function tijaji_archive_title( $title ){
	if ( is_category() ) {
		/* translators: %s: category term */
		$title = sprintf( esc_html__( 'Category Archives: %s','tijaji' ), single_cat_title( '', false ) ); 
	} elseif ( is_tag() ) {
		/* translators: %s: tag term */ 
		$title = sprintf( esc_html__( 'Tag Archives: %s','tijaji' ) , '<span>' . single_tag_title( '', false ) . '</span>' );
	} elseif ( is_author() ) {
		$title = '<span class="vcard">' . get_the_author() . '</span>' ;
	}
return $title;
}
add_filter( 'get_the_archive_title', 'tijaji_archive_title' );

add_action( 'after_setup_theme', 'tijaji_woocommerce_support' );
function tijaji_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}

function tijaji_scripts() {
	wp_enqueue_script( 'jquery' );
	wp_enqueue_style( 'tijaji_style', get_template_directory_uri() . '/style.css' );
	if( tijaji_footerwidget() == '2') wp_enqueue_style( 'tijaji_style_fw', get_template_directory_uri() . '/css/fw2.min.css' );
	if( tijaji_footerwidget() == '3') wp_enqueue_style( 'tijaji_style_fw', get_template_directory_uri() . '/css/fw3.min.css' );
	if( tijaji_footerwidget() == '4') wp_enqueue_style( 'tijaji_style_fw', get_template_directory_uri() . '/css/fw4.min.css' );
	if( tijaji_footerwidget() == '5') wp_enqueue_style( 'tijaji_style_fw', get_template_directory_uri() . '/css/fw5.min.css' );
	wp_enqueue_script( 'tijaji_script_up', get_template_directory_uri() . '/js/up.js' );
	if ( is_singular() ) wp_enqueue_script('comment-reply');
	if ( tijaji_fontfamily() == 1 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_1', 'https://fonts.googleapis.com/earlyaccess/notosansjp.css' );
	if ( tijaji_fontfamily() == 2 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_2', 'https://fonts.googleapis.com/earlyaccess/notosansjapanese.css' );
	if ( tijaji_fontfamily() == 3 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_3', 'https://fonts.googleapis.com/earlyaccess/mplus1p.css' );
	if ( tijaji_fontfamily() == 4 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_4', 'https://fonts.googleapis.com/earlyaccess/roundedmplus1c.css' );
	if ( tijaji_fontfamily() == 5 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_5', 'https://fonts.googleapis.com/earlyaccess/hannari.css' );
	if ( tijaji_fontfamily() == 6 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_6', 'https://fonts.googleapis.com/earlyaccess/kokoro.css' );
	if ( tijaji_fontfamily() == 7 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_7', 'https://fonts.googleapis.com/earlyaccess/nikukyu.css' );
	if ( tijaji_fontfamily() == 8 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_8', 'https://fonts.googleapis.com/earlyaccess/nicomoji.css' );
	if ( tijaji_fontfamily() == 9 || isset( $_GET['customize_changeset_uuid'] )) wp_enqueue_style( 'tijaji_googlefont_9', 'https://fonts.googleapis.com/earlyaccess/sawarabigothic.css' );
	if ( tijaji_fontfamily() == 10 || isset( $_GET['customize_changeset_uuid'] ) ) wp_enqueue_style( 'tijaji_googlefont_10', 'https://fonts.googleapis.com/earlyaccess/sawarabimincho.css' );
	wp_enqueue_style('dashicons');
}
add_action( 'wp_enqueue_scripts', 'tijaji_scripts' );


function tijaji_inline_css(){

	require get_template_directory() . '/css/firstveiw.min.css';
	if( tijaji_slider_number() == '2') require get_template_directory() . '/css/slider2.min.css';
	if( tijaji_slider_number() == '3') require get_template_directory() . '/css/slider3.min.css';
	if( tijaji_slider_number() == '4') require get_template_directory() . '/css/slider4.min.css';
	if( tijaji_slider_number() == '5') require get_template_directory() . '/css/slider5.min.css';
	if( tijaji_sp_headermenu() == '1') require get_template_directory() . '/css/sp_menu_pc.min.css';
	if( tijaji_sp_headermenu() == '2') require get_template_directory() . '/css/sp_menu_block.min.css';
	if( tijaji_sp_headermenu() == '3') require get_template_directory() . '/css/sp_menu_fixed.min.css';
	
}
add_action( 'wp_head', 'tijaji_inline_css' ,35 );

function tijaji_inline_css_header(){
echo '<style>';
}
add_action( 'wp_head', 'tijaji_inline_css_header' ,34 );

function tijaji_inline_css_footer(){
echo '</style>' . "\n";
}
add_action( 'wp_head', 'tijaji_inline_css_footer' ,40 );

function tijaji_admin_customizer_scripts() {
	wp_enqueue_style( 'tijaji_admin_customizer_style', get_template_directory_uri() . '/css/tijaji_admin_customizer.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'tijaji_admin_customizer_scripts' );

function tijaji_admin_style(){
    wp_enqueue_style( 'tijaji_admin_style', get_template_directory_uri() . '/css/tijaji_admin.css' );
}
add_action( 'admin_enqueue_scripts', 'tijaji_admin_style' );