<?php get_header();

$f_name = get_the_author_meta( 'first_name' , $author );
$l_name = get_the_author_meta( 'last_name' , $author );
$user_url = get_the_author_meta( 'user_url' , $author );
$a_desc = get_the_author_meta( 'description' , $author );

?>
<div class="author-page">
	
	<div class="listpageh1"><h1><?php esc_html_e('About:','tijaji'); ?> <?php echo esc_html( get_the_author_meta( 'display_name' , $author ) ); ?></h1></div>

	<div class="author_page contents">

		<div class="author_img">
			<p class="avatar"><?php if(function_exists('get_avatar')) echo get_avatar( esc_html( get_the_author_meta( 'user_email' , $author ) ), $size = '180' ); ?></p>
		</div>


		<div class="author_desc">

		<?php

			echo '<div class="author_nickname">';
			esc_html_e('Nickname: ','tijaji');
			echo '<span>';
			echo esc_html( get_the_author_meta( 'nickname' ) );
			echo '</span></div>';

		if ( $f_name || $l_name ) {

			echo '<div class="author_name">';
			esc_html_e('Name: ','tijaji');
			echo '<span>';
			if( $f_name ) echo esc_html( $f_name ) .' ';
			if( $l_name ) echo esc_html( $l_name );
			echo '</span></div>';
		}

		if ( $user_url ) {

			/* translators: %s: user site url */
			echo '<div class="user_url"><a href="' . esc_url( $user_url ) . '" title="' . sprintf( esc_attr__( 'Homepage of %s', 'tijaji'), esc_attr( get_the_author_meta( 'display_name' , $author ) ) ) . '">' . esc_url( $user_url ) . '</a></div>';
	
		}

			$twitter = get_the_author_meta( 'twitter' );
			$facebook = get_the_author_meta( 'facebook' );
			$googleplus = get_the_author_meta( 'googleplus' );
			$instagram = get_the_author_meta( 'instagram' );

			if( $twitter ) echo '<div class="sns_btn"><a href="' . esc_url( $twitter ) . '" title="Twitter"><span class="dashicons dashicons-twitter"></span></a></div>';
			if( $facebook ) echo '<div class="sns_btn"><a href="' . esc_url( $facebook ) . '" title="Facebook"><span class="dashicons dashicons-facebook-alt"></span></a></div>';
			if( $googleplus ) echo '<div class="sns_btn"><a href="' . esc_url( $googleplus ) . '" title="Google+"><span class="dashicons dashicons-googleplus"></span></a></div>';
			if( $instagram ) echo '<div class="sns_btn"><a href="' . esc_url( $instagram ) . '" title="Instagram"><span class="dashicons dashicons-camera"></span></a></div>';

		 if ( $a_desc ) {
			echo '<div class="author_text">';
			echo wp_kses_post( $a_desc );
			echo '</div>';
		}

?>
		</div>
	</div>

		<h3><?php /* translators: %s: author */ printf( esc_html__('Recent Posts by %s','tijaji') , esc_html( get_the_author_meta( 'display_name' , $author ) )); ?></h3>



		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<?php static $count = 0;
			if ($count == "5") 
            	{ break; }
			else { ?>


			<div class="loopbox">
			<a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">

				<?php if ( tijaji_display_list_category() && !is_category() ) {
					$tijaji_cat = get_the_category(); 
					for ($i = 0; $i <= count($tijaji_cat); ++$i) {
						if( isset($tijaji_cat[$i]) ) { echo '<div class="loopcat">' . esc_html( $tijaji_cat[$i]->cat_name ) . '</div>'; }
					}
				}?>

				<div class="loopdate"><span><?php the_time( get_option( 'date_format' ) );?></span></div>

				<div class="listpage_item_title"><h2><?php the_title(); ?></h2></div><?php 

				if ( has_post_thumbnail() ) {
					echo '<div class="loopimg">';
					the_post_thumbnail();
					echo '</div><div class="loopcon">';
				}elseif ( tijaji_display_list_img() ) {
					echo '<div class="loopimg">';
					echo '<img src="' . esc_url( get_template_directory_uri() . '/images/noimg.jpg' ) . '" alt="noimg" />';
					echo '</div><div class="loopcon">';
				}

				?><div class="looptext"><div class="looptxt_height"><?php

						wp_strip_all_tags( the_excerpt() );

				?></div>

			<div class="arrow"><?php esc_html_e( 'Read more','tijaji' ); ?></div></div>

			<?php if ( has_post_thumbnail() || tijaji_display_list_img() ) echo '</div>'; ?>

			<div class="clear"></div></a>
			</div>

			<?php $count++; } ?>

		<?php endwhile; else: ?>

			<p><?php /* translators: %s: author */ printf( esc_html__('No posts by %s yet.','tijaji') , esc_html( get_the_author_meta( 'display_name', $author ) )); ?></p>

		<?php endif; ?>

		<h3><?php /* translators: %s: author */ printf( esc_html__('Recent Comments by %s ','tijaji') , esc_html( get_the_author_meta( 'display_name', $author ) )); ?></h3>
	
		<?php
			$blogusers = get_users();
			$comments = get_comments( array( 'ID' => $blogusers[0]->ID, 'number' => 5 ) );

		?>
			<?php if ( $comments ) : foreach ( $comments as $comment) : $post = get_post($comment->comment_post_ID); ?>

			<div class="loopbox">
			<a href="<?php comment_link(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">

				<?php if ( tijaji_display_list_category() && !is_category() ) {
					$tijaji_cat = get_the_category(); 
					for ($i = 0; $i <= count($tijaji_cat); ++$i) {
						if( isset($tijaji_cat[$i]) ) { echo '<div class="loopcat">' . esc_html( $tijaji_cat[$i]->cat_name ) . '</div>'; }
					}
				}?>

				<div class="loopdate"><span><?php comment_date();?></span></div>

				<div class="listpage_item_title"><h2><?php the_title(); ?></h2></div>
				<div class="looptext"><?php
					 comment_text();
				?></div>

			<div class="arrow"></div>
			</a>
			</div>

			<?php endforeach; wp_reset_postdata(); else: ?>

             			<p><?php esc_html_e('No comments by ','tijaji'); ?></p>

			<?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>