<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head profile="http://gmpg.org/xfn/11">
<title>
<?php bloginfo('name'); ?>
<?php wp_title(); ?>
</title>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<!-- leave this for stats please -->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_get_archives('type=monthly&format=link'); ?>
<?php //comments_popup_script(); // off by default ?>
<?php wp_head(); ?>
</head>
<body>
<div class="container">
  <div id="header">
    <div id="title">
      <h1><a href="<?php bloginfo('url');?>">
        <?php bloginfo('name');?>
        </a></h1>
      <h2>
        <?php bloginfo('description');?>
      </h2>
    </div>
    <!-- end #title -->
    <div id="mesh"></div>
    <!-- end #mesh -->
  </div>
  <!-- end #header -->
  <div class="break"> </div>
  <!-- end .break -->
  <div id="content">
    <div id="contentleft">
      <?php if(have_posts()): ?>
      <?php while(have_posts()): the_post(); ?>
      <div class="post" id="post-<?php the_ID(); ?>">
        <h1><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
          <?php the_title(); ?>
          </a></h1>
        <div class="entry">
          <?php the_content(); ?>
          <p class="postmetadata">
            <?php _e('Filed under&#58;'); ?>
            <?php the_category(', ') ?>
            <?php _e('by'); ?>
            <?php  the_author(); ?>
            <br />
            <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
            <?php edit_post_link('Edit', ' &#124; ', ''); ?>
          </p>
        </div>
        <!-- end .entry -->
      </div>
      <!-- end .post -->
      <?php endwhile; ?>
      <div class="navigation">
      <?php posts_nav_link(); ?>
      </div>
      <!-- end .navigation -->
	  <?php else: ?>
      <div class="post">
        <h1>
          <?php _e('Not Found'); ?>
        </h1>
      </div>
      <!-- end .post -->
      <?php endif; ?>
    </div>
    <!-- end #contentleft -->
    <div id="contentright">
    <?php if ( function_exists('dynamic_sidebar') && dynamic_sidebar()):else: ?>
    <h1 class="sidebartitlepos"><?php _e('Search'); ?></h1>
    <?php include(TEMPLATEPATH.'/searchform.php'); ?>
    <h1 class="sidebartitlepos"><?php _e('Calendar'); ?></h1>
    <?php get_calendar(); ?>
    <h1 class="sidebartitlepos"><?php _e('Pages'); ?></h1>
    <ul><?php wp_list_pages('title_li=0'); ?></ul>
    <h1 class="sidebartitlepos"><?php _e('Categories'); ?></h1>
    <ul><?php wp_list_cats('sort_column=name&optioncount=1&hierarchical=0' ); ?></ul>
     <h1 class="sidebartitlepos"><?php _e('Archives'); ?></h1>
     <ul><?php wp_get_archives('type=monthly'); ?></ul>
     <h1 class="sidebartitlepos"><?php _e('Blogroll'); ?></h1>
     <ul><?php get_links_list(); ?></ul>
     <h1 class="sidebartitlepos"><?php _e('Meta'); ?></h1>
     <ul><?php wp_register(); ?>
     <li><?php wp_loginout(); ?></li>
     <?php wp_meta(); ?>
     <?php endif; ?>
     </ul>
     </div>
    <!-- end #contentright -->
  </div>
  <!-- end #content -->
  <div class="clearfooter"> </div>
  <!-- end .clearfooter -->
</div>
<!-- end .container -->
<div class="footer">
<!-- DO NOT REMOVE FOOTER LINKS-->
<p>Site Designed By <a href="http://tvwallmountsguide.com">TV Wall Mounts</a> All Rights Reserved</p>
</div>
<!-- end .footer -->
</body>
</html>
