<?php
/***************************************************************************
 *
 *    ----------------------------------------------------------------------
 *                        DO NOT EDIT THIS FILE
 *    ----------------------------------------------------------------------
 *
 *                     Copyright (C) Themify
 *
 *    ----------------------------------------------------------------------
 *
 ***************************************************************************/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define constants for version, Theme and Themify Framework Path and URI
define( 'THEMIFY_BASE_VERSION', '1.1.6' );
define( 'THEME_DIR', get_template_directory() );
define( 'THEME_URI', get_template_directory_uri() );
define( 'THEMIFY_BASE_DIR', THEME_DIR . '/themify' );
define( 'THEMIFY_BASE_URI', THEME_URI . '/themify' );
define( 'THEMIFY_NO_FRAMEWORK', true );

//////////////////////////////////////////////////////////////////////////
// Load files
//////////////////////////////////////////////////////////////////////////
$theme_includes = apply_filters( 'themify_theme_includes', array(
	'themify/class-themify-mobile-detect.php',
	'themify/themify-modules.php',
	'themify/themify-functions.php',
	'themify/customizer/class-themify-customizer.php',
	'custom-functions.php',
));
foreach ( $theme_includes as $include ) {
	locate_template( $include, true );
}

// Themify Customizer is initialized in its own file

// Set content width for media
if ( ! isset( $content_width ) ) {
	if ( 'sidebar-none' == themify_base_get_sidebar_layout() ) {
		$content_width = 1160;
	} else {
		$content_width = 858;
	}
}

// Setup theme
add_action( 'after_setup_theme', 'themify_base_theme_setup' );

/**
 * Setup everything needed in the theme.
 */
function themify_base_theme_setup() {

	// Get theme settings
	$GLOBALS['themify_settings'] = get_option( 'themify_settings' );

	///////////////////////////////////////
	// Declare theme support
	///////////////////////////////////////

	// Add support for feeds on the site
	add_theme_support( 'automatic-feed-links' );

	// Add Featured Image support
	add_theme_support( 'post-thumbnails' );

	// Add Title Tag support
	add_theme_support( 'title-tag' );

	//////////////////////////////////////////////////////////////////////////
	// Declare action and filter hooks
	//////////////////////////////////////////////////////////////////////////

	// Register Custom Menu Function
	add_action( 'init', 'themify_base_register_custom_nav' );

	// Register sidebars
	add_action( 'widgets_init', 'themify_base_theme_register_sidebars' );

	// Add menu item
	add_action('wp_before_admin_bar_render', 'themify_base_admin_bar');

	// Add theme-specific settings
	add_filter( 'themify_base_settings_config', 'themify_base_theme_settings_config' );

	if ( is_admin() ) {

		if ( current_user_can( 'manage_options' ) ) {
			// Themify - Admin Menu
			add_action( 'admin_menu', 'themify_base_admin_nav' );

			// Initialize Settings Fields
			add_action( 'admin_init', 'themify_base_settings_admin_init' );

			// Add Javascript and CSS files
			add_action( 'admin_enqueue_scripts', 'themify_base_admin_enqueue_assets' );
		}

		add_editor_style( 'style-editor.css' );

	} else {

		// Load Themify Hooks
		require_once THEMIFY_BASE_DIR . '/themify-hooks.php';

		// Register and enqueue in different moments they can be unregister/dequeue them
		add_action( 'wp_enqueue_scripts', 'themify_base_theme_enqueue_scripts', 10 );

		// Viewport tag for mobile devices
		add_action( 'wp_head', 'themify_base_viewport_tag' );

		// IE compatibility
		add_action( 'wp_head', 'themify_base_ie_enhancements' );
		add_action( 'wp_head', 'themify_base_ie_standards_compliant' );

		// CSS classes on body tag
		add_filter( 'body_class', 'themify_base_body_classes' );

	}

	// Load theme languages
	load_theme_textdomain( 'themify', THEME_DIR.'/languages' );

	// Initialize mobile detection
	global $themify_mobile_detect;
	$themify_mobile_detect = new Themify_Base_Mobile_Detect;
}

/**
 * Add theme specific settings.
 * @param array $settings
 * @return mixed
 */
function themify_base_theme_settings_config( $settings ) {
	$theme_settings = array(
		// Skin definitions
		'skin' => array(
			'name' => __( 'Skins', 'themify' ),
			'type' => 'layout',
			'args' => array(
				'std'     => 'default',
				'options' => themify_base_get_skins( array(
					'black'           => __( 'Black', 'themify' ),
					'full-wrap'       => __( 'Full Wrap', 'themify' ),
					'full-wrap-black' => __( 'Full Wrap Black', 'themify' ),
					'page'            => __( 'Page', 'themify' ),
					'page-black'      => __( 'Page Black', 'themify' ),
				)),
				'desc'    => __( 'Select the skin for the site.', 'themify' ),
				'class'   => 'skin-preview'
			),
		),
	);
	return array_merge( $settings, $theme_settings );
}

/**
 * Get the skin list.
 * @param array $skins
 * @return array
 */
function themify_base_get_skins( $skins = array() ){
	$skins_data = array(
		array(
			'value' => 'default',
			'img'   => 'screenshot.png',
			'selected' => true,
			'title' => __( 'Default', 'themify' ),
		)
	);
	foreach ( $skins as $skin => $name ) {
		$skins_data[] = array(
			'value' => $skin,
			'img'   => 'skins/' . $skin . '/screenshot.png',
			'title' => $name,
		);
	}
	return $skins_data;
}

/**
 * Enqueue Stylesheets and Scripts
 */
function themify_base_theme_enqueue_scripts() {
	// Google Web Fonts embedding
	wp_enqueue_style( 'themify-google-fonts', themify_base_https_esc('http://fonts.googleapis.com/css'). '?family=Montserrat:400,700|Open+Sans:400,300&subset=latin,latin-ext');

	// Themify base styling
	wp_enqueue_style( 'themify-style', get_stylesheet_uri(), array(), wp_get_theme()->display( 'Version' ) );

	// Themify Media Queries CSS
	wp_enqueue_style( 'themify-media-queries', THEME_URI . '/media-queries.css' );

	// Skin stylesheet
	$skin = themify_base_get( 'skin' );
	if ( $skin && 'default' != $skin ) {
		wp_enqueue_style( 'themify-skin', THEME_URI . '/skins/' . $skin . '/style.css', array( 'themify-style' ) );
	}
	
	// Fontello Icon Fonts
	wp_enqueue_style( 'themify-fontello', THEME_URI . '/fontello/css/fontello.css' );

	///////////////////
	// Enqueue scripts
	///////////////////

	// Themify internal scripts
	wp_enqueue_script( 'theme-script', THEME_URI . '/js/themify.script.js', array( 'jquery' ), false, true );

	// Inject variable values in gallery script
	wp_localize_script( 'theme-script', 'themifyScript', apply_filters('themify_script_vars', array(
		  'lightbox' => themify_base_lightbox_vars_init(),
		  'lightboxContext' => apply_filters('themify_lightbox_context', '#pagewrap'),
		  'isTouch' => themify_is_touch() ? 'true' : 'false',
		  'html5placeholder' => 'yes'
		)
	));

	// WordPress internal script to move the comment box to the right place when replying to a user
	if ( is_single() || is_page() ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

//////////////////////////////////////////////////////////////////////////
// Theme templating functions
//////////////////////////////////////////////////////////////////////////

/**
 * Register menu areas.
 */
function themify_base_register_custom_nav() {
	register_nav_menus( array(
		'main-nav'   => __( 'Main Navigation', 'themify' ),
		'footer-nav' => __( 'Footer Navigation', 'themify' ),
	));
}

/**
 * Default navigation callback.
 */
function themify_base_default_main_nav() {
	echo '<ul id="main-nav" class="main-nav clearfix">';
	wp_list_pages( 'title_li=' );
	echo '</ul>';
}

/**
 * Register sidebars.
 */
function themify_base_theme_register_sidebars() {
	register_sidebar( array(
		   'name'          => __( 'Sidebar', 'themify' ),
		   'id'            => 'sidebar-main',
		   'before_widget' => '<div id="%1$s" class="widget %2$s">',
		   'after_widget'  => '</div>',
		   'before_title'  => '<h4 class="widgettitle">',
		   'after_title'   => '</h4>',
	  ));

	// Register footer widgets
	themify_base_register_grouped_widgets();
}

if ( ! function_exists( 'themify_base_theme_comment' ) ) {
	/**
	 * Custom Theme Comment
	 * @param object $comment Current comment.
	 * @param array $args Parameters for comment reply link.
	 * @param int $depth Maximum comment nesting depth.
	 * @since 1.0.0
	 */
	function themify_base_theme_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		?>

	<li id="comment-<?php comment_ID() ?>" <?php comment_class(); ?>>
		<p class="comment-author"> <?php echo get_avatar( $comment, $size = '64' ); ?> <?php printf( '<cite>%s</cite>', get_comment_author_link() ) ?>
			<br/>
			<small class="comment-time"><strong><?php comment_date( apply_filters( 'themify_base_comment_date', '' ) ); ?></strong> @ <?php comment_time( apply_filters( 'themify_base_comment_time', '' ) ); ?>
				<?php edit_comment_link( __( 'Edit', 'themify' ), ' [', ']' ) ?>
			</small>
		</p>
		<div class="commententry">
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<p><em>
						<?php _e( 'Your comment is awaiting moderation.', 'themify' ) ?>
					</em></p>
			<?php endif; ?>
			<?php comment_text() ?>
		</div>
		<p class="reply">
			<?php comment_reply_link( array_merge( $args, array(
				'add_below'  => 'comment',
				'depth'      => $depth,
				'reply_text' => __( 'Reply', 'themify' ),
				'max_depth'  => $args['max_depth']
			) ) ) ?>
		</p>
	<?php
	}
}

if ( ! function_exists( '_wp_render_title_tag' ) ) {
	/**
	 * Fallback to render title before WP 4.1
	 *
	 * @since 1.0.9
	 */
	function themify_base_render_title() { ?>
		<title><?php wp_title( '|', true, 'right' ); ?></title>
	<?php
	}
	// Fallback WP Title
	add_action( 'wp_head', 'themify_base_render_title' );
	// Generate title
	add_filter( 'wp_title', 'themify_base_wp_title', 10, 2 );
}

/**
 * Compatibility with Announcement Bar plugin
 * Call themify_body_start hook on themify_base_body_start
 *
 * @since 1.1.7
 */
function themify_base_do_body_start() {
	do_action( 'themify_body_start' );
}
add_action( 'themify_base_body_start', 'themify_base_do_body_start' );