<?php

function the_cozy_blog_pattern_styles()
{
	wp_enqueue_style('the-cozy-blog-patterns', get_stylesheet_directory_uri() . '/assets/css/patterns.css', array(), filemtime(get_template_directory() . '/assets/css/patterns.css'));
	if (is_admin()) {
		global $pagenow;
		if ('site-editor.php' === $pagenow) {
			// Do not enqueue editor style in site editor
			return;
		}
		wp_enqueue_style('the-cozy-blog-editor', get_stylesheet_directory_uri() . '/assets/css/editor.css', array(), filemtime(get_template_directory() . '/assets/css/editor.css'));
	}
}
add_action('enqueue_block_assets', 'the_cozy_blog_pattern_styles');


add_theme_support('wp-block-styles');


// Register customer The Cozy Blog pattern categories
function the_cozy_blog_register_block_pattern_categories()
{
	register_block_pattern_category(
		'heros',
		array(
			'label'       => __('Heros', 'the-cozy-blog'),
			'description' => __('The Cozy Blog hero patterns', 'the-cozy-blog'),
		)
	);
	register_block_pattern_category(
		'navigation_headers',
		array(
			'label'       => __('Headers', 'the-cozy-blog'),
			'description' => __('The Cozy Blog navigation header patterns', 'the-cozy-blog'),
		)
	);
	register_block_pattern_category(
		'teams',
		array(
			'label'       => __('Teams', 'the-cozy-blog'),
			'description' => __('The Cozy Blog team patterns', 'the-cozy-blog'),
		)
	);
}

add_action('init', 'the_cozy_blog_register_block_pattern_categories');
