<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package the-corporate-business
 */

?>
<div class="maincontent">
    <header class="pb-3">
        <?php
            if (has_post_thumbnail()) {
            // Wrap the thumbnail in an anchor tag linking to the post
            echo '<a href="' . get_permalink() . '">';
            the_post_thumbnail('large', array('class' => 'img-fluid'));
            echo '</a>';
            }
        ?>
        <div class="post-details">
            <?php $the_corporate_business_date = get_theme_mod('the_corporate_business_post_hide_date',false);
			if($the_corporate_business_date === false){ ?>
            <span class="entry-date"><a
                    href="<?php echo esc_url( get_day_link( $the_corporate_business_archive_year, $the_corporate_business_archive_month, $the_corporate_business_archive_day)); ?>"><?php echo esc_html( get_the_date('j - M - Y') ); ?><span
                        class="screen-reader-text"><?php echo esc_html( strtoupper( get_the_date( 'j - M - Y' ) ) ); ?></span></a></span>
            <?php } ?>
            <div class="d-flex justify-content-between">
                <div class="dateauthor ml-5">
                    <?php $the_corporate_business_author = get_theme_mod('the_corporate_business_post_hide_author',false);
					if($the_corporate_business_author === false){ ?>
                    <span class="entry-author">
                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span
                                class="screen-reader-text"><?php the_author(); ?></span></a></span>
                    <?php } ?>
                </div>


                <?php $the_corporate_business_comment = get_theme_mod('the_corporate_business_post_comments',false);
				if($the_corporate_business_comment === false){ ?>
                <span class="entry-comments mr-5"><i
                        class="fa-regular fa-comment"></i><?php comments_number( __(' 0 Comment', 'the-corporate-business'), __(' 0 Comments', 'the-corporate-business'), __('% Comments', 'the-corporate-business') ); ?>
                </span>
                <?php } ?>
            </div>



        </div>
        <h2 class="page-title mb-0 mt-3">
            <?php
        // Wrap the post title in an anchor tag linking to the post
        echo '<a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a>';
        ?>
        </h2>
    </header>
    <?php the_content(); ?>
</div>