<?php
/**
 * Header Theme Options
 *
 * @package the-corporate-business
 */
$wp_customize->add_section('the_corporate_business_home_section', array(

	'title' => esc_html__('Home Section', 'the-corporate-business'),
	'capability' => 'edit_theme_options',
	'panel' => 'the_corporate_business_front_section_panel'
));

//home Section
$wp_customize->add_setting('the_corporate_business_home_display', array(
	'default' => true,
	'sanitize_callback' => 'the_corporate_business_sanitize_switch',
));

$wp_customize->add_control(new the_corporate_business_Toggle_Switch_Custom_Control($wp_customize, 'the_corporate_business_home_display_control', array(
	'label' => esc_html__('Display this section', 'the-corporate-business'),
	'section' => 'the_corporate_business_home_section',
	'settings' => 'the_corporate_business_home_display',
)));

// title 
$wp_customize->add_setting('the_corporate_business_homesection_texttitle', array(
	'default' => 'Empowering',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_homesection_texttitle_control', array(
	'label' => esc_html__('Title 1', 'the-corporate-business'),
	'section' => 'the_corporate_business_home_section',
	'settings' => 'the_corporate_business_homesection_texttitle',
	'type' => 'text',
)));

// subtitle 
$wp_customize->add_setting('the_corporate_business_homesection_texttitle1', array(
	'default' => 'WORKSHOP',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_homesection_texttitle1', array(
	'label' => esc_html__('Title 2', 'the-corporate-business'),
	'section' => 'the_corporate_business_home_section',
	'settings' => 'the_corporate_business_homesection_texttitle1',
	'type' => 'text',
)));

// description
$wp_customize->add_setting('the_corporate_business_homesection_textdescription', array(
	'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_homesection_textdescription_control', array(
	'label' => esc_html__('Description', 'the-corporate-business'),
	'section' => 'the_corporate_business_home_section',
	'settings' => 'the_corporate_business_homesection_textdescription',
	'type' => 'textarea',
)));

$wp_customize->add_setting('the_corporate_business_homesection_btn', array(
	'default' => 'Contact Us',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_homesection_btn', array(
	'label' => esc_html__('Button Text', 'the-corporate-business'),
	'section' => 'the_corporate_business_home_section',
	'settings' => 'the_corporate_business_homesection_btn',
	'type' => 'text',
)));