<?php
/**
 * About Theme Options
 *
 * @package the-corporate-business
 */
$wp_customize->add_section('the_corporate_business_about_section', array(

	'title' => esc_html__('About Section', 'the-corporate-business'),
	'capability' => 'edit_theme_options',
	'panel' => 'the_corporate_business_front_section_panel'
));

//home Section
$wp_customize->add_setting('the_corporate_business_about_display', array(
	'default' => true,
	'sanitize_callback' => 'the_corporate_business_sanitize_switch',
));

$wp_customize->add_control(new the_corporate_business_Toggle_Switch_Custom_Control($wp_customize, 'the_corporate_business_about_display_control', array(
	'label' => esc_html__('Display this section', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_display',
)));

//Image 1
$wp_customize->add_setting( 'the_corporate_business_about_left_img1', array(
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_url',
	'capability' => 'edit_theme_options',
	'type' => 'theme_mod',
) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'the_corporate_business_about_left_img1', array(
	'label'      => esc_html__( 'Image 1', 'the-corporate-business' ),
	'section'    => 'the_corporate_business_about_section',
	'settings'   => 'the_corporate_business_about_left_img1',
) ) ); 

//Image 2
$wp_customize->add_setting( 'the_corporate_business_about_left_img2', array(
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_url',
	'capability' => 'edit_theme_options',
	'type' => 'theme_mod',
) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'the_corporate_business_about_left_img2', array(
	'label'      => esc_html__( 'Image 2', 'the-corporate-business' ),
	'section'    => 'the_corporate_business_about_section',
	'settings'   => 'the_corporate_business_about_left_img2',
) ) ); 

// Heading 
$wp_customize->add_setting('the_corporate_business_about_right_heading', array(
	'default' => 'ABOUT US',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_heading_control', array(
	'label' => esc_html__('Heading', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_heading',
	'type' => 'text',
)));

// Title 
$wp_customize->add_setting('the_corporate_business_about_right_title', array(
	'default' => 'LOREM IPSUM IS SIMPLY DUM',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_title_control', array(
	'label' => esc_html__('Title', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_title',
	'type' => 'text',
)));

// Paragraph
$wp_customize->add_setting('the_corporate_business_about_right_paragraph', array(
	'default' => "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took",
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_paragraph_control', array(
	'label' => esc_html__('Paragraph', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_paragraph',
	'type' => 'textarea',
)));

// Listitems 1
$wp_customize->add_setting('the_corporate_business_about_right_listitem1', array(
	'default' => 'Best leadership',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_listitem1_control', array(
	'label' => esc_html__('Listitems 1', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_listitem1',
	'type' => 'text',
)));

// Listitems 2
$wp_customize->add_setting('the_corporate_business_about_right_listitem2', array(
	'default' => 'Full responsibility',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_listitem2_control', array(
	'label' => esc_html__('Listitems 2', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_listitem2',
	'type' => 'text',
)));

// List 1
$wp_customize->add_setting('the_corporate_business_about_right_list1', array(
	'default' => 'Lorem Ipsum is simply dummy text',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_list1_control', array(
	'label' => esc_html__('List 1', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_list1',
	'type' => 'text',
)));

//List 2
$wp_customize->add_setting('the_corporate_business_about_right_list2', array(
	'default' => 'ABOUT',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_list2_control', array(
	'label' => esc_html__('List 2', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_list2',
	'type' => 'text',
)));

// Button
$wp_customize->add_setting('the_corporate_business_about_right_btn', array(
	'default' => 'About us',
	'sanitize_callback' => 'the_corporate_business_sanitise_custom_text',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'the_corporate_business_about_right_btn_control', array(
	'label' => esc_html__('Button', 'the-corporate-business'),
	'section' => 'the_corporate_business_about_section',
	'settings' => 'the_corporate_business_about_right_btn',
	'type' => 'text',
)));