<?php
/**
 * the-corporate-business Theme Customizer
 *
 * @package the-corporate-business
 */
// Custom Controls.
require get_template_directory() . '/inc/custom-controls/custom-controls.php';

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function the_corporate_business_customize_register($wp_customize)
{
	$wp_customize->get_setting('blogname')->transport = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

	if (isset ($wp_customize->selective_refresh)) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector' => '.site-title a',
				'render_callback' => 'the_corporate_business_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector' => '.site-description',
				'render_callback' => 'the_corporate_business_customize_partial_blogdescription',
			)
		);
	}
	require get_template_directory() . '/inc/customizer/theme-options.php';
	require get_template_directory() . '/inc/customizer/front-options.php';
}
add_action('customize_register', 'the_corporate_business_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function the_corporate_business_customize_partial_blogname()
{
	bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function the_corporate_business_customize_partial_blogdescription()
{
	bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function the_corporate_business_customize_preview_js()
{
	wp_enqueue_script('the-corporate-business-customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), THE_CORPORATE_BUSINESS_S_VERSION, true);
}
add_action('customize_preview_init', 'the_corporate_business_customize_preview_js');
function the_corporate_business_custom_control_scripts()
{
	wp_enqueue_style('the-corporate-business-custom-controls-css', get_template_directory_uri() . '/assets/css/custom-controls.css', array(), '1.0', 'all');
	wp_enqueue_script('the-corporate-business-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array('jquery', 'jquery-ui-core', 'jquery-ui-sortable'), '1.0', true);
}
add_action('customize_controls_enqueue_scripts', 'the_corporate_business_custom_control_scripts');


function the_corporate_business_customize_backend_scripts() {

	wp_enqueue_style( 'the-corporate-business-fontawesome-all', get_template_directory_uri() . '/assets/css/all.css' );

	wp_enqueue_style( 'the-corporate-business-main-css', get_template_directory_uri() . '/assets/css/output.css' );

	wp_enqueue_style( 'the-corporate-business-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );

	wp_enqueue_script( 'the-corporate-business-admin-customizer', get_template_directory_uri() . '/inc/customizer/js/customizer-script.js', array( 'jquery', 'customize-controls' ), '20151215', true );
	wp_enqueue_script( 'the-corporate-business-admin-customizer-control', get_template_directory_uri() . '/inc/customizer/js/customize-controls.js', array( 'jquery', 'customize-controls' ), '', true );
}
add_action( 'customize_controls_enqueue_scripts', 'the_corporate_business_customize_backend_scripts', 10 );

/**
 * Enqueue the stylesheet.
 */
function the_corporate_business_customizer_stylesheet() {

    wp_register_style( 'the-corporate-business-admin-css', get_template_directory_uri() . '/inc/customizer/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'the-corporate-business-admin-css' );
}
add_action( 'customize_controls_print_styles', 'the_corporate_business_customizer_stylesheet' );




function the_corporate_business_customize_css() {
    $custom_css = "
        .site-header .gridboxtwo .header-header p {
            color: " . esc_html(get_theme_mod('the_corporate_business_call_color')) . ";
        }
		.site-header .gridboxtwo .header-header i {
            color: " . esc_html(get_theme_mod('Phone_icon_color')) . ";
        }
        .site-header .gridboxtwo .header-header .d-flex:last-child i{
            color: " . esc_html(get_theme_mod('social_icon_color')) . ";
        }
		.main-navigation li a{
            color: " . esc_html(get_theme_mod('menu_text_color')) . " !important;
        }	
        .socialicon {
            background-color: " . esc_html(get_theme_mod('Phone_backgroundcolor')) . ";
        }
        #site-navigation .nav-sitemenu {
            background-color: " . esc_html(get_theme_mod('menu_bg_color')) . ";
        }
        .site-navigation .social-links, .socialicon {
            color: " . esc_html(get_theme_mod('Phone_icon_color')) . ";
        }
        .widget-title, .wp-block-heading{
            background-color: " . esc_html(get_theme_mod('Search_background_color')) . ";
        }
        .widget-title, .wp-block-heading{
            color: " . esc_html(get_theme_mod('Heading_text_color')) . " !important;
        }
        .sidebar-div li a, .single_sidebar li a, .search_sidebar li a            
        {
            color: " . esc_html(get_theme_mod('Text_color')) . " !important;
        }
        .sidebar-div ul li::before{
           color: " . esc_html(get_theme_mod('side_icon_color')) . ";
        }
        .slider-inner-mainbox .slider-socialicon .socialicon {
            color: " . esc_html(get_theme_mod('social_icon_color')) . ";
        }
        #featured-slider .entry-container h4 {
            color: " . esc_html(get_theme_mod('slider_title_color')) . ";
        }
        #featured-slider .entry-container .content {
            color: " . esc_html(get_theme_mod('slider_subtitle_color')) . ";
        }
        #featured-slider .content a,
        #featured-slider code,
        .wp-block-buttons .wp-block-button__link,
        .singlepage #submit {
            background: " . esc_html(get_theme_mod('slider_readmore_color')) . ";
            color: " . esc_html(get_theme_mod('slider_readmoretxt_color')) . " !important;
        }
        #featured-slider .slick-dots li {
            background: " . esc_html(get_theme_mod('slider_slickdot_color')) . ";
        }
        #featured-slider .slick-dots li.slick-active {
            background: " . esc_html(get_theme_mod('slider_activeslickdot_color')) . ";
        }
        #featured-slider .sliderbut1 a {
            color: " . esc_html(get_theme_mod('slider_buttontext1_color')) . ";
        }
        #featured-slider .sliderbut1 {
            background: " . esc_html(get_theme_mod('slider_buttonbg1_color')) . ";
        }
        #featured-slider .sliderbut2 a {
            color: " . esc_html(get_theme_mod('slider_buttontext2_color')) . ";
        }
        #featured-slider .sliderbut2 {
            background: " . esc_html(get_theme_mod('slider_buttonbg2_color')) . ";
        }
        .featured-whatweoffer {
            background: " . esc_html(get_theme_mod('whatweoffer_background_color')) . ";
        }
        .featured-whatweoffer .head-title {
            color: " . esc_html(get_theme_mod('whatweoffer_title_color')) . ";
        }
        .featured-whatweoffer .head-subtitle {
            color: " . esc_html(get_theme_mod('whatweoffer_subtitle_color')) . ";
        }
        .featured-whatweoffer .title a {
            color: " . esc_html(get_theme_mod('whatweoffer_cardtitle_color')) . ";
        }
    ";

    // Ensure the main stylesheet is enqueued first
    wp_enqueue_style('the-corporate-business-style', get_stylesheet_uri());

    // Add inline CSS to it
    wp_add_inline_style('the-corporate-business-style', $custom_css);
}
add_action('wp_enqueue_scripts', 'the_corporate_business_customize_css');