<?php
get_header();

if (is_front_page() && is_home()) { ?>
<?php
    /**
     * Template Name: Custom Front Page
     */

    get_header(); ?>
<main id="primary" class="site-main">
    <?php 
        $the_corporate_business_header_image1 = get_theme_mod('the_corporate_business_header_image1');                    
        if(!empty($the_corporate_business_header_image1)) {  ?>
    <div class="banner-head" style="background-image: linear-gradient(rgba(6, 6, 6, .644), rgba(6, 6, 6, .485)), url('<?php echo esc_url($the_corporate_business_header_image1)?>');">
        <div class="center-div">
            <h1><?php esc_html_e('Posts', 'the-corporate-business'); ?></h1>
        </div>
    </div>;
    <?php } else{?>
    <div class="banner-head"
        style="background-image: linear-gradient(rgba(6, 6, 6, .644), rgba(6, 6, 6, .485)), url('.get_template_directory_uri().'/assets/images/image.png)"
        ;>
        <div class="center-div">
            <h1><?php esc_html_e('Posts', 'the-corporate-business'); ?></h1>
        </div>
    </div>;
    <?php }?>
    <div class="blog-div container-fluid p-5" id="primaryid">
        <div class="row">
            <div class="col-lg-9 col-md-8 col-12">
                <?php
                    if (have_posts()) :

                        if (is_home() && !is_front_page()) :
                            ?>
                <header>
                    <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                </header>
                <?php
                        endif;
                        ?>
                 <div class="row mainrow">
                    <?php 
                        while (have_posts()) :
                            the_post();
                            ?>

                    <div class="col-lg-6 col-md-6 col-12 box gap-10">
                        <?php
                            get_template_part( 'template-parts/maincontent1', get_post_type() );
                        ?>
                    </div>

                    <?php
                            		
                          endwhile;
                          the_posts_pagination(array(
                            'mid_size'  => __('2', 'the-corporate-business'), 
                            'prev_text' => __('« Previous', 'the-corporate-business'),
                            'next_text' => __('Next »', 'the-corporate-business'),
                          ));
                    
                    
                          else :

                        get_template_part('template-parts/content', 'none');

                    endif;
                    ?>
                </div>
            </div>
            <div class="col-lg-3 col-md-4">
                <div class="sidebar-div">
                    <?php
                        // Display the custom sidebar
                        if (is_active_sidebar('sidebar-1')) {
                            dynamic_sidebar('sidebar-1');
                        } else {
                            get_sidebar();
                        }
                        ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php get_footer(); ?>

<?php } elseif (is_front_page() && !is_home()) { ?>
<main id="primary" class="site-main">
    <?php
        get_template_part('template-parts/customizesection/front', 'home');

        get_template_part('template-parts/customizesection/front', 'about');

        get_template_part('template-parts/customizesection/front', 'services');
        ?>
</main><!-- #main -->
<?php }

get_footer();
?>