<?php
// Default loop
?>

<?php // If there is a need show navigation at the top. ?>

<?php if ( $wp_query->max_num_pages > 1 ) : ?>

	<div id="nav-above" class="navigation">
		<div class="nav-previous">
			<?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', TCB_TEXT_DOMAIN ) ); ?>
		</div>
		<div class="nav-next">
			<?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', TCB_TEXT_DOMAIN ) ); ?>
		</div>
	</div>

<?php endif; ?>

<?php //The Basic Loop 
	
	while( have_posts() ) : the_post(); ?>

	<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( has_post_format( 'aside' ) ) : ?>
	    
	   	<div class="format-aside-permalink">
			<a href="<?php the_permalink();?>" title="<?php the_title_attribute(); ?>">&para;</a>
	   	</div>
	    <div class="format-aside-content">
			<?php the_content(); ?>
		</div>	
	</div>
		
	<?php elseif ( has_post_format( 'status' ) ) : ?>
		
		<span>&#35;</span>
		<?php the_content(); ?>
	
	</div>
	
	<?php else: ?>
		
			<?php if ( !(commonblog_get_option(TCB_SHORT_NAME . "_post_meta") == "no") ) { ?>
				
				<div class="post_meta_wrap">
		
					<?php if ( !(commonblog_get_option(TCB_SHORT_NAME . "_post_meta_image") == "no") ) { 
	
						if ( has_post_thumbnail() ) {
							the_post_thumbnail();
						} 
					}
					?>
				
					<?php the_title('<h2 class="post_title"><a href="' . get_permalink() . '" title="' . get_the_title() . '" rel="bookmark">', '</a></h2>'); ?>
				
					<p class="posted_on_meta">
						
						<span class="posted_on_comment_count">
							<?php printf( _n( 'One Comment', '%1$s Comments', get_comments_number(), TCB_TEXT_DOMAIN ),
							number_format_i18n( get_comments_number() ) );?>
						</span>
						<?php commonblog_posted_on(); ?>
						
					</p>
					
				</div>
			
			<?php } else { ?>

			<?php the_title('<h2 class="post_title"><a href="' . get_permalink() . '" title="' . get_the_title() . '" rel="bookmark">', '</a></h2>'); ?>
		
			<?php } ?>
		
		<?php if ( is_front_page() || is_home() || is_archive() || is_search() ) : ?>
	
			<?php if ( !(commonblog_get_option(TCB_SHORT_NAME . "_post_default") == "excerpt") ) { ?>

				<?php the_content(); ?>
			
			<?php } else { ?>

				<?php the_excerpt(); ?>
				<p><a href="<?php echo get_permalink(); ?>"><?php _e( 'Read More..', TCB_TEXT_DOMAIN )?></a></p>
				
			<?php } ?>
			
			
		
		<?php else : ?>
			
			<?php the_content('Read more...'); ?>
			
		<?php endif; ?>

	</div>
	
	<?php endif; ?>
		
<?php endwhile; // end of basic loop. ?>

<?php
	// If there is a need show navigation at the bottom
	if ( $wp_query->max_num_pages > 1 ) : ?>
	<div id="nav-below" class="navigation">
		<div class="nav-previous">
			<?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'notesblog' ) ); ?>
		</div>
		<div class="nav-next">
			<?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'notesblog' ) ); ?>
		</div>
	</div>
<?php endif; ?>