<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
<meta content="text/html" charset="<?php bloginfo( 'charset' ); ?>" />
<title>
<?php 
	if ( is_front_page() || is_home() ) {
		bloginfo( 'name' ); echo ' | '; bloginfo( 'description' );
	}
	
	elseif ( is_page() || is_single() ) {
		single_post_title();
	}
	
	else {
		wp_title();
	}
?>
</title>

<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); // Comment JavaScript ?>
<?php wp_head(); // Start WordPres ?>

<!--[if lt IE 9]>
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/ie.css" />
<![endif]-->

</head>

<body <?php body_class(); ?>>

<div id="wrapper">
<!-- Header -->

	<div id="header" class="clearfix">
		
		<?php
		// Check if this is a post or page, if it has a thumbnail, and if it's a big one
		if ( get_header_image() ) : ?>
			
			<div style="width: <?php echo HEADER_IMAGE_WIDTH; ?>px; height: <?php echo HEADER_IMAGE_HEIGHT; ?>px; overflow: hidden;">
				<img src="<?php header_image(); ?>"  alt="" />
			</div>
			
		<?php else : ?>
			<div class="heading">
		
				<h1 id="site-header"><a href="<?php echo home_url( '/' ); ?>" title="<?php echo get_bloginfo( 'name' ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<p id="site-description"><?php bloginfo( 'description' ); ?></p>
			
			</div>
		<?php endif; ?>

		

	</div>
	
	<div id="menu">
		<?php wp_nav_menu( array( 'container_class' => 'menu-header' , 'theme_location' => 'primary' ) ); ?>
		<div class="menu-widgetarea">
			<ul id="menu-widget">
				<?php dynamic_sidebar('beside-menu'); // Adds a widget area next to the menu. (best used for search)?>
			</ul>
		</div>
	</div>
<!-- End Header -->

	
