<?php
/**
 * Functions file
 */


// Options for The Common Blog
define("TCB_THEME_NAME", "The Common Blog");
define("TCB_SHORT_NAME", "commonblog");
define("TCB_TEXT_DOMAIN", "commonblog");
define("TCB_MENU_PAGE", "the-common-blog-menu-page");
define("TCB_CUSTOM_HEADER_DEFAULT_HEIGHT", 198);
define("TCB_CUSTOM_HEADER_DEFAULT_WIDTH", 965);
define("TCB_POST_THUMBNAIL_HEIGHT", 50);
define("TCB_POST_THUMBNAIL_WIDTH", 50);

// Set up global vars
global $common_blog_theme_options, $common_blog_theme_options_db;
$common_blog_theme_options = array();
$common_blog_theme_options_db = array();





/**
 * Theme setup
 */
function common_blog_after_setup_theme() {
	

	// Make theme available for translation
	// Translations can be filed in the /languages/ directory
	load_theme_textdomain( TCB_TEXT_DOMAIN, TEMPLATEPATH . '/languages' );
	
	
	/**
	 * Theme options array
	 */
	global $common_blog_theme_options;
	$common_blog_theme_options = array (
		array (
			"name" => __( "Post Default", TCB_TEXT_DOMAIN ),
			"desc" => __( "Display either the full post content or the excerpt content on the front page.", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_post_default",
			"value" => "radio",
			"options" => array("content" => "post_content()", "excerpt" => "post_excerpt()"),
			"std" => "excerpt" ),
		
		array (
			"name" => __( "Post Meta", TCB_TEXT_DOMAIN ),
			"desc" => __( "Displays the post meta data. Name, Date and Post Count.", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_post_meta",
			"value" => "radio",
			"options" => array("yes" => "Yes", "no" => "No"),
			"std" => "no" ),
		
		array (
			"name" => __( "Post Meta Image", TCB_TEXT_DOMAIN ),
			"desc" => __( 'Displays a post meta image. (to add the image use the "Set featured image" on the post.', TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_post_meta_image",
			"value" => "radio",
			"options" => array("yes" => "Yes", "no" => "No"),
			"std" => "no" ),
		
		array (
			"name" => __( "Header Image Height (pixels)", TCB_TEXT_DOMAIN ),
			"desc" => __( "Change the default hight for the header image <br /><br /> *NOTE - If the value is changed after the image is set the image will be resized and NOT Cropped. ", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_header_image_height",
			"value" => "text",
			"std" => TCB_CUSTOM_HEADER_DEFAULT_HEIGHT ,
			"sanitize_type" => "int" ),
		
		array (
			"name" => __( "Turn on font Options", TCB_TEXT_DOMAIN ),
			"desc" => __( "ONLY Turns the font options BELOW on or off", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_turn_on_off",
			"value" => "radio",
			"options" => array("on" => "On", "off" => "Off"),
			"std" => "off" ),
		
		array (
			"name" => __( "Header Text Alignment", TCB_TEXT_DOMAIN ),
			"desc" => __( "Align the title and Tag line left or right (it is recomended that if you use the custom header function to turn of the text under that option due to formating restrictions, unless you fix that through the css.)", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_alt_title_align",
			"selector" => array("#header .heading", "#header .heading"),
			"property"	=>	array("float", "text-align"),
			"value" => "radio",
			"options" => array ( "left" => "Align Left", "right" => "Align Right"),
			"std" => "right" ),
		
		array (
			"name" => __( "Body Text Size", TCB_TEXT_DOMAIN ),
			"desc" => __( 'Set the font size for the body text (Default = 16px. THIS VALUE WILL AFFECT ALL FONT SIZES.)', TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_alt_body_text_size",
			"selector" => "p",
			"property" => "font-size",
			"value" => "text",
			"std" => "16px" ,
			"sanitize_type" => "fontsize" ),
		
		array (
			"name" => __( "Text Color (hex value)", TCB_TEXT_DOMAIN ),
			"desc" => __( "Select a colour for p, span, div.", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_alt_text_colour",
			"selector" => "p",
			"property"	=>	"color",
			"value" => "text",
			"std" => "#525244" ,
			"sanitize_type" => "hexcolor"),
		
		array (
			"name" => __( "Heading Color (hex value)", TCB_TEXT_DOMAIN ),
			"desc" => __( "Select colour for all H tags.", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_alt_header_colour",
			"selector" => array ( "h1", "h2", "h3", "h4", "h5", "h6" ), 
			"property"	=>	array ( "color", "color", "color", "color", "color", "color" ),
			"value" => "text",
			"std" => "#cccc9c" ,
			"sanitize_type" => "hexcolor" ),
		
		array (
			"name" => __( "Link Color (hex value)", TCB_TEXT_DOMAIN ),
			"desc" => __( "Select colour for link text.", TCB_TEXT_DOMAIN ),
			"id" => TCB_SHORT_NAME."_alt_link_colour",
			"selector" => array ( "a", ".tagcloud a", "#wp-calendar tr td a:hover" ),
			"property"	=> array ( "color", "color", "background-color" ),
			"value" => "text",
			"std" => "#86865f" ,
			"sanitize_type" => "hexcolor" ),
	);
	
	
	// Get theme options from db
	global $common_blog_theme_options_db;
	$common_blog_theme_options_db = get_theme_mod( TCB_SHORT_NAME, false );
	
	// Found nothing in database, set defaults
	if ($common_blog_theme_options_db == false) {
		
		foreach ($common_blog_theme_options AS $value) {
			
			if (array_key_exists("id", $value)) {
				
				$common_blog_theme_options_db[ $value['id'] ] = $value['std'];
			}
			
		}
		
	}
	
	
	// Set wp_nav_menu
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', TCB_TEXT_DOMAIN ),
	) );


	// Set the default content width (.content_area) if one is not set.
	if ( ! isset( $content_width ) ) $content_width = 660;	
	
	
	// This feature enables post and comment RSS feed links to head
	add_theme_support('automatic-feed-links');	
	
	
	// Add Post Format Support
	add_theme_support( 'post-formats', array( 'aside', 'status' ) );	
	
	
	// Add custom background support
	add_custom_background();
	
	
	// Add editor style support
	add_editor_style();
	
	
	// Set post thumbnail
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( TCB_POST_THUMBNAIL_HEIGHT, TCB_POST_THUMBNAIL_WIDTH, true );
	
	
	// Add Custom Header Support
	if ( ! defined( 'HEADER_TEXTCOLOR' ) )
		define( 'HEADER_TEXTCOLOR', '' );
					
	$custom_header_image_height = commonblog_get_option(TCB_SHORT_NAME . "_header_image_height", TCB_CUSTOM_HEADER_DEFAULT_HEIGHT);
	define( 'HEADER_IMAGE_WIDTH', apply_filters( 'commonblog_header_image_width', TCB_CUSTOM_HEADER_DEFAULT_WIDTH ) );
	define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'commonblog_header_image_height', $custom_header_image_height ) );

	if ( ! defined( 'NO_HEADER_TEXT' ) )
		define( 'NO_HEADER_TEXT', true );

	add_custom_image_header( '', 'commonblog_admin_header_callback' );

}

add_action("after_setup_theme", "common_blog_after_setup_theme");


/**
 * Theme init
 */
function common_blog_init() {
	
	// Set up Widget Area's
	
	// Beside Menu
	register_sidebar( array(
	    'name' => __( 'Beside Menu', TCB_TEXT_DOMAIN ),
	    'id' => 'beside-menu',
	    'description' => __( 'Widget area, right of the menu.', TCB_TEXT_DOMAIN ),
	    'before_widget' => '<li id="%1$s" class="%2$s">',
	    'after_widget' => '</li>',
	    'before_title' => '<h4 class="widget_title">',
	    'after_title' => '</h4>',
	) );
	
	// Global Sidebar
	register_sidebar( array(
		'name' => __( 'Default Sidebar', TCB_TEXT_DOMAIN ),
		'id' => 'defualt-sidebar',
		'description' => __( 'Global Widget Area. Any widgets placed here will be on every page.', TCB_TEXT_DOMAIN ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>'
	) );
	
	// Author widget area
	register_sidebar( array(
		'name' => __( 'Author Sidebar', TCB_TEXT_DOMAIN ),
		'id' => 'author-sidebar',
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>'
	) );
	
	// Footer widget area 1 - Empty by default.
	register_sidebar( array(
		'name' => __( 'First Footer Widget Area', TCB_TEXT_DOMAIN ),
		'id' => 'footer-column-1',
		'description' => __( 'The first footer widget area', TCB_TEXT_DOMAIN ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>',
	) );
	
	// Footer widget area 2 - Empty by default.
	register_sidebar( array(
		'name' => __( 'Second Footer Widget Area', TCB_TEXT_DOMAIN ),
		'id' => 'footer-column-2',
		'description' => __( 'The second footer widget area', TCB_TEXT_DOMAIN ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>',
	) );
	
	// Footer widget area 3 - Empty by default.
	register_sidebar( array(
		'name' => __( 'Third Footer Widget Area', TCB_TEXT_DOMAIN ),
		'id' => 'footer-column-3',
		'description' => __( 'The third footer widget area', TCB_TEXT_DOMAIN ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>',
	) );
	
	// Footer widget area 4 - Empty by default.
	register_sidebar( array(
		'name' => __( 'Fourth Footer Widget Area', TCB_TEXT_DOMAIN ),
		'id' => 'footer-column-4',
		'description' => __( 'The fourth footer widget area', TCB_TEXT_DOMAIN ),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widget_title">',
		'after_title' => '</h4>',
	) );
	
}

add_action('init', 'common_blog_init');



/**
 * Admin page theme init
 */
function commonblog_admin_init() {

	// Enque admin css
	$file_dir = get_template_directory_uri();
	wp_enqueue_style("CommonBlogCss", $file_dir."/admin-style.css", false, "1.0", "all");

}

add_action('admin_init', 'commonblog_admin_init');
	


/**
 * Admin header callback for custom image header
 */
function commonblog_admin_header_callback() {
	// Does nothing at the time.
}



/**
 * This theme will revert to wp_page_menu if wp_nav_menu is not used.
 * @param array $args
 * @return array
 */
function commonblog_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'commonblog_page_menu_args' );




/**
 * Removes [...] from the excerpt
 * @param string $more
 * @return string
 */
function commonblog_excerpt_more($more) {
	return '';
};
add_filter('excerpt_more', 'commonblog_excerpt_more');





/**
 * Comment layout ("Borrowed" from TwentyTen) ;)
 */
function commonblog_comment( $comment, $args, $depth ) {

   $GLOBALS['comment'] = $comment;
   switch ( $comment->comment_type ) :
		case '' :
	?>
   
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
   
     <div id="comment-<?php comment_ID(); ?>" class="comment-body">
   
      <div class="comment-author vcard">
   
		<?php echo get_avatar( $comment, 52 ); ?>
   
		<?php printf(__('<h5><cite class="fn">%s</cite> <span class="says">says:</span></h5>'), get_comment_author_link()) ?>
		<p class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf( __( '%1$s at %2$s' ), get_comment_date(),  get_comment_time() ) ?></a><?php edit_comment_link( __( '(Edit)' ),'  ','') ?> / <span><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args[ 'max_depth' ] ) ) ) ?></span></p>   
      </div>
   
      <?php if ($comment->comment_approved == '0') : ?>
   
         <em><?php _e( 'Your comment is awaiting moderation.' ) ?></em>
   
         <br />
   
      <?php endif; ?>

      <?php comment_text() ?>
   
     </div>
<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', TCB_TEXT_DOMAIN ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', TCB_TEXT_DOMAIN ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
}


/**
 * Posted on style
 */
function commonblog_posted_on() {
	_e( 'Posted by ', TCB_TEXT_DOMAIN ) . the_author_posts_link() . _e( ' on ' ) . the_time(' F jS Y @ g:i a');
}


/**
 * Tag and Category MetaData for posts
 */
function commonblog_posted_in() {
	// Retrieves tag list of current post, separated by commas.
	$tag_list = get_the_tag_list( '', ', ' );
	$posted_in = 'Defult';
	if ( $tag_list ) {
		$posted_in = __( 'Post filed under %1$s and tagged %2$s.', TCB_TEXT_DOMAIN );
	
	} elseif ( is_object_in_taxonomy( get_post_type(), 'category' ) ) {
		$posted_in = __( 'Post filed under %1$s.', TCB_TEXT_DOMAIN );
	}
	// Prints the string, replacing the placeholders.
	printf(
		$posted_in,
		get_the_category_list( ', ' ),
		$tag_list,
		get_permalink(),
		the_title_attribute( 'echo=0' )
	);
}


/**
 * Custom pagination for Page.php
 */
function wp_commonblog_pagination($pages = '', $range = 2) {
	  
	$showitems = ($range * 2)+1;  

	global $paged;
	if ( empty( $paged ) ) $paged = 1;

	if ( $pages == '' ) {
		global $wp_query;
		$pages = $wp_query->max_num_pages;
         
		if ( !$pages ) {
			$pages = 1;
		}
	}   

	if ( 1 != $pages ) {
     	
		echo "<div class='pagination'>";
         
		if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
         
		if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

		for ($i=1; $i <= $pages; $i++) {
         	
			if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )) {
				echo ($paged == $i)? "<span class='page_numbers current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='page_numbers' >".$i."</a>";
			}
		}

		if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
         
		if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
         
		echo "</div>\n";
	}
}




/**
 * Common Blog admin options page
 */
function commonblog_admin() {

	//must check that the user has the required capability 
    if ( !current_user_can( 'edit_theme_options' ) ) {
    	
    	wp_die( __('You do not have sufficient permissions to access this page.') );
    
    }
	
	global $common_blog_theme_options;
	$i=0;

	if ( isset ($_REQUEST['saved']) && ($_REQUEST['saved'] ) )echo '<div id="message" class="updated fade"><p><strong>'.TCB_THEME_NAME.' settings saved.</strong></p></div>';
	if ( isset ($_REQUEST['reset']) && ($_REQUEST['reset'] ) ) echo '<div id="message" class="updated fade"><p><strong>'.TCB_THEME_NAME.' settings reset.</strong></p></div>';

?>

<div class="wrap ">
	<div class="options_wrap">
		<h2 class="settings-title"><?php echo TCB_THEME_NAME; ?> Settings</h2>
			<form method="post">
			
				<?php wp_nonce_field(TCB_SHORT_NAME.'_options', TCB_SHORT_NAME.'_options_nounce'); ?>

				<?php foreach ($common_blog_theme_options as $value) { 
					
						switch ( $value['value'] ) {						
						
							case 'text':
						?>

							<div class="options_input options_text">
								<div class="options_desc"><?php echo $value['desc']; ?></div>
								<span class="labels"><label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo $value['name']; ?></label></span>
								<input name="<?php echo $value['id']; ?>" id="<?php echo esc_attr( $value['id'] ); ?>" type="<?php echo esc_attr( $value['value'] ); ?>" value="<?php if ( commonblog_get_option( $value['id'] ) != "") { echo esc_attr( commonblog_get_option( $value['id'] )  ); } else { echo esc_attr( $value['std'] ); } ?>" />
							</div>

						<?php
						break;
						
						case 'textarea':
						?>
	
							<div class="options_input options_textarea">
								<div class="options_desc"><?php echo $value['desc']; ?></div>
								<span class="labels"><label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo $value['name']; ?></label></span>
								<textarea name="<?php echo esc_attr( $value['id'] ); ?>"><?php if ( commonblog_get_option( $value['id'] ) != "") { echo esc_textarea( commonblog_get_option( $value['id'] ) ); } else { echo esc_textarea( $value['std'] ); } ?></textarea>
							</div>

						<?php
						break;
						
						case 'select':
						?>
						
							<div class="options_input options_select">
								<div class="options_desc"><?php echo $value['desc']; ?></div>
								<span class="labels"><label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo $value['name']; ?></label></span>
								<select name="<?php echo esc_attr( $value['id'] ); ?>" id="<?php echo esc_attr( $value['id'] ); ?>">
								<?php foreach ($value['options'] as $option) { ?>
										<option <?php selected( $option, commonblog_get_option( $value['id'] ) ) ?> ><?php echo esc_attr( $option ); ?></option><?php } ?>
								</select>
							</div>

						<?php
						break;
						
						case "radio":
						?>
						
							<div class="options_input options_select">
								<div class="options_desc"><?php echo $value['desc']; ?></div>
								<span class="labels"><label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo $value['name']; ?></label></span>
								  <?php foreach ($value['options'] AS $key => $option) { ?>
									<span><?php echo $option; ?></span><input type="radio" name="<?php echo esc_attr( $value['id'] ); ?>" value="<?php echo esc_attr( $key ); ?>" <?php checked($key, commonblog_get_option( $value['id'] ) ) ?> />
									<?php } ?>
							</div>

						<?php
						break;
						
						case "checkbox":
						?>

							<div class="options_input options_checkbox">
								<div class="options_desc"><?php echo $value['desc']; ?></div>
								<input type="checkbox" name="<?php echo esc_attr( $value['id'] ); ?>" id="<?php echo esc_attr( $value['id'] ); ?>" value="on" <?php checked( "on", commonblog_get_option($value['id']) ) ?> />
								<label for="<?php echo esc_attr( $value['id'] ); ?>"><?php echo $value['name']; ?></label>
							 </div>

						<?php
						break;
				
					}
				 } ?>

				<input type="hidden" name="action" value="save" />
				<span class="submit"><input name="save" type="submit" value="Save All Changes" /></span>
			</form>

			<form method="post">
				<?php wp_nonce_field(TCB_SHORT_NAME.'_options_reset', TCB_SHORT_NAME.'_options_reset_nounce'); ?>
				<span class="submit">
					<input name="reset" type="submit" value="Reset All Options" />
					<input type="hidden" name="action" value="reset" />
				</span>
			</form>
	
		</div><!--#options-wrap-->
	
	</div> <!--#wrap-->
	
	<?php 
}
	


/**
 * Theme admin menu 
 */
function commonblog_admin_menu() {
	
	global $common_blog_theme_options;
	
	$common_blog_theme_options_db = array();
	
	if ( isset ( $_GET['page'] ) && ( $_GET['page'] == TCB_MENU_PAGE ) ) {
		
		if ( isset ( $_REQUEST[ 'action' ] ) && ( 'save' == $_REQUEST[ 'action' ] ) && wp_verify_nonce($_POST[TCB_SHORT_NAME.'_options_nounce'], TCB_SHORT_NAME.'_options')  ) {
			
			foreach ( $common_blog_theme_options as $value ) {
				
				if ( array_key_exists( 'id' , $value ) ) {
					
					if ( isset( $_REQUEST[ $value[ 'id' ] ] ) ) {
						$common_blog_theme_options_db[ $value[ 'id' ] ] = commonblog_sanitize_theme_option( $_REQUEST[ $value[ 'id' ] ], $value[ 'id' ] );
					}
					
				}
				
			}
			
			set_theme_mod( TCB_SHORT_NAME, $common_blog_theme_options_db );
		
			header("Location: admin.php?page=" . TCB_MENU_PAGE . "&saved=true");
			die;
		}
		
		elseif ( isset( $_REQUEST[ 'action' ] ) && ( 'reset' == $_REQUEST[ 'action' ] ) && wp_verify_nonce($_POST[TCB_SHORT_NAME.'_options_reset_nounce'], TCB_SHORT_NAME.'_options_reset') ) {
			
			set_theme_mod( TCB_SHORT_NAME, array() );
			
			header("Location: admin.php?page=" . TCB_MENU_PAGE . "&reset=true");
			die;
		}
		
	}
	
	add_theme_page(TCB_THEME_NAME, TCB_THEME_NAME, 'edit_theme_options', TCB_MENU_PAGE, 'commonblog_admin' );
	
}

add_action('admin_menu' , 'commonblog_admin_menu');



/**
 * Custom css (from option)
 */
function output_altinate_css() {
	global $common_blog_theme_options;
	
	// Settings are off
	if( !(commonblog_get_option(TCB_SHORT_NAME . "_turn_on_off") == "on") ) {
		return true;
	}
	
	?>
	
	<style type="text/css">
	
	<?php
	
	foreach ($common_blog_theme_options AS $option) {
		if (!$option['selector']) {
			continue;
		}
		$db_value = commonblog_get_option($option['id']);
		if (!$db_value) {
			continue;
		}
		
		if (!is_array($option["selector"])) {
			$option["selector"] = array($option["selector"]);
		}
		if (!is_array($option["property"])) {
			$option["property"] = array($option["property"]);
		}
		foreach ($option["selector"] AS $index => $selector) {
			echo $selector ." { " . $option["property"][$index] .": " .  $db_value . "; } " . "\n\n";
		}
	}
	
	?>
			
	</style>
	
	<?php
}
add_action('wp_head', 'output_altinate_css');


/**
 * Get option from global variable
 */
function commonblog_get_option($id) {
	global $common_blog_theme_options_db, $common_blog_theme_options;
	
	return $common_blog_theme_options_db[ $id ];
}


/**
 * Sanitize theme option
 * @param string $value
 * @param string $id
 * @return string
 */
function commonblog_sanitize_theme_option($value, $id) {
	global $common_blog_theme_options;
	
	$common_blog_current_theme_option = null;
	
	foreach ($common_blog_theme_options AS $index => $row) {
		
		if ($id == $row['id']) {
			$common_blog_current_theme_option = $row;
			break;
		}
		
	}
	
	if ($common_blog_current_theme_option) {
		
		// Theme option: Radio / Select
		if ($common_blog_current_theme_option['value'] == "radio" || $common_blog_current_theme_option['value'] == "select") {
			
			if (array_key_exists($value, $common_blog_current_theme_option['options'])) {
				return $value;
			}
			else {
				return $common_blog_current_theme_option['std'];
			}
			
		}
		
		// Theme option: Checkbox
		elseIf ($common_blog_current_theme_option['value'] == "checkbox") {
			
			if ($value == "on" || $value == "off") {
				return $value;
			}
			else {
				return $common_blog_current_theme_option['std'];
			}
		}
		
		// Theme option: Text
		elseIf ($common_blog_current_theme_option['value'] == "text") {
			
			// Sanitize type: integer
			if ($common_blog_current_theme_option['sanitize_type'] == "int") {
				
				$value = (int)$value;
				if ($value) {
					return $value;
				}
				else {
					return $common_blog_current_theme_option['std'];
				}
				
			}
			
			// Sanitize type: Font size
			elseIf ($common_blog_current_theme_option['sanitize_type'] == "fontsize") {
				
				// Remove any white space characters (to help the user)
				$value = preg_replace("/\s/", "", $value);
				// Change "," to "." (to help the user)
				$value = str_replace(",", ".", $value);
				// Match it
				if ( preg_match("/^([0-9\.]{1,7})(px|em|pt)$/i", $value) ) {
					return $value;
				}
				// No match, return default
				else {
					return $common_blog_current_theme_option['std'];
				}
				
			}
			
			// Sanitize type: Hex color
			elseIf ($common_blog_current_theme_option['sanitize_type'] == "hexcolor") {
				
				// Remove any white space characters (to help the user)
				$value = preg_replace("/\s/", "", $value);
				// Match it
				if ( preg_match("/^(#)([0-9a-f]{3,6})$/i", $value) ) {
					return $value;
				}
				// No match, return default
				else {
					return $common_blog_current_theme_option['std'];
				}
				
			}
			
		}
		
	}
	
}




?>