<?php
/**
 * Testimonial Section
 * @package the-angle
 */
?>
<?php
    if(get_theme_mod('the_angle_testimonial_section','no') == 'yes'):
        $testimonial_cat = esc_attr(get_theme_mod('the_angle_testimonial_section_category',''));
        $testimonial_title = get_theme_mod('the_angle_testimonial_us_title',esc_html__('What People Are Saying About US','the-angle'));
        $the_angle_testimonial_section_layout = get_theme_mod('the_angle_testimonial_section_layout','layout-1');
         if($testimonial_cat):
            $i=0;
            $args_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' =>8, 'category_name' => $testimonial_cat));
            if ($args_query->have_posts()) :?>
                 <section id="testimonial-section" class="the-angle-testimonial-section <?php echo esc_attr($the_angle_testimonial_section_layout); ?>" data-stellar-background-ratio="0.5" ">
                    <div class="tc-container">
                            <div class="title-wrp">
                              <h2 class="section-title wow slideInUp"><?php echo esc_html($testimonial_title);?></h2>
                            </div>
                           <div class="testimonial">
                                       <?php
                                       while ($args_query->have_posts()):
                                        $args_query->the_post();
                                        $testimonial_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'the-angle-testimonial-thumb-image');
                                         $i++;
                                                ?>
                                            <div class="testimonial-single <?php if($i%4==0){echo " nomargin";} ?>  wow fadeInUp" data-wow-delay="0.8s">
                                                    <div class="cat-caption">
                                                        <?php if(has_post_thumbnail()): ?>
                                                        <?php endif; ?>
                                                        <div class="testimonial-context">
                                                            <h2 class="testimonial-caption-title">
                                                                <?php the_title(); ?>
                                                            </h2>
                                                            <div class="testimonial-desc">
                                                                <?php echo esc_attr(wp_trim_words(get_the_content(),150,'&hellip;')); ?>
                                                             </div>
                                                        </div>
                                                        <div class="testimonial-image">
                                                           <img src="<?php echo esc_url($testimonial_slider_image[0]); ?>" title="<?php the_title_attribute(); ?>" alt="<?php the_title_attribute(); ?>" />
                                                        </div>
                                                    </div>
                                             </div>

                                          <?php
                                         endwhile;
                                      wp_reset_postdata();
                                     ?>
                               </div>
                         </div>
                 </section>
                 <?php
             endif;
        endif;
    endif
        ?>
