<?php
/**
 * the-angle Theme Customizer Custom
 *
 * @package the-angle
 */

/**
 * Add new options the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function the_angle_custom_customize_register( $wp_customize ) {
    require get_template_directory() . '/inc/the-angle-sanitizer.php';
	// the-angle posts list.
    $the_angle_category_lists 	=	the_angle_category_lists();
    $posts_list = the_angle_post_list();

	//Adding the Default Setup Panel
	$wp_customize->add_panel('the_angle_default_setups',array(
		'priority' => '10',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('Default Setups','the-angle'),
		));

	 //Add Default Sections to General Panel
	$wp_customize->get_section('title_tagline')->panel = 'the_angle_default_setups'; //priority 20
	$wp_customize->get_section('colors')->panel = 'the_angle_default_setups'; //priority 40
	$wp_customize->get_section('header_image')->panel = 'the_angle_default_setups'; //priority 60
	$wp_customize->get_section('background_image')->panel = 'the_angle_default_setups'; //priority 80
	$wp_customize->get_section('static_front_page')->panel = 'the_angle_default_setups'; //priority 120
   /** Upgrade to The Angle Pro **/
  $wp_customize->register_section_type( 'the_angle_Link_Section' );

  // Register sections.
  $wp_customize->add_section(
      new the_angle_Link_Section(
          $wp_customize,
          'the-angle-pro',
          array(
              'title'    => esc_html__( 'Upgrade To The Angle Pro', 'the-angle' ),
              'pro_text' => esc_html__( 'Go Pro','the-angle' ),
              'pro_url'  => 'https://www.wpthemescloud.com/demo/the-angle-pro/',
              'priority' => 1,
          )
      )
  );
    /*/** Theme Info section **/
  $wp_customize->add_section(
      'the_angle_theme_info_section',
      array(
          'title'   => esc_html__( 'Theme Info', 'the-angle' ),
          'priority'  => 1,
      )
  );
  // More Themes
  $wp_customize->add_setting(
      'the_angle_por_information', 
      array(
          'type'              => 'theme_info',
          'capability'        => 'edit_theme_options',
          'sanitize_callback' => 'esc_attr',
      )
  );
  $wp_customize->add_control( new the_angle_Theme_Info( 
      $wp_customize ,
      'the_angle_por_information',
          array(
            'label' => esc_html__( 'The Angle Pro Theme' , 'the-angle' ),
            'section' => 'the_angle_theme_info_section',
          )
      )
  );

     //Adding general setting panel
  $wp_customize->add_panel('the_angle_general_setups',array(
		'priority' => '30',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('General Setup','the-angle'),
		));
  /****************************************Adding the General Setup section*************************************************/
    //starting logo alignment
  $wp_customize->add_section('the_angle_logo_alignment', array(
       	'priority' => 50,
       	'title' => esc_html__('Logo Alignment', 'the-angle'),
       	'panel' => 'the_angle_general_setups'
	));
  $wp_customize->add_setting('the_angle_logo_alignment', array(
      'default' => 'Left',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'the_angle_alignment_logo',
    ));

  $wp_customize->add_control('the_angle_logo_alignment', array(
      'type' => 'radio',
      'label' => esc_html__('Choose the layout that you want','the-angle'),
      'section' => 'the_angle_logo_alignment',
      'setting' => 'the_angle_logo_alignment',
      'choices' => array(
         'left'=>esc_html__('Left', 'the-angle'),
         'center'=>esc_html__('Center','the-angle'),
      )
    ));
  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'the_angle_logo_upload', array(
		'label' => esc_html__('Upload logo for your site', 'the-angle'),
		'section' => 'the_angle_logo_alignment',
		'setting' => 'the_angle_logo_upload'
	  )));
    //Starting Bredcrumb Setting
  $wp_customize->add_section('the_angle_bredcrumb',array(
    'title' => esc_html__('Page Breadcrumb','the-angle'),
    'priority' => '40',
    'panel' => 'the_angle_general_setups'
    ));

  $wp_customize->add_setting(
    'the_angle_page_bg_image',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    )
   );
   $wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'the_angle_page_bg_image',
           array(
               'label'      => __( 'Page Breadcrumb Backgeound Image', 'the-angle' ),
               'section'    => 'the_angle_bredcrumb',
               'settings'   => 'the_angle_page_bg_image',
               'priority' => 10,
           )
       )
    );
        //starting weblyout setting
     $wp_customize->add_section('the_angle_weblayout', array(
       	'priority' => 7,
       	'title' => esc_html__('Web Layout', 'the-angle'),
       	'panel' => 'the_angle_general_setups'
    	));
     $wp_customize->add_setting('the_angle_home_weblayout', array(
      'default' => 'fullwidth',
      'capability' => 'edit_theme_options',
      'sanitize_callback' => 'the_angle_webpagelayout',
      ));

     $wp_customize->add_control('the_angle_home_weblayout', array(
      'type' => 'radio',
      'label' => esc_html__('Choose the layout that you want', 'the-angle'),
      'section' => 'the_angle_weblayout',
      'setting' => 'the_angle_home_weblayout',
      'choices' => array(
         'fullwidth' => esc_html__('Full  Layout', 'the-angle'),
         'boxed' => esc_html__('Boxed Layout', 'the-angle')
      )
      ));
        //Enable/Disable for General setup
  $wp_customize->add_section('the_angle_search_option',array(
		'priority' => '10',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('Header Search ','the-angle'),
		'description' => esc_html__('Enable/Disable Header Search','the-angle'),
		'panel' => 'the_angle_general_setups'
		));
	$wp_customize->add_setting('the_angle_top_header',
                    array(
		                'default'           =>  'no',
		                'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
		                )
		            );
  $wp_customize->add_control('the_angle_top_header',array(
		                'description'   =>  esc_html__('Do you want to enable search on header','the-angle'),
		                'section'       =>  'the_angle_search_option',
		                'setting'       =>  'the_angle_top_header',
		                'priority'      =>  5,
		                'type'          =>  'radio',
		                'choices'        =>  array(
		                    'yes'   =>  esc_html__('Yes','the-angle'),
		                    'no'    =>  esc_html__('No','the-angle')
		                    )
		                )
		            );
  $wp_customize->add_section('the_angle_top_header_cart',array(
                        'priority' => '10',
                        'capability' => 'edit_theme_options',
                        'theme_supports' => '',
                        'title' => esc_html__('Show Header Menu Cart','the-angle'),
                        'description' => esc_html__('Manage Header Menu Cart','the-angle'),
                        'panel' => 'the_angle_general_setups'
                    ));
     //Enable/Disable Search
  $wp_customize->add_setting('the_angle_general_cart',
                    array(
                        'default'           =>  'no',
                        'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                        )
                    );
  $wp_customize->add_control('the_angle_general_cart',array(
                        'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                        'section'       =>  'the_angle_top_header_cart',
                        'setting'       =>  'the_angle_general_cart',
                        'priority'      =>  5,
                        'type'          =>  'radio',
                        'choices'        =>  array(
                            'yes'   =>  esc_html__('Yes','the-angle'),
                            'no'    =>  esc_html__('No','the-angle')
                            )
                        )
                    );
	/************************************Adding the Homepage Setup Panel**********************************************/
  $wp_customize->add_panel('the_angle_homepage_setups',array(
		'priority' => '30',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('Homepage Setups','the-angle'),
		));

    //Adding the Slider Setup Panel
	$wp_customize->add_section('the_angle_slider_setups',array(
		'priority' => '01',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('Slider Section','the-angle'),
		'description' => esc_html__('Manage Slides for the site','the-angle'),
		'panel' => 'the_angle_homepage_setups'
		));
    	//slider section
	$wp_customize->add_setting('the_angle_homepage_slider_section',
                    array(
		                'default'           =>  'no',
		                'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
		                )
		            );
  $wp_customize->add_control('the_angle_homepage_slider_section',array(
		                'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
		                'section'       =>  'the_angle_slider_setups',
		                'setting'       =>  'the_angle_homepage_slider_section',
		                'priority'      =>  5,
		                'type'          =>  'radio',
		                'choices'        =>  array(
		                    'yes'   =>  esc_html__('Yes','the-angle'),
		                    'no'    =>  esc_html__('No','the-angle')
		                    )
		                )
		            );
     //select category for slider
  $wp_customize->add_setting('the_angle_slider_section_category',array(
		                'default'           =>  '0',
		                'sanitize_callback' =>  'the_angle_sanitize_category_select',
		                )
		            );
  $wp_customize->add_control(
		            'the_angle_slider_section_category',array(
		                'priority'      =>  20,
		                'label'         =>  esc_html__('Select category','the-angle'),
		                'section'       =>  'the_angle_slider_setups',
		                'setting'       =>  'the_angle_slider_section_category',
		                'type'          =>  'select',
		                'choices'       =>  $the_angle_category_lists
		                )
		            );
     //slider read more text
  $wp_customize->add_setting(
		            'the_angle_slider_readmore',array(
		                'default'           =>  esc_html__('Know more','the-angle'),
		                'sanitize_callback' =>  'sanitize_text_field',
		                )
		            );

  $wp_customize->add_control(
		            'the_angle_slider_readmore',array(
		                'priority'      =>  25,
		                'label'         =>  esc_html__('Read more text','the-angle'),
		                'section'       =>  'the_angle_slider_setups',
		                'setting'       =>  'the_angle_slider_readmore',
		                'type'          =>  'text',
		                )
		            );
     //Starting About Us Section
  $wp_customize->add_section('the_angle_about_setups',array(
		'priority' => '01',
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__('About Us Section','the-angle'),
		'description' => esc_html__('Manage Slides for the site','the-angle'),
		'panel' => 'the_angle_homepage_setups'
		));
	$wp_customize->add_setting('the_angle_about_section',
                    array(
		                'default'           =>  'no',
		                'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
		                )
		            );
  $wp_customize->add_control('the_angle_about_section',array(
		                'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
		                'section'       =>  'the_angle_about_setups',
		                'setting'       =>  'the_angle_about_section',
		                'priority'      =>  5,
		                'type'          =>  'radio',
		                'choices'        =>  array(
		                    'yes'   =>  esc_html__('Yes','the-angle'),
		                    'no'    =>  esc_html__('No','the-angle')
		                    )
		                )
		            );
    // About Layout
  $wp_customize->add_setting(
  	        'the_angle_about_section_layout',
  	        array(
  	            'default'           => 'layout-1',
  	            'sanitize_callback' => 'sanitize_text_field',
  	        )
  	    );
  $wp_customize->add_control(
  	   'the_angle_about_section_layout',
  	            array(
  	                'label'    => esc_html__( 'About Section Layout', 'the-angle' ),
  	                'section'  => 'the_angle_about_setups',
                      'type' => 'radio',
  	                'choices'  => array(
  		                    'layout-1' => esc_html__( 'Layout 1', 'the-angle' ),
  		                    'layout-2' => esc_html__( 'Layout 2', 'the-angle' ),
  		            ),
  		            'priority' => 6
  	            )
      	    );
      //select post for about section
  $wp_customize->add_setting('the_angle_about_post',array(
            'default' => '',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
        ));
  $wp_customize->add_control('the_angle_about_post', array(
            'type' => 'select',
            'label' => esc_html__('About Us Post','the-angle'),
            'section' => 'the_angle_about_setups',
            'setting' => 'the_angle_about_post',
            'choices' => $posts_list
        ));
        //About Us Title
  $wp_customize->add_setting('the_angle_about_us_title', array(
    		'default' => esc_html__('About Us','the-angle'),
    		'sanitize_callback' => 'sanitize_text_field',
    		));

  $wp_customize->add_control('the_angle_about_us_title',array(
    		'type' => 'text',
    		'label' => esc_html__('About Us  Section Title','the-angle'),
    		'section' => 'the_angle_about_setups',
    		'setting' => 'the_angle_about_us_title'
    		));
  $wp_customize->add_setting(
                    'the_angle_about_readmore',array(
                        'default'           =>  esc_html__('Know more','the-angle'),
                        'sanitize_callback' =>  'sanitize_text_field',
                        )
                    );
  $wp_customize->add_control(
                    'the_angle_about_readmore',array(
                        'priority'      =>  10,
                        'label'         =>  esc_html__('Read more text','the-angle'),
                        'section'       =>  'the_angle_about_setups',
                        'setting'       =>  'the_angle_about_readmore',
                        'type'          =>  'text',
                        )
                        ); 
  //About Us image
  $wp_customize->add_setting('the_angle_about_bkgimage', array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
        ));     

  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'the_angle_about_bkgimage', array(
        'label' => esc_html__('Image for About Us', 'the-angle'),
        'section' => 'the_angle_about_setups',
        'setting' => 'the_angle_about_bkgimage'
        )));         
        
  //Starting Ferature Section
  $wp_customize->add_section('the_angle_feature_setups',array(
        'priority' => '01',
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Feature  Section','the-angle'),
        'description' => esc_html__('Add features for the site','the-angle'),
        'panel' => 'the_angle_homepage_setups'
        ));  	
  $wp_customize->add_setting('the_angle_feature_section',
                        array(
                        'default'           =>  'no',
                        'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                        )
                    );  	
  $wp_customize->add_control('the_angle_feature_section',array(
                        'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                        'section'       =>  'the_angle_feature_setups',
                        'setting'       =>  'the_angle_feature_section',
                        'priority'      =>  5,
                        'type'          =>  'radio',
                        'choices'        =>  array(
                            'yes'   =>  esc_html__('Yes','the-angle'),
                            'no'    =>  esc_html__('No','the-angle')
                            )
                        )
                    );     
  $wp_customize->add_setting(
                  'the_angle_feature_section_layout',
                  array(
                      'default'           => 'layout-1',
                      'sanitize_callback' => 'sanitize_text_field',
                  )
              );     
  $wp_customize->add_control(
             'the_angle_feature_section_layout',
                      array(
                          'label'    => esc_html__( 'Feature Section Layout', 'the-angle' ),
                          'section'  => 'the_angle_feature_setups',
                            'type' => 'radio',
                          'choices'  => array(
                                'layout-1' => esc_html__( 'Layout 1', 'the-angle' ),
                                'layout-2' => esc_html__( 'Layout 2', 'the-angle' ),
                        ),
                        'priority' => 6
                      )
                  );   	
  //Feature Section Title
  $wp_customize->add_setting('the_angle_feature_us_title', array(
        'default' => esc_html__('About Us','the-angle'),
        'sanitize_callback' => 'sanitize_text_field',
        ));      
  $wp_customize->add_control('the_angle_feature_us_title',array(
        'type' => 'text',
        'label' => esc_html__('Feature Section Title','the-angle'),
        'section' => 'the_angle_feature_setups',
        'setting' => 'the_angle_feature_us_title'
        ));
    	    
    //select category for feature section
  $wp_customize->add_setting('the_angle_feature_section_category',array(
                        'default'           =>  '0',
                        'sanitize_callback' =>  'the_angle_sanitize_category_select',
                        )
                    );     	
 $wp_customize->add_control(
                    'the_angle_feature_section_category',array(
                        'priority'      =>  20,
                        'label'         =>  esc_html__('Select category','the-angle'),
                        'section'       =>  'the_angle_feature_setups',
                        'setting'       =>  'the_angle_feature_section_category',
                        'type'          =>  'select',
                        'choices'       =>  $the_angle_category_lists
                        )
                    );       
  //feature read more text
  $wp_customize->add_setting(
                    'the_angle_feature_readmore',array(
                        'default'           =>  esc_html__('Know more','the-angle'),
                        'sanitize_callback' =>  'sanitize_text_field',
                        )
                    );      
  $wp_customize->add_control(
                    'the_angle_feature_readmore',array(
                        'priority'      =>  25,
                        'label'         =>  esc_html__('Read more text','the-angle'),
                        'section'       =>  'the_angle_feature_setups',
                        'setting'       =>  'the_angle_feature_readmore',
                        'type'          =>  'text',
                        )
                    );
        
  //Starting Service Section
  $wp_customize->add_section('the_angle_service_setups',array(
    'priority' => '01',
    'capability' => 'edit_theme_options',
    'theme_supports' => '',
    'title' => esc_html__('Service  Section','the-angle'),
    'description' => esc_html__('Our Services','the-angle'),
    'panel' => 'the_angle_homepage_setups'
    ));   
 	$wp_customize->add_setting('the_angle_service_section',
                    array(
		                'default'           =>  'no',
		                'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
		                )
		            );
  $wp_customize->add_control('the_angle_service_section',array(
                    'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                    'section'       =>  'the_angle_service_setups',
                    'setting'       =>  'the_angle_service_section',
                    'priority'      =>  5,
                    'type'          =>  'radio',
                    'choices'        =>  array(
                        'yes'   =>  esc_html__('Yes','the-angle'),
                        'no'    =>  esc_html__('No','the-angle')
                        )
                    )
                );  
  //Service Section Title
  $wp_customize->add_setting('the_angle_service_title', array(
    'default' => esc_html__('Service Section Title','the-angle'),
    'sanitize_callback' => 'sanitize_text_field',
    ));  

	$wp_customize->add_control('the_angle_service_title',array(
		'type' => 'text',
		'label' => esc_html__('Service Section Title','the-angle'),
		'section' => 'the_angle_service_setups',
		'setting' => 'the_angle_service_title'
		));
  //know more text for service section
  $wp_customize->add_setting(
		            'the_angle_service_section_readmore',array(
		                'default'           =>  esc_html__('Know more','the-angle'),
		                'sanitize_callback' =>  'sanitize_text_field',
		                )
		            );

  $wp_customize->add_control(
		            'the_angle_service_section_readmore',array(
		                'priority'      =>  10,
		                'label'         =>  esc_html__('Read more text','the-angle'),
		                'section'       =>  'the_angle_service_setups',
		                'setting'       =>  'the_angle_service_section_readmore',
		                'type'          =>  'text',
		                )
		            );
    //first service icon
  $wp_customize->add_setting(
    	     'one_service_icon',
    		    array(
    		    'default' => '',
    		    'sanitize_callback' => 'sanitize_text_field',
    		     'transport' => 'postMessage'
    		     )
    	    );
  $wp_customize->add_control( new the_angle_Customize_Icons_Control(
    	    $wp_customize,
    	        'one_service_icon',
    	         array(
    	        'type' 		=> 'the_angle_icons',
    	        'label' 	=> esc_html__( 'First Service Icon', 'the-angle' ),
    	        'description' 	=> esc_html__( 'Choose the icon from lists.', 'the-angle' ),
    	        'section' 	=> 'the_angle_service_setups',
    	            )
    	        )
    	    );
    //select post for service section
  $wp_customize->add_setting('the_angle_service_post1',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field',
        'capability' => 'edit_theme_options',
        'transport' => 'postMessage'
    ));
  $wp_customize->add_control('the_angle_service_post1', array(
        'type' => 'select',
        'label' => esc_html__('Service Post 1','the-angle'),
        'section' => 'the_angle_service_setups',
        'setting' => 'the_angle_service_post1',
        'choices' => $posts_list
    ));  
  //Second service icon
  $wp_customize->add_setting(
          'two_service_icon',
           array(
           'default' => '',
           'sanitize_callback' => 'sanitize_text_field',
            'transport' => 'postMessage'
            )
         );  
  $wp_customize->add_control( new the_angle_Customize_Icons_Control(
         $wp_customize,
             'two_service_icon',
              array(
             'type' 		=> 'the_angle_icons',
             'label' 	=> esc_html__( 'Second Service Icon', 'the-angle' ),
             'description' 	=> esc_html__( 'Choose the icon from lists.', 'the-angle' ),
             'section' 	=> 'the_angle_service_setups',
                 )
             )
         );
      //select post for service section
   $wp_customize->add_setting('the_angle_service_post2',array(
             'default' => '',
             'sanitize_callback' => 'sanitize_text_field',
             'capability' => 'edit_theme_options',
             'transport' => 'postMessage'
         ));

   $wp_customize->add_control('the_angle_service_post2', array(
             'type' => 'select',
             'label' => esc_html__('Service Post 2','the-angle'),
             'section' => 'the_angle_service_setups',
             'setting' => 'the_angle_service_post2',
             'choices' => $posts_list
         ));
       //Second service icon
  $wp_customize->add_setting(
               'three_service_icon',
                array(
                'default' => '',
                'sanitize_callback' => 'sanitize_text_field',
                 'transport' => 'postMessage'
                 )
              );
   $wp_customize->add_control( new the_angle_Customize_Icons_Control(
              $wp_customize,
                  'three_service_icon',
                   array(
                  'type'    => 'the_angle_icons',
                  'label'   => esc_html__( 'Three Service Icon', 'the-angle' ),
                  'description'   => esc_html__( 'Choose the icon from lists.', 'the-angle' ),
                  'section'   => 'the_angle_service_setups',
                      )
                  )
              );     
      //select post for service section
  $wp_customize->add_setting('the_angle_service_post3',array(
                     'default' => '',
                     'sanitize_callback' => 'sanitize_text_field',
                     'capability' => 'edit_theme_options',
                     'transport' => 'postMessage'
                 ));      
   $wp_customize->add_control('the_angle_service_post3', array(
                     'type' => 'select',
                     'label' => esc_html__('Service Post 3','the-angle'),
                     'section' => 'the_angle_service_setups',
                     'setting' => 'the_angle_service_post3',
                     'choices' => $posts_list
                 ));
  //Starting Book And Appoinment Section
  $wp_customize->add_section('the_angle_cta_setups',array(
    'priority' => '9',
    'capability' => 'edit_theme_options',
    'theme_supports' => '',
    'title' => esc_html__('Call To Action Section','the-angle'),
    'description' => esc_html__('Just make an appointment & you are done','the-angle'),
    'panel' => 'the_angle_homepage_setups'
    ));

   $wp_customize->add_setting('the_angle_cta_section',
                                   array(
                                   'default'           =>  'no',
                                   'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                                   )
                               ); 
   $wp_customize->add_control('the_angle_cta_section',array(
                                   'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                                   'section'       =>  'the_angle_cta_setups',
                                   'setting'       =>  'the_angle_cta_section',
                                   'priority'      =>  5,
                                   'type'          =>  'radio',
                                   'choices'        =>  array(
                                       'yes'   =>  esc_html__('Yes','the-angle'),
                                       'no'    =>  esc_html__('No','the-angle')
                                       )
                                   )
                                );   
    //CTA Title
  $wp_customize->add_setting('the_angle_ta_title', array(
    'default' => esc_html__('Our Call To Action','the-angle'),
    'sanitize_callback' => 'sanitize_text_field',
    ));

  $wp_customize->add_control('the_angle_ta_title',array(
    'type' => 'text',
    'label' => esc_html__('Call To Action Section Title','the-angle'),
    'section' => 'the_angle_cta_setups',
    'setting' => 'the_angle_ta_title'
    ));
    //CTA link
  $wp_customize->add_setting('the_angle_link_small', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
    
    ));
  $wp_customize->add_control('the_angle_link_small',array(
    'type' => 'text',
    'label' => esc_html__('Call To Action Link','the-angle'),
    'section' => 'the_angle_cta_setups',
    'setting' => 'the_angle_link_small'
    ));
    //CTA read more
  $wp_customize->add_setting('the_angle_cta_readmore', array(
    'default' => esc_html__('GET AN APPOINTMENT','the-angle'),
    'sanitize_callback' => 'sanitize_text_field',
    'transport' => 'postMessage'
    ));

  $wp_customize->add_control('the_angle_cta_readmore',array(
    'type' => 'text',
    'label' => esc_html__('Call To Action Read More Text','the-angle'),
    'section' => 'the_angle_cta_setups',
    'setting' => 'the_angle_cta_readmore'
    ));
    //CTA Section background image
  $wp_customize->add_setting('the_angle_cta_bkgimage', array(
    'default' => '',
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw'
    ));

  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'the_angle_cta_bkgimage', array(
    'label' => esc_html__('Image for Call To Action', 'the-angle'),
    'section' => 'the_angle_cta_setups',
    'setting' => 'the_angle_cta_bkgimage'
    )));       
      //Starting Team Section                   
  $wp_customize->add_section('the_angle_team_setups',array(
        'priority' => '10',
        'capability' => 'edit_theme_options',
        'theme_supports' => '',
        'title' => esc_html__('Team Section','the-angle'),
        'description' => esc_html__('Manage Team Sections','the-angle'),
        'panel' => 'the_angle_homepage_setups'
        ));      
    //Enable/Disable Team Section
  $wp_customize->add_setting('the_angle_team_section',
                           array(
                          'default'           =>  'no',
                          'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                          )
                      );       
   $wp_customize->add_control('the_angle_team_section',array(
                          'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                          'section'       =>  'the_angle_team_setups',
                          'setting'       =>  'the_angle_team_section',
                          'priority'      =>  5,
                          'type'          =>  'radio',
                          'choices'        =>  array(
                              'yes'   =>  esc_html__('Yes','the-angle'),
                              'no'    =>  esc_html__('No','the-angle')
                              )
                          )
                      );      
  $wp_customize->add_setting(
    	        'the_angle_team_section_layout',
    	        array(
    	            'default'           => 'layout-1',
    	            'sanitize_callback' => 'sanitize_text_field',
    	        )
    	    );
  $wp_customize->add_control(
         'the_angle_team_section_layout',
                  array(
                      'label'    => esc_html__( 'Team Section Layout', 'the-angle' ),
                      'section'  => 'the_angle_team_setups',
                        'type' => 'radio',
                      'choices'  => array(
                            'layout-1' => esc_html__( 'Layout 1', 'the-angle' ),
                            'layout-2' => esc_html__( 'Layout 2', 'the-angle' ),
                    ),
                    'priority' => 6
                  )
          );  	
  //Service Section Title
   $wp_customize->add_setting('the_angle_team_title', array(
          'default' => esc_html__('Service Section Title','the-angle'),
          'sanitize_callback' => 'sanitize_text_field',
          ));               
  $wp_customize->add_control('the_angle_team_title',array(
          'type' => 'text',
          'label' => esc_html__('Service Section Title','the-angle'),
          'section' => 'the_angle_team_setups',
          'setting' => 'the_angle_team_title'
          ));     
          //select category for Team
  $wp_customize->add_setting('the_angle_team_category',array(
                          'default'           =>  '0',
                          'sanitize_callback' =>  'the_angle_sanitize_category_select',
                          )
                      );       
  $wp_customize->add_control(
                      'the_angle_team_category',array(
                          'priority'      =>  20,
                          'label'         =>  esc_html__('Select category','the-angle'),
                          'section'       =>  'the_angle_team_setups',
                          'setting'       =>  'the_angle_team_category',
                          'type'          =>  'select',
                          'choices'       =>  $the_angle_category_lists
                          )
                      );        
  //Starting Counter Section
  $wp_customize->add_section('the_angle_counter_setups',array(
                  'priority' => '10',
                  'capability' => 'edit_theme_options',
                  'theme_supports' => '',
                  'title' => esc_html__('Counter Section','the-angle'),
                  'description' => esc_html__('Manage Counter Section','the-angle'),
                  'panel' => 'the_angle_homepage_setups'
                  ));      
    //Enable/Disble Counter	Section
  $wp_customize->add_setting('the_angle_counter_section',
                      array(
                    'default'           =>  'no',
                     'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                            )
                      );
  $wp_customize->add_control('the_angle_counter_section',array(
                       'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                         'section'       =>  'the_angle_counter_setups',
                        'setting'       =>  'the_angle_counter_section',
                        'priority'      =>  1,
                        'type'          =>  'radio',
                        'choices'        =>  array(
                         'yes'   =>  esc_html__('Yes','the-angle'),
                          'no'    =>  esc_html__('No','the-angle')
                                      )
                                  )
                              );          
        
		        //first counter
  $the_angle_separator_label = array( 'First', 'Second', 'Third',);
  $the_angle_default_fact_icon = array( 'fa-coffee', 'fa-rocket', 'fa-code',);
  $the_angle_default_fact_title = array( 'PROJECT DONE', 'PEOPLE LOVED', 'AWARDS');
  $the_angle_default_fact_number = array( '798', '237', '54871',);
  $the_angle_separator_label = array( 'First', 'Second', 'Third',);
  $the_angle_default_fact_icon = array( 'fa-coffee', 'fa-rocket', 'fa-code',);
  $the_angle_default_fact_title = array( 'Clients We Have', 'X-Rays Done', 'Live Saved');
  $the_angle_default_fact_number = array( '999', '999', '999',);
     
          //first counter
  $wp_customize->add_setting(
           'counter_icon_sec_separator',
    		  array(
		       'default' => '',
                 'sanitize_callback' => 'sanitize_text_field',
                  		   )
                  	 );
  $wp_customize->add_control( new the_angle_Customize_Section_Separator(
                        $wp_customize,
                        'counter_icon_sec_separator',
                        array(
                        'type'    => 'the_angle_separator',
                            'label'   => esc_html__( ' First  Counter', 'the-angle' ),
                            'section'   => 'the_angle_counter_setups',
                             'priority'  => '2'
                                )
                            )
                        );       
$wp_customize->add_setting(
                      'first_counter_title',
                    array(
                    'default' => 'fa-rocket',
                        'sanitize_callback' => 'sanitize_text_field',
                        'transport' => 'postMessage'
                             )
                        );
   $wp_customize->add_control(
                     'first_counter_title',
                            array(
                          'type' => 'text',
                          'label' => esc_html__( 'Counter Title', 'the-angle' ),
                          'section' => 'the_angle_counter_setups',
                          'priority' => '3'
                            )
                        );      
  $wp_customize->add_setting(
                    'first_counter_number',
                            array(
                            'default' => '1243',
                            'sanitize_callback' => 'sanitize_text_field',
                            'transport' => 'postMessage'
                          )
                        );     
   $wp_customize->add_control(
                    'first_counter_number',
                        array(
                      'type' => 'number',
                      'label' => esc_html__( 'counter Number', 'the-angle' ),
                      'section' => 'the_angle_counter_setups',
                         'priority' => '4'
                                )
                        );
   $wp_customize->add_setting(
                 'first_counter_icon',
                  array(
               'default' => 'fa-coffee',
                   'sanitize_callback' => 'sanitize_text_field',
                   'transport' => 'postMessage'
                           )
                        );   
  $wp_customize->add_control( new the_angle_Customize_Icons_Control(
           $wp_customize,
            'first_counter_icon',
                  array(
                   'type'     => 'the_angle_icons',
                    'label'   => esc_html__( 'counter Icon', 'the-angle' ),
                  'description'   => esc_html__( 'Choose the icon from lists.', 'the-angle' ),
                      'section'   => 'the_angle_counter_setups',
                          'priority'  => '5',
                                )
                            )
                        );  
    // second counter
   $wp_customize->add_setting(
                   'counter_icon_sec_separator_two',
                array(
                   'default' => '1534',
                   'sanitize_callback' => 'sanitize_text_field',
                            )
                        );          
  $wp_customize->add_control( new the_angle_Customize_Section_Separator(
                   $wp_customize,
                   'counter_icon_sec_separator_two',
                      array(
                      'type'    => 'the_angle_separator',
                            'label'   => esc_html__( 'Second  Counter', 'the-angle' ),
                            'section'   => 'the_angle_counter_setups',
                             'priority'  => '6'
                                )
                            )
                        );             
  $wp_customize->add_setting(
                 'second_counter_title',
                  array(
                    'default' =>('Clients We Have'),
                        'sanitize_callback' => 'sanitize_text_field',
                        'transport' => 'postMessage'
                             )
                  );
   $wp_customize->add_control(
                  'second_counter_title',
                     array(
                      'type' => 'text',
                      'label' => esc_html__( ' Counter Title', 'the-angle' ),
                          'section' => 'the_angle_counter_setups',
                          'priority' => '7'
                                )
                        );                       
                 
   $wp_customize->add_setting(
                  'second_counter_number',
                         array(
                        'default' => '798',
                         'sanitize_callback' => 'sanitize_text_field',
                        'transport' => 'postMessage'
                              )
                        );               
  $wp_customize->add_control(
                  'second_counter_number',
                    array(
                      'type' => 'number',
                       'label' => esc_html__( 'counter Number', 'the-angle' ),
                       'section' => 'the_angle_counter_setups',
                       'priority' => '8'
                                )
                        );             
  $wp_customize->add_setting(
                  'second_counter_icon',
                    array(
                       'default' => 'fa-rocket',
                       'sanitize_callback' => 'sanitize_text_field',
                       'transport' => 'postMessage'
                              ));
   $wp_customize->add_control( new the_angle_Customize_Icons_Control(
                    $wp_customize,
                     'second_counter_icon',
                         array(
                          'type' => 'the_angle_icons',
                            'label'=> esc_html__( 'counter Icon', 'the-angle' ),
                            'description' => esc_html__( 'Choose the icon from lists.', 'the-angle' ),
                                 'section'  => 'the_angle_counter_setups',
                                  'priority'  => '9',
                                )
                            )
                        );                      

        //third counter
  $wp_customize->add_setting(
                        'counter_icon_sec_separator_three',
                      array(
                          'default' => '',
                                  'sanitize_callback' => 'sanitize_text_field',
                            )
                        );                
  $wp_customize->add_control( new the_angle_Customize_Section_Separator(
                        $wp_customize,
                        'counter_icon_sec_separator_three',
                        array(
                        'type'    => 'the_angle_separator',
                            'label'   => esc_html__( ' Third Counter', 'the-angle' ),
                            'section'   => 'the_angle_counter_setups',
                             'priority'  => '9'
                                )
                            )
                        );                
   $wp_customize->add_setting(
                     'third_counter_title',
                        array(
                        'default' =>('Live Saved'),
                        'sanitize_callback' => 'sanitize_text_field',
                        'transport' => 'postMessage'
                             )
                        );               
  $wp_customize->add_control(
                  'third_counter_title',
                       array(
                      'type' => 'text',
                      'label' => esc_html__( '  Counter Title', 'the-angle' ),
                          'section' => 'the_angle_counter_setups',
                                  'priority' => '10'
                                )
                        );                
  $wp_customize->add_setting(
                    'third_counter_number',
                        array(
                        'default' => '54871',
                            'sanitize_callback' => 'sanitize_text_field',
                             'transport' => 'postMessage'
                              )
                        );                
  $wp_customize->add_control(
                    'third_counter_number',
                        array(
                          'type' => 'number',
                              'label' => esc_html__( 'counter Number', 'the-angle' ),
                              'section' => 'the_angle_counter_setups',
                              'priority' => '10'
                                )
                        );                 
  $wp_customize->add_setting(
                    'third_counter_icon',
                    array(
                        'default' => '',
                       'sanitize_callback' => 'sanitize_text_field',
                        'transport' => 'postMessage'
                              )
                        );                
  $wp_customize->add_control( new the_angle_Customize_Icons_Control(
                  $wp_customize,
                    'third_counter_icon',
                    array(
                        'type'    => 'the_angle_icons',
                        'label'   => esc_html__( 'counter Icon', 'the-angle' ),
                        'description'   => esc_html__( 'Choose the icon from lists.', 'the-angle' ),
                        'section'   => 'the_angle_counter_setups',
                        'priority'  => '10',
                              )
                            )
                        );                

      //Counter Background Image
  $wp_customize->add_setting('the_angle_counter_bkgimage', array(
                  'default' => '',
                  'capability' => 'edit_theme_options',
                  'sanitize_callback' => 'esc_url_raw'
                  ));
  $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'the_angle_counter_bkgimage', array(
                  'label' => esc_html__('Background Image for Counter', 'the-angle'),
                  'section' => 'the_angle_counter_setups',
                  'setting' => 'the_angle_counter_bkgimage'
                  )));            	

  //Starting Shop Section
  $wp_customize->add_section('the_angle_shop_setups',array(
                          'priority' => '10',
                          'capability' => 'edit_theme_options',
                          'theme_supports' => '',
                          'title' => esc_html__('Shop Section','the-angle'),
                          'description' => esc_html__('Shop From Our Store','the-angle'),
                          'panel' => 'the_angle_homepage_setups'
                      ));                    
    // Enable/Disable This Section
  $wp_customize->add_setting('the_angle_shop',
                          array(
                              'default'           =>  'no',
                              'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                          )
                      );                    
   $wp_customize->add_control('the_angle_shop',array(
                          'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                          'section'       =>  'the_angle_shop_setups',
                          'setting'       =>  'the_angle_shop',
                          'priority'      =>  5,
                          'type'          =>  'radio',
                          'choices'        =>  array(
                              'yes'   =>  esc_html__('Yes','the-angle'),
                              'no'    =>  esc_html__('No','the-angle')
                              )
                          )
                      );                   
  $wp_customize->add_setting(
                          'the_angle_shop_title',
                          array(
                              'default' => '',
                              'transport'=>'postMessage',
                              'sanitize_callback' => 'sanitize_text_field'
                          )
                       );                     
  $wp_customize->add_control(
                          'the_angle_shop_title',
                          array(
                              'label' => esc_html__('Shop Section Title','the-angle'),
                              'type' => 'text',
                              'priority' => 6,
                              'section' => 'the_angle_shop_setups'
                          )
                       );                                   
  //Starting Gallery Sections
  $wp_customize->add_section('the_angle_gallery_section', array(
                       'priority' => 10,
                       'title' => __('Gallery Section', 'the-angle'),
                       'panel' => 'the_angle_homepage_setups',
                 ));                 
                
   $wp_customize->add_setting('the_angle_galery_section',
                                   array(
                                   'default'           =>  'no',
                                   'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                                   )
                               ); 
   $wp_customize->add_control('the_angle_galery_section',array(
                                   'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                                   'section'       =>  'the_angle_gallery_section',
                                   'setting'       =>  'the_angle_galery_section',
                                   'priority'      =>  5,
                                   'type'          =>  'radio',
                                   'choices'        =>  array(
                                       'yes'   =>  esc_html__('Yes','the-angle'),
                                       'no'    =>  esc_html__('No','the-angle')
                                       )
                                   )
                                ); 
          //Gallery Title
   $wp_customize->add_setting('the_angle_gallery_title', array(
                       'default' => __('Gallery','the-angle'),
                           'sanitize_callback' => 'sanitize_text_field',
                           'transport' => 'postMessage'
                     ));                   
   $wp_customize->add_control('the_angle_gallery_title',array(
                           'type' => 'text',
                           'label' => __('Gallery Section Title','the-angle'),
                           'section' => 'the_angle_gallery_section',
                           'setting' => 'the_angle_gallery_title'
                       ));
  //select category for Gallery
  $wp_customize->add_setting('the_angle_gallery_section_category',array(
                            'default'           =>  '0',
                            'sanitize_callback' =>  'the_angle_sanitize_category_select',
                            )
                        );        
  $wp_customize->add_control(
                        'the_angle_gallery_section_category',array(
                            'priority'      =>  20,
                            'label'         =>  esc_html__('Select category','the-angle'),
                            'section'       =>  'the_angle_gallery_section',
                            'setting'       =>  'the_angle_gallery_section_category',
                            'type'          =>  'select',
                            'choices'       =>  $the_angle_category_lists
                            )
                        );                                                                       
   //Starting Testimonial Section
  $wp_customize->add_section('the_angle_testimonial_setups',array(
                'priority' => '01',
                'capability' => 'edit_theme_options',
                'theme_supports' => '',
                'title' => esc_html__('Testimonial Section','the-angle'),
                'description' => esc_html__('Manage Slides for the site','the-angle'),
                'panel' => 'the_angle_homepage_setups'
                ));            
  $wp_customize->add_setting('the_angle_testimonial_section',
                                array(
                                'default'           =>  'no',
                                'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                                )
                            );            
  $wp_customize->add_control('the_angle_testimonial_section',array(
                                'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                                'section'       =>  'the_angle_testimonial_setups',
                                'setting'       =>  'the_angle_testimonial_section',
                                'priority'      =>  5,
                                'type'          =>  'radio',
                                'choices'        =>  array(
                                    'yes'   =>  esc_html__('Yes','the-angle'),
                                    'no'    =>  esc_html__('No','the-angle')
                                    )
                                )
                            );              
    // Testimonial Layout
    $wp_customize->add_setting(
                        'the_angle_testimonial_section_layout',
                        array(
                            'default'           => 'layout-1',
                            'sanitize_callback' => 'sanitize_text_field',
                        )
                    );            
  $wp_customize->add_control(
                   'the_angle_testimonial_section_layout',
                            array(
                                'label'    => esc_html__( 'Testimonial Section Layout', 'the-angle' ),
                                'section'  => 'the_angle_testimonial_setups',
                                  'type' => 'radio',
                                'choices'  => array(
                                      'layout-1' => esc_html__( 'Layout 1', 'the-angle' ),
                                      'layout-2' => esc_html__( 'Layout 2', 'the-angle' ),
                              ),
                              'priority' => 6
                            )
                    );              
   //select category for testimonial section
  $wp_customize->add_setting('the_angle_testimonial_section_category',array(
                                    'default'           =>  '0',
                                    'sanitize_callback' =>  'the_angle_sanitize_category_select',
                                    )
                                );
  $wp_customize->add_control(
                                'the_angle_testimonial_section_category',array(
                                    'priority'      =>  6,
                                    'label'         =>  esc_html__('Select category','the-angle'),
                                    'section'       =>  'the_angle_testimonial_setups',
                                    'setting'       =>  'the_angle_testimonial_section_category',
                                    'type'          =>  'select',
                                    'choices'       =>  $the_angle_category_lists
                                    )
                                );                                        
   //Testimonial  Title
   $wp_customize->add_setting('the_angle_testimonial_us_title', array(
                'default' => esc_html__('Our Testimonial Section','the-angle'),
                'sanitize_callback' => 'sanitize_text_field',
                ));           
  $wp_customize->add_control('the_angle_testimonial_us_title',array(
                'type' => 'text',
                'label' => esc_html__('Testimonial  Section Title','the-angle'),
                'section' => 'the_angle_testimonial_setups',
                'setting' => 'the_angle_testimonial_us_title'
                ));
    //starting client section
   $wp_customize->add_section('the_angle_our_client__setups',array(
            'priority' => '10',
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__('Our Client Section','the-angle'),
            'description' => esc_html__('Manage Your Client','the-angle'),
            'panel' => 'the_angle_homepage_setups'
            ));         
  $wp_customize->add_setting('the_angle_client_section',
                  array(
                  'default'           =>  'no',
                  'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                  )
              );         
  $wp_customize->add_control('the_angle_client_section',array(
                  'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                  'section'       =>  'the_angle_our_client__setups',
                  'setting'       =>  'the_angle_client_section',
                  'priority'      =>  5,
                  'type'          =>  'radio',
                  'choices'        =>  array(
                      'yes'   =>  esc_html__('Yes','the-angle'),
                      'no'    =>  esc_html__('No','the-angle')
                      )
                  )
              );          
    $wp_customize->add_setting(
            'the_angle_client_section_layout',
            array(
            'default'           => 'layout-1',
            'sanitize_callback' => 'sanitize_text_field',
            )
            );        
  $wp_customize->add_control(
            'the_angle_client_section_layout',
            array(
                'label'    => esc_html__( 'Client Section Layout', 'the-angle' ),
                'section'  => 'the_angle_our_client__setups',
                  'type' => 'radio',
                'choices'  => array(
                      'layout-1' => esc_html__( 'Layout 1', 'the-angle' ),
                      'layout-2' => esc_html__( 'Layout 2', 'the-angle' ),
              ),
              'priority' => 6
            )
            );          
  //Client Section Title
  $wp_customize->add_setting('the_angle_client_title', array(
            'default' => esc_html__('Our Client','the-angle'),
            'sanitize_callback' => 'sanitize_text_field',
            ));          
  $wp_customize->add_control('the_angle_client_title',array(
            'type' => 'text',
            'label' => esc_html__('Our Client Section Title','the-angle'),
            'section' => 'the_angle_our_client__setups',
            'setting' => 'the_angle_client_title'
            ));     
  //select category for feature section
  $wp_customize->add_setting('the_angle_client_section_category',array(
                  'default'           =>  '0',
                  'sanitize_callback' =>  'the_angle_sanitize_category_select',
                  )
              );          
  $wp_customize->add_control(
              'the_angle_client_section_category',array(
                  'priority'      =>  20,
                  'label'         =>  esc_html__('Select category','the-angle'),
                  'section'       =>  'the_angle_our_client__setups',
                  'setting'       =>  'the_angle_client_section_category',
                  'type'          =>  'select',
                  'choices'       =>  $the_angle_category_lists
                  )
              );          
   /********************************** Footer Panel *********************************************************/
    $wp_customize->add_panel('the_angle_footer_setups',array(
            'priority' => '30',
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__('Footer Setup','the-angle'),
            ));
   $wp_customize->add_section(
        'the_angle_social_link',array(
            'title' =>esc_html__('Footer Social Link','the-angle'),
            'panel' =>'the_angle_footer_setups',
        )
    );
   $wp_customize->add_setting('the_angle_footer_social_section',
                  array(
                  'default'           =>  'no',
                  'sanitize_callback' =>  'the_angle_sanitize_radio_yes_no',
                  )
              );         
  $wp_customize->add_control('the_angle_footer_social_section',array(
                  'description'   =>  esc_html__('Enable/Disable This Section','the-angle'),
                  'section'       =>  'the_angle_social_link',
                  'setting'       =>  'the_angle_footer_social_section',
                  'priority'      =>  5,
                  'type'          =>  'radio',
                  'choices'        =>  array(
                      'yes'   =>  esc_html__('Yes','the-angle'),
                      'no'    =>  esc_html__('No','the-angle')
                      )
                  )
              );     
    $wp_customize->add_setting(
        'the_angle_facebook_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
    $wp_customize->add_setting(
        'the_angle_twitter_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
    $wp_customize->add_setting(
        'the_angle_googleplus_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
    $wp_customize->add_setting(
        'the_angle_youtube_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
    $wp_customize->add_setting(
        'the_angle_pinterest_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
   
    $wp_customize->add_setting(
        'the_angle_linkedin_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
     $wp_customize->add_setting(
        'the_angle_instagram_text',array(
                'default'=>'',
                'sanitize_callback' => 'esc_url_raw',
            )
    );
   $wp_customize->add_control(
        'the_angle_facebook_text', array(
                'label' => esc_html__('Facebook Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
    $wp_customize->add_control(
        'the_angle_twitter_text',array(
                'label' => esc_html__('Twitter Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
    $wp_customize->add_control(
        'the_angle_googleplus_text',array(
                'label' => esc_html__('GooglePlus Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );

    $wp_customize->add_control(
        'the_angle_youtube_text',array(
                'label' => esc_html__('Youtube Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
    $wp_customize->add_control(
        'the_angle_pinterest_text',array(
                'label' => esc_html__('Pinterest Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
    $wp_customize->add_control(
        'the_angle_linkedin_text',array(
                'label' => esc_html__('Linkedin Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
    $wp_customize->add_control(
        'the_angle_instagram_text',array(
                'label' => esc_html__('Instagram Link','the-angle'),
                'section' => 'the_angle_social_link',
                'type' => 'text',
            )
    );
                    
     /** Footer Copyright  Section **/
   $wp_customize->add_section(
                'the_angle_footer_section',
                array(
                    'title' => esc_html__('Bottom Footer','the-angle'),
                    'priority' => 5,
                    'panel' => 'the_angle_footer_setups',
                    'capability' => 'edit_theme_options',
                    'theme_support' => ''
                )
             );          
   $wp_customize->add_setting(
                'the_angle_copyright_text',
                array(
                    'default' => '',
                    'sanitize_callback' => 'sanitize_text_field',
                )
             );         
  $wp_customize->add_control(
                'the_angle_copyright_text',
                array(
                    'label' => esc_html__('Copyright Text','the-angle'),
                    'priority' => 1,
                    'type' => 'text',
                    'section' => 'the_angle_footer_section'
                )
             );           
}
add_action( 'customize_register', 'the_angle_custom_customize_register' );
