<?php
       if( class_exists( 'WP_Customize_Control' ) ):
       
        /**  The Multiple Pro Link **/
        class the_angle_Link_Section extends WP_Customize_Section {
    
            public $type = 'the-angle';
    
            public $pro_text = '';
    
            public $pro_url = '';
    
            public function json() {
                $json = parent::json();
                $json['pro_text'] = $this->pro_text;
                $json['pro_url']  = esc_url( $this->pro_url );
                return $json;
            }
            protected function render_template() { ?>
    
                <li id="custom-section-{{ data.id }}" class="custom-section control-section control-section-{{ data.type }} cannot-expand">
                    <h3 class="custom-section-title">
                        {{ data.title }}
                        <# if ( data.pro_text && data.pro_url ) { #>
                            <a href="{{ data.pro_url }}" class="button button-custom alignright" target="_blank">{{ data.pro_text }}</a>
                        <# } #>
                    </h3>
                </li>
            <?php }
        }
        
        /**
     * Theme info
     */
    class the_angle_Theme_Info extends WP_Customize_Control {
        public function render_content(){

            $our_theme_infos = array(
                'demo' => array(
                   'link' => esc_url( 'https://www.wpthemescloud.com/demo/the-angle/' ),
                   'text' => esc_html__( 'View Demo', 'the-angle' ),
                ),
                'documentation' => array(
                   'link' => esc_url( 'http://wpthemescloud.com/doc/the-angle/' ),
                   'text' => esc_html__( 'Documentation', 'the-angle' ),
                ),
                'support' => array(
                   'link' => esc_url( 'https://www.wpthemescloud.com/index.php/forums/forum/the-consult/' ),
                   'text' => esc_html__( 'Support', 'the-angle' ),
                ),
            );
            foreach ( $our_theme_infos as $our_theme_info ) {
                echo '<p><a target="_blank" href="' . $our_theme_info['link'] . '" >' . esc_html( $our_theme_info['text'] ) . ' </a></p>';
            }
        ?>
        	<label>
        	    <h2 class="customize-title"><?php echo esc_html( $this->label ); ?></h2>
        	    <span class="customize-text_editor_desc">                 
        	        <ul class="admin-pro-feature-list">   
                        <li><span><?php esc_html_e('One Click Demo Import','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Modern and elegant design','the-angle'); ?> </span></li>
                        <li><span><?php esc_html_e('9 Homepage Layouts','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('100% Responsive theme','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Advanced Typography','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Breadcrumb Settings','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Highly configurable home page','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Four Footer Widget Areas','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Sidebar Options','the-angle'); ?> </span></li>
        	            <li><span><?php esc_html_e('Translation ready','the-angle'); ?> </span></li>
                         <li><span><?php esc_html_e('woocommerce Compatible','the-angle'); ?> </span></li>
                         <li><span><?php esc_html_e('Unlimited Theme Color','the-angle'); ?> </span></li>
                         <li><span><?php esc_html_e('8 custom widgets','the-angle'); ?> </span></li>
                          <li><span><?php esc_html_e('Different woocommerce Widgets Section','the-angle'); ?> </span></li>
                        <li><span><?php esc_html_e('WordPress Live Customizer Based','the-angle'); ?> </span></li>
        	        </ul>
        	        <?php $the_angle_pro_link = 'https://www.wpthemescloud.com/demo/the-angle-pro/'; ?>
        	        <a href="<?php echo esc_url($the_angle_pro_link); ?>" class="button button-primary buynow" target="_blank"><?php esc_html_e('Buy Now','the-angle'); ?></a>
        	    </span>
        	</label>
        <?php
        }
    }
    
      
    endif;