<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package the-angle
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php  $bt_nav = get_theme_mod('the_angle_logo_alignment','left');?> 
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'the-angle' ); ?></a>
      <?php  
               $bt_logo_alignment = '';
                $bt_nav_alignment = '';                              
                if($bt_nav=='left'){
                    $bt_logo_alignment = 'logo-left';
                    $bt_nav_alignment = 'menu-left';
                } 
                else{
                    $bt_logo_alignment = 'logo-center';
                    $bt_nav_nav_alignment = 'menu-center';
                }
            ?>            
      <?php  $bt_logo_alignment = get_theme_mod('the_angle_logo_alignment','left');?>    
	<header id="masthead" class="site-header <?php echo esc_attr($bt_logo_alignment);?> ">
     <div class="tc-container">
      		<div class="site-branding">
              <?php if ( function_exists( 'the_custom_logo' ) ): ?>
                  <div class="site-logo">
                      <?php if ( has_custom_logo() ) : ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                             <?php the_custom_logo(); ?>
                               </a>
                           <?php endif; // End logo check. ?>
                       </div>
                        <?php endif; // end custom logo?>
                        <div class="site-text">
                          <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                              <h1 class="site-title"><?php bloginfo( 'name' ); ?></h1>
                                <p class="site-description"><?php bloginfo( 'description' ); ?></p>
                            </a>
                        </div>
                </div><!-- .site-branding -->
      				<label for="toggle" class="icon">
      						 <span class="ham"> </span>
      				 </label>
				      <input type="checkbox" class="menu-toggle" id="toggle" aria-controls="primary-menu" aria-expanded="false">
          		<nav id="site-navigation" class="main-navigation">
          			<?php
          				wp_nav_menu( array(
          					'theme_location' => 'menu-1',
          					'menu_id'        => 'primary-menu',
          				) );
          			?>
          		</nav><!-- #site-navigation -->
              <div class="header-search-wrap clearfix">
                  <?php if(get_theme_mod('the_angle_top_header')!='no'){ ?>
                  <i class="fa fa-search"></i>
                  <?php } ?>
              </div>
               <?php get_search_form();?>
			 				 <?php $the_angle_cart_enable = get_theme_mod('the_angle_general_cart');
         	 			if($the_angle_cart_enable){ ?>
	 							   <div class="cart-header">
          	 					<?php
          						if(is_active_sidebar('the-angle-menu-cart')){?>
          		            <div class="header-cart">
  	 							           <span class="cart-icon">
                	 							 <i class="fa fa-shopping-cart"></i>
                						      <span class="cart-count"><?php echo absint(WC()->cart->get_cart_contents_count()); ?></span>
  			           	 			         </span><?php
                       							dynamic_sidebar('the-angle-menu-cart');?>
  	 							           </div>
  	 							     <?php } ?>
               	 		</div>
  							<?php } ?>
        </div>
	</header><!-- #masthead -->
	<?php
if(is_home() || is_front_page()){
do_action('the_angle_homepage_slider');
} ?>
<!-- Page breadcrumbs -->
<?php 
if(!is_home() && !is_front_page()){
    do_action('the_angle_title'); 
}
?>
<div id="content" class="site-content">
