<?php
/**
 * Sample implementation of the Custom Header feature
 * http://codex.wordpress.org/Custom_Headers
 *
 * You can add an optional custom header image to header.php like so ...
 *
 * @package thbusiness
 */

/**
 * Setup the WordPress core custom header feature.
 *
 * @uses thbusiness_header_style()
 * @uses thbusiness_admin_header_style()
 * @uses thbusiness_admin_header_image()
 */
function thbusiness_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'thbusiness_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '888888',
		'width'                  => 1500,
		'height'                 => 300,
		'flex-height'            => true,
		'wp-head-callback'       => 'thbusiness_header_style',
		'admin-head-callback'    => 'thbusiness_admin_header_style',
		'admin-preview-callback' => 'thbusiness_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'thbusiness_custom_header_setup' );

if ( ! function_exists( 'thbusiness_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see thbusiness_custom_header_setup().
 */
function thbusiness_header_style() {
	$header_text_color = get_header_textcolor();

	/*
	 * If no custom options for text are set, let's bail.
	 * get_header_textcolor() options: Any hex value, 'blank' to hide text. Default: add_theme_support( 'custom-header' ).
	 */
	if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
		return;
	}

	// If we get this far, we have custom styles. Let's do this.
	?>
	<style type="text/css">
	<?php
		// Has the text been hidden?
		if ( 'blank' == $header_text_color ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		// If the user has set a custom color for the text use that
		else :
	?>
		.site-title a,
		.site-description {
			color: #<?php echo $header_text_color; ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif; // thbusiness_header_style

if ( ! function_exists( 'thbusiness_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see thbusiness_custom_header_setup().
 */
function thbusiness_admin_header_style() {
?>
	<style type="text/css">
		.appearance_page_custom-header #headimg {
			border: none;
		}
		#headimg h1,
		#desc {
			font-family: 'PT sans', sans-serif;
		}
		#headimg h1 {
			margin: 15px 0 0 0;
		}
		#headimg h1 a {
			font-size: 36px;
			font-weight: bold;
			text-decoration: none;
		}
		#desc {
			font-size: 12px;
			margin: 5px 0 10px 0;
		}
		#headimg img {
		}
	</style>
<?php
}
endif; // thbusiness_admin_header_style

if ( ! function_exists( 'thbusiness_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see thbusiness_custom_header_setup().
 */
function thbusiness_admin_header_image() {
	$style = sprintf( ' style="color:#%s;"', get_header_textcolor() );
?>
	<div id="headimg">
		<h1 class="displaying-header-text"><a id="name"<?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
		<div class="displaying-header-text" id="desc"<?php echo $style; ?>><?php bloginfo( 'description' ); ?></div>
		<?php if ( get_header_image() ) : ?>
		<img src="<?php header_image(); ?>" alt="<?php bloginfo( 'name' ); ?>" >
		<?php endif; ?>
	</div>
<?php
}
endif; // thbusiness_admin_header_image