<?php get_header(); ?>
<?php
/* make a URL small */
function make_bitly_url($url,$login,$appkey,$format = 'xml',$version = '2.0.1')
{
	//create the URL
	$bitly = 'http://api.bit.ly/shorten?version='.$version.'&longUrl='.urlencode($url).'&login='.$login.'&apiKey='.$appkey.'&format='.$format;
	
	//get the url
	//could also use cURL here
	$response = file_get_contents($bitly);
	
	//parse depending on desired format
	if(strtolower($format) == 'json')
	{
		$json = @json_decode($response,true);
		return $json['results'][$url]['shortUrl'];
	}
	else //xml
	{
		$xml = simplexml_load_string($response);
		return 'http://bit.ly/'.$xml->results->nodeKeyVal->hash;
	}
}
/* usage */
//$short = make_bitly_url('http://domain-to-change.com','username','R_96acc320c5c423e4f5192e006ff24980','json');
//echo 'The short URL is:  '.$short; 
// returns:  http://bit.ly/11Owun
?>
<div class="container_16 contentWrapper">
	<div class="grid_4 sideBox">
    	<div class="padder">
    		<!-- begin sidebar left -->
            <?php include (TEMPLATEPATH . '/sidebar1.php'); ?>
            <!-- end sidebar left -->
        </div>
    </div>
	<div class="grid_8 mainBox">
    
    
    	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
        <div class="postWrapper">
        	<!-- custom image 460 x 300 -->
            <div class="postMainImage">
           		<?php if ( $img = get_post_meta($post->ID, "image", true) ) { ?>
            		<img src="<?php echo $img?>" alt="<?php the_title(); ?>" width="460"/>
                <?php }?>
       		</div>
        	<div class="mainInfoBlock">
            	<div class="authorAvatar"><?php echo get_avatar( get_the_author_email(), '40' ); ?></div><h1><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="header"><?php the_title(); ?></a></h1>
                <span><?php _e('Posted on'); ?> <?php the_time('F jS, Y') ?> <?php _e('by'); ?> <?php the_author() ?></span>
                <div class="clear"></div>
            </div>
        	
        	<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>
			<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
            <div class="clear"></div>
            <div class="clear20"></div>
            <p class="postmetadata">
            	<?php the_tags( 'Tags: ',', '); ?> | Category <?php the_category(', ') ?>
            </p>
            <div class="clear"></div>
        </div>
        
        <div class="ccomment">
			<?php comments_template(); ?>
        </div>
                    
        <?php endwhile; else: ?>
       
        <div class="postWrapper">
    	    <p>Sorry, no posts matched your criteria.</p>
        </div>
        <?php endif; ?>

                
    </div>
    <div class="grid_4 sideBox">
    	<div class="padder">
    		<!-- begin search form -->
            <?php include (TEMPLATEPATH . '/searchform.php'); ?>
            <!-- end search form -->
            <!-- begin sidebar right -->
            <?php include (TEMPLATEPATH . '/sidebar2.php'); ?>
            <!-- end sidebar right -->         
        </div>
    </div>
    <div class="clear"></div>
</div>
<?php wp_footer() ?>
<?php get_footer() ?>