<?php
// child style enqueue
define('TH_JOT_LAYOUT', get_theme_file_uri(). "/images/header-layout-2.png");
add_action('wp_enqueue_scripts', 'th_jot_styles',99);
function th_jot_styles(){
    $themeVersion = wp_get_theme()->get('Version');
    // Enqueue our style.css with our own version
    wp_enqueue_style('jot-shop-style', get_template_directory_uri() . '/style.css',array(), $themeVersion);
    wp_add_inline_style('jot-shop-style', th_jot_custom_styles());
}
function th_jot_customizer_script_registers(){
wp_enqueue_script( 'th_jot_custom_customizer_script', get_theme_file_uri() . '/customizer/js/customizer.js', array("jquery"), '', true  ); 
}
add_action('customize_controls_enqueue_scripts', 'th_jot_customizer_script_registers',100 );

/**********************/
//customize setting
/**********************/

function th_jot_setting( $wp_customize ){
// choose col layout
if(class_exists('Jot_Shop_WP_Customize_Control_Radio_Image')){
        $wp_customize->add_setting(
            'jot_shop_main_header_layout', array(
                'default'           => 'mhdrdefault',
                'sanitize_callback' => 'jot_shop_sanitize_radio',
            )
        );
$wp_customize->add_control(
            new Jot_Shop_WP_Customize_Control_Radio_Image(
                $wp_customize, 'jot_shop_main_header_layout', array(
                    'label'    => esc_html__( 'Header Layout', 'th-jot' ),
                    'section'  => 'jot-shop-main-header',
                    'choices'  => array(
                        'mhdrthree' => array(
                            'url' => JOT_SHOP_MAIN_HEADER_LAYOUT_ONE,
                        ),
                        'mhdrdefault'   => array(
                            'url' => TH_JOT_LAYOUT,
                        ),
                        'mhdrone'   => array(
                            'url' => JOT_SHOP_MAIN_HEADER_LAYOUT_THREE,
                        ),
                        'mhdrtwo' => array(
                            'url' => JOT_SHOP_MAIN_HEADER_LAYOUT_FOUR,
                        ),
                        
                                     
                    ),
                    'priority'   => 1,
                )
            )
        );
}

// theme color
 $wp_customize->add_setting('jot_shop_theme_clr', array(
        'default'        => '#1c798f',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'jot_shop_sanitize_color',
        'transport'         => 'postMessage',
    ));
$wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'jot_shop_theme_clr', array(
        'label'      => __('Theme Color', 'th-jot' ),
        'section'    => 'jot-shop-gloabal-color',
        'settings'   => 'jot_shop_theme_clr',
        'priority' => 1,
    ) ) 
 );

}

add_action( 'customize_register', 'th_jot_setting', 100 );

/***************************/
//custom style
/***************************/
function th_jot_custom_styles(){
$jot_shop_style=""; 
/*********************/
// Global Color Option
/*********************/ 
$jot_shop_theme_clr = esc_html(get_theme_mod('jot_shop_theme_clr','#1c798f'));
  
$jot_shop_style.="a:hover, .jot-shop-menu li a:hover, .jot-shop-menu .current-menu-item a,.top-header .top-header-bar .jot-shop-menu li a:hover, .top-header .top-header-bar  .jot-shop-menu .current-menu-item a,.summary .yith-wcwl-add-to-wishlist.show .add_to_wishlist::before, .summary .yith-wcwl-add-to-wishlist .yith-wcwl-wishlistaddedbrowse.show a::before, .summary .yith-wcwl-add-to-wishlist .yith-wcwl-wishlistexistsbrowse.show a::before,.woocommerce .entry-summary a.compare.button.added:before,.header-icon a:hover,.thunk-related-links .nav-links a:hover,.woocommerce .thunk-list-view ul.products li.product.thunk-woo-product-list .price,.woocommerce .woocommerce-error .button, .woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button,article.thunk-post-article .thunk-readmore.button,.thunk-wishlist a:hover, .thunk-compare a:hover,.woocommerce .thunk-product-hover a.th-button,.woocommerce ul.cart_list li .woocommerce-Price-amount, .woocommerce ul.product_list_widget li .woocommerce-Price-amount,.jot-shop-load-more button,.page-contact .leadform-show-form label,.thunk-contact-col .fa,.summary .yith-wcwl-wishlistaddedbrowse a, .summary .yith-wcwl-wishlistexistsbrowse a,.thunk-title .title:before,.thunk-hglt-icon:hover,.woocommerce .thunk-product-content .star-rating,.thunk-product-cat-list.slider a:hover, .thunk-product-cat-list li a:hover,.site-title span a:hover,.thunk-product-list-section .thunk-list .thunk-product-content .woocommerce-LoopProduct-title:hover, .thunk-product-tab-list-section .thunk-list .thunk-product-content .woocommerce-LoopProduct-title:hover,.thunk-woo-product-list .woocommerce-loop-product__title a:hover,.mobile-nav-tab-category ul[data-menu-style='accordion'] li a:hover, .jot-shop-menu > li > a:hover, .top-header-bar .jot-shop-menu > li > a:hover, .bottom-header-bar .jot-shop-menu > li > a:hover, .jot-shop-menu li ul.sub-menu li a:hover,.header-support-content i,.slider-cat-title a:before,[type='submit'],.header-support-content a:hover,.mhdrthree .site-title span a:hover,.mobile-nav-bar .jot-shop-menu > li > a:hover,.woocommerce .widget_rating_filter ul li .star-rating,.woocommerce .star-rating::before,.woocommerce .widget_rating_filter ul li a,.search-close-btn,.woocommerce .thunk-single-product-summary-wrap .woocommerce-product-rating .star-rating,.woocommerce #alm-quick-view-modal .woocommerce-product-rating .star-rating,.summary .woosw-added:before,.thunk-product .woosw-btn.woosw-added,.thunk-icon .cart-icon a.cart-contents:hover,.taiowc-content:hover .taiowc-icon .th-icon,
.taiowc-content:hover .taiowc-total{color:{$jot_shop_theme_clr};}  .woocommerce a.remove:hover,.thunk-vertical-cat-tab .thunk-heading-wrap:before,.slide-layout-1 .slider-content-caption a.slide-btn{background:{$jot_shop_theme_clr}!important;} 

    .widget_jot_shop_tabbed_product_widget .thunk-woo-product-list:hover .thunk-product{border-color:{$jot_shop_theme_clr};}";

  $jot_shop_style.=".single_add_to_cart_button.button.alt, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit, .woocommerce button.button, .woocommerce input.button,.cat-list a:after,.tagcloud a:hover, .thunk-tags-wrapper a:hover,.ribbon-btn,.btn-main-header,.page-contact .leadform-show-form input[type='submit'],.woocommerce .widget_price_filter .jot-shop-widget-content .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .jot-shop-widget-content .ui-slider .ui-slider-handle,.entry-content form.post-password-form input[type='submit'],#jotshop-mobile-bar,.post-slide-widget .owl-carousel .owl-nav button:hover,.woocommerce div.product form.cart .button,#search-button,#search-button:hover, .woocommerce ul.products li.product .button:hover,.slider-content-caption a.slide-btn,.page-template-frontpage .owl-carousel button.owl-dot, .woocommerce #alm-quick-view-modal .alm-qv-image-slider .flex-control-paging li a,.button.return.wc-backward,.button.return.wc-backward:hover,.woocommerce .thunk-product-hover a.add_to_cart_button:hover,
.woocommerce .thunk-product-hover .thunk-wishlist a.add_to_wishlist:hover,
.thunk-wishlist .yith-wcwl-wishlistaddedbrowse:hover,
.thunk-wishlist .yith-wcwl-wishlistexistsbrowse:hover,
.thunk-quickview a:hover, .thunk-compare .compare-button a.compare.button:hover,
.thunk-woo-product-list .thunk-quickview a:hover,.woocommerce .thunk-product-hover a.th-button:hover,#alm-quick-view-modal .alm-qv-image-slider .flex-control-paging li a.flex-active,.menu-close-btn:hover:before, .menu-close-btn:hover:after,.cart-close-btn:hover:after,.cart-close-btn:hover:before,.cart-contents .count-item,[type='submit']:hover,.comment-list .reply a,.nav-links .page-numbers.current, .nav-links .page-numbers:hover,.woocommerce .thunk-product-image-tab-section .thunk-product-hover a.add_to_cart_button:hover,.woocommerce .thunk-product-slide-section .thunk-product-hover a.add_to_cart_button:hover,.woocommerce .thunk-compare .compare-button a.compare.button:hover,.thunk-product .woosw-btn:hover,.thunk-product .woosc-btn:hover,.woosw-copy-btn input,.thunk-hglt-icon:before,.woocommerce .thunk-woo-product-list span.onsale,a.add_to_cart_button.ajax_add_to_cart,a.add_to_cart_button.ajax_add_to_cart:hover,.product-type-grouped .add-to-cart .button,.product-type-variable .thunk-product .button, .product-type-variable .thunk-product .add-to-cart > a,.cat-icon,#search-box #search-button,.woocommerce a.product_type_variable:hover,
.woocommerce #respond input#submit:hover,.woocommerce a.button:hover,.woocommerce button.button:hover,.woocommerce input.button:hover,#move-to-top,.widget.th-about-me a.read-more:hover,#page.jotshop-site .owl-nav  button.owl-prev:hover,
#page.jotshop-site .owl-nav  button.owl-next:hover,.woocommerce #page.jotshop-site .thunk-product .add-to-cart > a{background:{$jot_shop_theme_clr}}
  .open-cart p.buttons a:hover,
  .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,.thunk-slide .owl-nav button.owl-prev:hover, .thunk-slide .owl-nav button.owl-next:hover, .jot-shop-slide-post .owl-nav button.owl-prev:hover, .jot-shop-slide-post .owl-nav button.owl-next:hover,.thunk-list-grid-switcher a.selected, .thunk-list-grid-switcher a:hover,.woocommerce .woocommerce-error .button:hover, .woocommerce .woocommerce-info .button:hover, .woocommerce .woocommerce-message .button:hover,#searchform [type='submit']:hover,.widget_product_search button[type='submit']:hover,article.thunk-post-article .thunk-readmore.button:hover,.jot-shop-load-more button:hover,.woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,.thunk-top2-slide.owl-carousel .owl-nav button:hover,.product-slide-widget .owl-carousel .owl-nav button:hover, .thunk-slide.thunk-brand .owl-nav button:hover,.thunk-heading-wrap:before,.woocommerce ul.products li.product .thunk-product-hover a.add_to_cart_button:hover,.product-type-variable .thunk-product .button,.product-type-variable .thunk-product .button:hover{background-color:{$jot_shop_theme_clr};} 
  .thunk-product-hover .th-button.add_to_cart_button, .woocommerce ul.products .thunk-product-hover .add_to_cart_button, .woocommerce .thunk-product-hover a.th-button,.open-cart p.buttons a:hover,.thunk-slide .owl-nav button.owl-prev:hover, .thunk-slide .owl-nav button.owl-next:hover, .jot-shop-slide-post .owl-nav button.owl-prev:hover, .jot-shop-slide-post .owl-nav button.owl-next:hover,body .woocommerce-tabs .tabs li a::before,.thunk-list-grid-switcher a.selected, .thunk-list-grid-switcher a:hover,.woocommerce .woocommerce-error .button, .woocommerce .woocommerce-info .button, .woocommerce .woocommerce-message .button,#searchform [type='submit']:hover,.widget_product_search button[type='submit']:hover,article.thunk-post-article .thunk-readmore.button,.woocommerce .thunk-product-hover a.th-button,.jot-shop-load-more button,.thunk-top2-slide.owl-carousel .owl-nav button:hover,.product-slide-widget .owl-carousel .owl-nav button:hover, .thunk-slide.thunk-brand .owl-nav button:hover,.page-contact .leadform-show-form input[type='submit'],.woocommerce .thunk-product-hover a.product_type_simple,.post-slide-widget .owl-carousel .owl-nav button:hover,#page.jotshop-site .owl-nav  button.owl-prev:hover,
#page.jotshop-site .owl-nav  button.owl-next:hover{border-color:{$jot_shop_theme_clr}} .loader {
    border-right: 4px solid {$jot_shop_theme_clr};
    border-bottom: 4px solid {$jot_shop_theme_clr};
    border-left: 4px solid {$jot_shop_theme_clr};}
    .woocommerce .thunk-product-image-cat-slide .thunk-woo-product-list:hover .thunk-product,.woocommerce .thunk-product-image-cat-slide .thunk-woo-product-list:hover .thunk-product,[type='submit']{border-color:{$jot_shop_theme_clr}} .jot-shop-off-canvas-sidebar-wrapper .menu-close-btn:hover,.main-header .cart-close-btn:hover{color:{$jot_shop_theme_clr};}";
  

    return $jot_shop_style;
}

add_action('admin_head', 'th_jot_admin_custom_styles');

function th_jot_admin_custom_styles() {
  echo '<style>
    .tablinks.get-child,
    .child-theme-notice a.child-button{
        display: none!important;
    }
  </style>';
}