<?php

/**
 * @package C4D WordPress theme
 */
global $tet30;

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js">

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if (is_singular() && pings_open(get_queried_object())) : ?>
		<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<div class="site-inner">
			<header id="masthead" class="site-header" role="banner">
				<?php
				if (isset($tet30['footer-global-go-to-top']) && $tet30['footer-global-go-to-top'] === 'yes') {
					echo '<a href="javascript:void(0);" class="tet30-go-to-top"><i class="bx bx-up-arrow-alt"></i></a>';
				}
				?>
				<?php get_template_part(apply_filters('c4d_theme_header_template', 'header-default')); ?>
			</header><!-- .site-header -->

			<div id="content" class="site-content">