<?php
/**
 * The template for displaying item product content in home page template
*/
defined( 'ABSPATH' ) || exit;
$product = wc_get_product(get_the_ID());

$thumbnail_size = '';
if(wp_is_mobile()) {
    $thumbnail_size = 'teri-shop-ecommerce-image-small';
} else {
    $thumbnail_size = 'teri-shop-ecommerce-image-medium';
}
?>
<div class="product-2__item" data-id="<?php echo esc_attr(get_the_ID()); ?>">
    <div class="product-2__item--inner">
        <?php woocommerce_template_loop_product_link_open(); ?>
            <figure class="product-2__item--image ratio57 lazy" data-src="<?php echo esc_attr(get_the_post_thumbnail_url( get_the_ID(), $thumbnail_size )); ?>">
            </figure>
        <?php woocommerce_template_loop_product_link_close(); ?>
        <div class="product-2__content mt-2 mb-0">
            <?php
                woocommerce_template_loop_product_link_open();
                woocommerce_template_loop_product_title();
                woocommerce_template_loop_product_link_close();
            ?>
        </div>
        <div class="my-2"><?php woocommerce_template_loop_price(); ?></div>
        <div class="product__cart mt-auto">
            <?php
            if( $product->is_type('variable') || $product->is_type('grouped') ) {
                woocommerce_template_loop_product_link_open();
                echo esc_html( 'Select Options','teri-shop-ecommerce' );
                woocommerce_template_loop_product_link_close();
            } else {
                echo '<a class="customviewaddtocartbutton" data-id="'.get_the_ID().'" >' . __('Add To Cart', 'teri-shop-ecommerce') . '</a>';
            }
            ?>
        </div>
    </div>
</div>
