<?php
/**
 * The template for displaying item product content in home page template
*/
defined( 'ABSPATH' ) || exit;
$product = wc_get_product(get_the_ID());

$thumbnail_size = '';
if(wp_is_mobile()) {
    $thumbnail_size = 'teri-shop-ecommerce-image-small';
} else {
    $thumbnail_size = 'teri-shop-ecommerce-image-medium';
}
?>
<div class="product__item" data-id="<?php echo esc_attr(get_the_ID()); ?>">
    <div class="product__item--inner">
        <?php woocommerce_template_loop_product_link_open(); ?>
            <figure class="product__item--image ratio57 lazy" data-src="<?php echo esc_attr(get_the_post_thumbnail_url( get_the_ID(), $thumbnail_size )); ?>">
                <div><?php woocommerce_template_loop_price(); ?></div>
            </figure>
        <?php woocommerce_template_loop_product_link_close(); ?>
        <div class="product__content">
            <?php
                woocommerce_template_loop_product_link_open();
                woocommerce_template_loop_product_title();
                woocommerce_template_loop_product_link_close();
            ?>
        </div>
    </div>
</div>
