<?php
    $post_url = get_permalink();
    $is_share = get_theme_mod('crt_manage_single_is_share', true);
    if(!$is_share) {
        return;
    }
    $class_attr = $args['class'];
    $class_attr_inner = $args['class_inner'];
?>
<div class="single-share__icon <?php echo esc_attr($class_attr); ?>">
    <ul class="<?php echo esc_attr($class_attr_inner); ?>">
        <li>
            <a class="facebook button circle" rel="nofollow noopener" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_attr($post_url) ?>" target="_blank"><i class="fa-brands fa-facebook-f fa-fw"></i></a>
        </li>
        <li>
            <a class="twitter button circle" rel="nofollow noopener" href="http://twitter.com/share?text=Far+far+away%2C+behind+the+word+mountains&amp;url=<?php echo esc_attr($post_url) ?>" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
        </li>
        <li>
            <a class="email button circle" rel="nofollow noopener" href="mailto:?subject=Far+far+away%2C+behind+the+word+mountains&amp;body=<?php echo esc_attr($post_url) ?>" target="_blank"><i class="fa fa-envelope"></i></a>
        </li>
        <li>
            <a class="whatsapp button circle" rel="nofollow noopener" href="https://api.whatsapp.com/send?text=<?php echo esc_attr($post_url) ?>" data-action="share/whatsapp/share" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>
        </li>
        <li>
            <a class="single-share__btn-js" rel="nofollow noopener" target="_blank"><i class="fa-solid fa-link"></i></a>
        </li>
    </ul>
</div>
<input id="single-share-url" class="single-share__url" value="<?php echo esc_html($post_url); ?>" />
