<?php
$post_id = get_the_ID();
?>
<section class="single-header single-header__v2">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="breadcrumb-option">
                    <?php do_action('teri_shop_ecommerce_breadcrumb'); ?>
                </div>
            </div>
            <div class="col-12">
                <div class="single-header__inner">
                    <div class="single-header__left">
                        <div class="single-heading-default">
                            <div class="entry d-flex mb-3">
                                <?php teri_shop_ecommerce_entry_options(get_post($post_id), array('class' => 'd-flex justify-content-center', 'entry_date' => true, 'entry_cat' => false, 'entry_author' => true, 'entry_read_time' => false, 'entry_comment' => false, 'entry_view_count' => true)); ?>
                            </div>
                            <?php the_title( '<h1 class="single-heading-default__title">', '</h1>' ); ?>
                            <div class="single-entry__excerpt mt-2">
                                <?php echo teri_shop_ecommerce_excerpt_custom(30, $post_id); ?>
                            </div>
                            <div class="single-entry__cat">
                                <?php teri_shop_ecommerce_entry_category($post_id) ?>
                            </div>
                        </div>
                    </div>
                    <div class="single-header__right">
                        <?php
                        $get_thumbnail_url = get_the_post_thumbnail_url( $post_id );
                        if($get_thumbnail_url) :
                            ?>
                            <img class="lazy" data-src="<?php echo esc_attr($get_thumbnail_url) ?>" alt="<?php get_the_title(); ?>" />
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>