<?php
?>

<div class="form-search">
    <div class="form-search__inner">
        <a class="btn-search-close" href="#" aria-label="Close Search" rel="nofollow">
            <i class="mmb-icon i-close i-large"></i>
            <label><?php esc_html_e( 'Press ESC to close','teri-shop-ecommerce' ); ?></label>
        </a>
        <?php get_search_form(); ?>
        <div class="form-search__reference">
            <h3><?php esc_html_e( 'Or check our Popular Categories...','teri-shop-ecommerce' ); ?></h3>
            <?php
            $terms = get_terms( array(
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
            ) );
            ?>
            <?php if (!is_wp_error($terms)): ?>
                <ul>
                    <?php foreach ($terms as $t): ?>
                        <li><a href="<?php echo esc_url(get_term_link($t)); ?>"><?php echo esc_html($t->name); ?></a></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
    </div>
</div>

