<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Teri_Shop_Ecommerce
 */
?>
<?php
    $class_header = '';
    $header_fix = get_theme_mod('crt_manage_header_fix', true);
?>
<header class="head head--v2 <?php echo esc_attr($header_fix ? 'head--fix':''); ?>">
    <div class="head__inner">
        <div class="head__row">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-3 col-md-5">
                        <div class="d-flex me-auto">
                            <?php get_template_part( 'template-parts/header/header-nav' ); ?>
                        </div>
                    </div>
                    <div class="col-6 col-md-2">
                        <div class="d-flex justify-content-center">
                            <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                        </div>
                    </div>
                    <div class="col-3 col-md-5">
                        <div class="d-flex align-items-center justify-content-end">
                            <?php get_template_part( 'template-parts/header/header-right' ); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part( 'template-parts/header/header-side' ); ?>
    <?php get_template_part( 'template-parts/header/header-form-search' ); ?>
</header>
