<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Teri_Shop_Ecommerce
 */
?>
<?php
    $header_fix = get_theme_mod('crt_manage_header_fix', true);
?>
<header class="head head--v1 <?php echo esc_attr($header_fix ? 'head--fix':''); ?>">
    <div class="head__inner">
        <div class="head__row">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="d-flex justify-content-between">
                            <div class="position-relative">
                                <?php get_template_part( 'template-parts/header/header-logo' ); ?>
                            </div>
                            <div class="mx-auto">
                                <?php get_template_part( 'template-parts/header/header-nav' ); ?>
                            </div>
                            <div class="d-inline-flex align-items-center ms-auto">
                                <?php get_template_part( 'template-parts/header/header-right' ); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php get_template_part( 'template-parts/header/header-side' ); ?>
    <?php get_template_part( 'template-parts/header/header-form-search' ); ?>
</header>
