<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Megan_Minimal_Lightweight_Blog
 */
?>

<?php
    $get_thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'teri-shop-ecommerce-image-medium' );
    $get_permalink = get_permalink();
    $post = get_post();
    $attr_ratio = get_theme_mod('crt_manage_general_post_item_ratio', 'ratio57');
    $enable_excerpt = get_theme_mod('crt_manage_general_post_enable_excerpt', true);
    $post_format = get_post_format($post) ? : 'standard';
    $vertical_align = get_theme_mod('crt_manage_general_post_item_vertical_align', 'align-items-start');
?>
<div id="post-<?php the_ID(); ?>" class="post-list__item mb-4 <?php echo 'post_' . esc_attr($post_format); ?>">
    <div class="post-list__item--inner border-default pb-4">
        <div class="row <?php echo esc_attr($vertical_align); ?>">
            <div class="col-5">
                <a href="<?php echo esc_url($get_permalink); ?>">
                    <figure class="lazy <?php echo esc_attr($attr_ratio); ?>" data-src="<?php echo esc_html($get_thumbnail_url); ?>"></figure>
                </a>
            </div>
            <div class="col-7">
                <div class="post-list__item--content ps-0 ps-md-3">
                    <h3 class="post-list__title mt-0 mb-2"><a href="<?php echo esc_html($get_permalink); ?>"><?php echo get_the_title() ?></a></h3>
                    <?php teri_shop_ecommerce_entry_options($post, array('class' => 'justify-content-center mb-2', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => true)); ?>
                    <?php if($enable_excerpt): ?>
                        <div class="post-list__sub d-none d-md-block">
                            <?php echo get_the_excerpt(get_the_ID()); ?>
                        </div>
                    <?php endif; ?>
                    <?php teri_shop_ecommerce_button_view_more('d-none d-md-block mt-4') ?>
                </div>
            </div>
        </div>
    </div>
</div>