<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Megan_Minimal_Lightweight_Blog
 */
?>

<?php
    $get_thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'teri-shop-ecommerce-image-medium' );
    $get_permalink = get_permalink();
    $post = get_post();
    $attr_ratio = get_theme_mod('crt_manage_general_post_item_ratio', 'ratio43');
    $post_format = get_post_format($post) ? : 'standard';
    $enable_excerpt = get_theme_mod('crt_manage_general_post_enable_excerpt', true);
    $attr_align = get_theme_mod('crt_manage_general_post_item_align', 'text-left');
?>
<div id="post-<?php the_ID(); ?>" class="post-list-large__item mb-4 mb-lg-6 <?php echo 'post_' . esc_attr($post_format); ?>">
    <div class="post-list-large__item--inner border-default <?php echo esc_attr($attr_align); ?>">
        <div class="row">
            <div class="col-12">
                <a href="<?php echo esc_html($get_permalink); ?>">
                    <figure class="lazy <?php echo esc_attr($attr_ratio); ?>" data-src="<?php echo esc_html($get_thumbnail_url); ?>"></figure>
                </a>
                <div class="post-list-large__item--content">
                    <?php teri_shop_ecommerce_entry_options($post, array('class' => 'mt-3 mb-2', 'entry_date' => true, 'entry_cat' => false, 'entry_author' => true)); ?>
                    <h3 class="post-list-large__title">
                        <a href="<?php echo esc_html($get_permalink); ?>"><?php echo get_the_title() ?></a>
                    </h3>
                    <?php teri_shop_ecommerce_entry_options($post, array('class' => 'justify-content-center mb-2', 'entry_date' => false, 'entry_cat' => true, 'entry_author' => false)); ?>
                    <?php if($enable_excerpt): ?>
                        <div class="post-list-large__sub">
                            <?php echo get_the_excerpt(get_the_ID()); ?>
                        </div>
                    <?php endif; ?>
                    <?php teri_shop_ecommerce_button_view_more() ?>
                </div>
            </div>
        </div>
    </div>
</div>