<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Teri_Shop_Ecommerce
 */
?>
<?php
//    $get_thumbnail_url = get_the_post_thumbnail_url( get_the_ID() );
    $get_thumbnail_url = get_the_post_thumbnail_url( get_the_ID(), 'teri-shop-ecommerce-image-medium' );
    $get_permalink = get_permalink();
    $post = get_post();
    $post_format = get_post_format($post) ? : 'standard';
    $attr_align = get_theme_mod('crt_manage_general_post_item_align', 'text-left');
    $attr_ratio = get_theme_mod('crt_manage_general_post_item_ratio', 'ratio57');
    $enable_excerpt = get_theme_mod('crt_manage_general_post_enable_excerpt', true);
?>

<div class="post-grid__item--inner">
    <?php if($post_format != 'quote'): ?>
        <div class="position-relative <?php echo esc_attr($attr_align); ?>">
            <div class="post-grid__image">
                <a href="<?php echo esc_html($get_permalink); ?>">
                    <figure class="lazy <?php echo esc_attr($attr_ratio); ?>" data-src="<?php echo esc_html($get_thumbnail_url); ?>"></figure>
                </a>
            </div>
            <div class="post-grid__content">
                <div class="post-grid__content--inner">
                    <h3 class="post-grid__title mt-3"><a href="<?php echo esc_html($get_permalink); ?>"><?php echo get_the_title() ?></a></h3>
                    <?php teri_shop_ecommerce_entry_options($post, array('class' => 'mb-2', 'entry_date' => true, 'entry_cat' => true, 'entry_author' => true)); ?>
                    <?php if($enable_excerpt): ?>
                    <div class="post-grid__sub">
                        <?php echo get_the_excerpt(get_the_ID()); ?>
                    </div>
                    <?php endif; ?>
                    <?php teri_shop_ecommerce_button_view_more() ?>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="post-grid__content">
            <?php teri_shop_ecommerce_entry_options($post, array('class' => 'justify-content-center mb-3', 'entry_date' => true, 'entry_cat' => false, 'entry_author' => false)); ?>
            <h3 class="post-grid__title"><a href="<?php echo esc_html($get_permalink); ?>"><?php echo get_the_title() ?></a></h3>
            <?php teri_shop_ecommerce_entry_options($post, array('class' => 'justify-content-center mb-3', 'entry_date' => false, 'entry_cat' => true, 'entry_author' => true)); ?>
            <div class="post-grid__sub">
                <?php echo get_the_excerpt(get_the_ID()); ?>
            </div>
            <div class="post-grid__btn mt-4">
                <a class="button-default" href="<?php echo esc_html($get_permalink); ?>" title="<?php echo get_the_title() ?>"><?php esc_html_e( 'Discover More','teri-shop-ecommerce' ); ?></a>
            </div>
        </div>
    <?php endif; ?>
</div>
